/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.util.Arrays;
import java.util.Map;
import javax.media.jai.LookupTableJAI;
import org.geotools.api.referencing.operation.MathTransform1D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.util.WeakValueHashMap;

public final class LookupTableFactory {
    private static final Map<LookupTableFactory, LookupTableJAI> pool = new WeakValueHashMap();
    private final int sourceType;
    private final int targetType;
    private final MathTransform1D[] transforms;

    private LookupTableFactory(int sourceType, int targetType, MathTransform1D[] transforms) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.transforms = transforms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupTableJAI create(int sourceType, int targetType, MathTransform1D[] transforms) throws TransformException {
        int nbands = transforms.length;
        for (MathTransform1D transform : transforms) {
            if (transform != null) continue;
            return null;
        }
        Map<LookupTableFactory, LookupTableJAI> map = pool;
        synchronized (map) {
            int offset;
            int length;
            LookupTableFactory key = new LookupTableFactory(sourceType, targetType, transforms);
            LookupTableJAI table = pool.get(key);
            if (table != null) {
                return table;
            }
            switch (sourceType) {
                default: {
                    return null;
                }
                case 0: {
                    length = 256;
                    offset = 0;
                    break;
                }
                case 1: 
                case 2: {
                    if (targetType != 0) {
                        return null;
                    }
                    length = 65536;
                    offset = sourceType == 2 ? Short.MIN_VALUE : 0;
                }
            }
            switch (targetType) {
                default: {
                    return null;
                }
                case 5: {
                    double[][] data = new double[nbands][];
                    double[] buffer = new double[length];
                    int i = length;
                    while (--i >= 0) {
                        buffer[i] = i;
                    }
                    i = nbands;
                    while (--i >= 0) {
                        double[] array = i == 0 ? buffer : (double[])buffer.clone();
                        transforms[i].transform(array, 0, array, 0, array.length);
                        data[i] = array;
                    }
                    table = new LookupTableJAI((double[][])data, offset);
                    break;
                }
                case 4: {
                    float[][] data = new float[nbands][];
                    float[] buffer = new float[length];
                    int i = length;
                    while (--i >= 0) {
                        buffer[i] = i;
                    }
                    i = transforms.length;
                    while (--i >= 0) {
                        float[] array = i == 0 ? buffer : (float[])buffer.clone();
                        transforms[i].transform(array, 0, array, 0, length);
                        data[i] = array;
                    }
                    table = new LookupTableJAI((float[][])data, offset);
                    break;
                }
                case 3: {
                    int[][] data = new int[nbands][];
                    int i = nbands;
                    while (--i >= 0) {
                        MathTransform1D tr = transforms[i];
                        int[] array = new int[length];
                        int j = length;
                        while (--j >= 0) {
                            long v = Math.round(tr.transform((double)(j + offset)));
                            array[j] = (int)Math.min(Math.max(v, Integer.MIN_VALUE), Integer.MAX_VALUE);
                        }
                        data[i] = array;
                    }
                    table = new LookupTableJAI((int[][])data, offset);
                    break;
                }
                case 1: 
                case 2: {
                    int maximum;
                    int minimum;
                    if (targetType == 2) {
                        minimum = Short.MIN_VALUE;
                        maximum = Short.MAX_VALUE;
                    } else {
                        minimum = 0;
                        maximum = 65535;
                    }
                    short[][] data = new short[nbands][];
                    int i = nbands;
                    while (--i >= 0) {
                        MathTransform1D tr = transforms[i];
                        short[] array = new short[length];
                        int j = length;
                        while (--j >= 0) {
                            long v = Math.round(tr.transform((double)(j + offset)));
                            array[j] = (short)Math.min(Math.max(v, (long)minimum), (long)maximum);
                        }
                        data[i] = array;
                    }
                    table = new LookupTableJAI((short[][])data, offset, minimum != 0);
                    break;
                }
                case 0: {
                    byte[][] data = new byte[nbands][];
                    int i = nbands;
                    while (--i >= 0) {
                        MathTransform1D tr = transforms[i];
                        byte[] array = new byte[length];
                        int j = length;
                        while (--j >= 0) {
                            array[j] = (byte)Math.min(Math.max(Math.round(tr.transform((double)(j + offset))), 0L), 255L);
                        }
                        data[i] = array;
                    }
                    table = new LookupTableJAI((byte[][])data, offset);
                    break;
                }
            }
            pool.put(key, table);
            return table;
        }
    }

    public int hashCode() {
        int code = this.sourceType + 37 * this.targetType;
        return code += Arrays.hashCode(this.transforms);
    }

    public boolean equals(Object other) {
        if (other instanceof LookupTableFactory) {
            LookupTableFactory that = (LookupTableFactory)other;
            return this.sourceType == that.sourceType && this.targetType == that.targetType && Arrays.equals(this.transforms, that.transforms);
        }
        return false;
    }
}

