/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.eastwood.ChartEngine;
import org.jfree.eastwood.Parameters;

public class ChartGraphicFactory
implements ExternalGraphicFactory {
    public static final String FORMAT = "application/chart";
    private static final String HTTP_CHART = "http://chart?";
    private static final String SYMBOL_SIZE_DELIM = "symsize=";

    public Icon getIcon(Feature feature, Expression urlExpression, String format, int size) throws Exception {
        String[] chartStrings;
        String url = (String)urlExpression.evaluate((Object)feature, String.class);
        if (!ChartGraphicFactory.validRequest(url, format)) {
            return null;
        }
        String subStr = url.substring(HTTP_CHART.length());
        LinkedList<JFreeChart> charts = new LinkedList<JFreeChart>();
        for (String chartString : chartStrings = subStr.split("~")) {
            if (chartString.startsWith(SYMBOL_SIZE_DELIM)) {
                size = Integer.parseInt(chartString.substring(SYMBOL_SIZE_DELIM.length()));
                continue;
            }
            Map params = Parameters.parseQueryString(chartString);
            charts.add(ChartEngine.buildChart(params));
        }
        return new ImageIcon(this.drawCharts(charts, size));
    }

    private static boolean validRequest(String url, String format) {
        return FORMAT.equals(format) && url.startsWith(HTTP_CHART);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage drawCharts(List<JFreeChart> charts, int size) {
        BufferedImage bi = new BufferedImage(size, size, 6);
        Graphics2D gr = bi.createGraphics();
        int SIZE_INCREMENT = size / charts.size();
        int CENTRE = size / 2;
        int s = size;
        Collections.reverse(charts);
        try {
            for (JFreeChart chart : charts) {
                chart.draw(gr, (Rectangle2D)new Rectangle2D.Double(CENTRE - s / 2, CENTRE - s / 2, s, s));
                s -= SIZE_INCREMENT;
            }
        }
        finally {
            gr.dispose();
        }
        return bi;
    }

    int[] computeChartSize(int size, Map params) {
        String[] sizes = (String[])params.get("chs");
        int[] dims = null;
        if (sizes != null) {
            dims = this.parseCHS(sizes);
        }
        if (dims == null && size <= 0) {
            throw new IllegalArgumentException("Chart size cannot be computed, a SLD size is missing, so is the chs chart param");
        }
        if (size > 0) {
            if (dims == null) {
                dims = new int[]{size, size};
            } else if (dims[0] > dims[1]) {
                dims[1] = dims[1] * size / dims[0];
                dims[0] = size;
            } else {
                dims[0] = dims[0] * size / dims[1];
                dims[1] = size;
            }
        }
        return dims;
    }

    int[] parseCHS(String[] sizes) {
        int[] dims = new int[2];
        String[] xy = sizes[0].split("x");
        if (xy.length != 2) {
            throw new IllegalArgumentException("The chs parameter should be in wxh form, where w and h are measured in pixels");
        }
        dims[0] = Integer.parseInt(xy[0]);
        dims[1] = Integer.parseInt(xy[1]);
        return dims;
    }

    JFreeChart getChart(Feature feature, Expression urlExpression, String format, int size) throws Exception {
        String url = (String)urlExpression.evaluate((Object)feature, String.class);
        if (!ChartGraphicFactory.validRequest(url, format)) {
            return null;
        }
        Map params = Parameters.parseQueryString(url.substring(HTTP_CHART.length()));
        return ChartEngine.buildChart(params);
    }
}

