/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.NumberTick;
import org.jfree.eastwood.GLabelledAxis;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

class GValueAxis3D
extends NumberAxis3D
implements GLabelledAxis {
    private NumberAxis3D axisForAutoLabels = new NumberAxis3D(null);
    private double labelAxisStart = 0.0;
    private double labelAxisEnd = 100.0;
    private List tickLabels;
    private List tickLabelPositions;

    public GValueAxis3D() {
        this.axisForAutoLabels.setRange(0.0, 100.0);
        this.axisForAutoLabels.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.labelAxisStart = 0.0;
        this.labelAxisEnd = 100.0;
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.setLowerMargin(0.0);
        this.setUpperMargin(0.0);
        this.setRange(0.0, 1.0);
        this.setTickLabelPaint(Color.gray);
        this.setTickLabelFont(new Font("Dialog", 0, 11));
    }

    public double getLabelAxisStart() {
        return this.labelAxisStart;
    }

    public void setLabelAxisStart(double start) {
        this.labelAxisStart = start;
    }

    public double getLabelAxisEnd() {
        return this.labelAxisEnd;
    }

    public void setLabelAxisEnd(double end) {
        this.labelAxisEnd = end;
    }

    @Override
    public void setTickLabels(List labels) {
        if (labels == null) {
            throw new IllegalArgumentException("Null 'labels' argument.");
        }
        this.tickLabels = labels;
        this.setAutoTickUnitSelection(false);
    }

    @Override
    public void setTickLabelPositions(List values) {
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        this.tickLabelPositions = values;
        this.setAutoTickUnitSelection(false);
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        if (this.tickLabels.isEmpty()) {
            boolean inverted = this.labelAxisStart > this.labelAxisEnd;
            double range = this.labelAxisEnd - this.labelAxisStart;
            double v0 = this.labelAxisStart + this.getLowerBound() * range;
            double v1 = this.labelAxisStart + this.getUpperBound() * range;
            this.axisForAutoLabels.setRange(Math.min(v0, v1), Math.max(v0, v1));
            this.axisForAutoLabels.setInverted(inverted);
            List ticks = this.axisForAutoLabels.refreshTicks(g2, state, dataArea, edge);
            ArrayList<NumberTick> normalisedTicks = new ArrayList<NumberTick>();
            double min = Math.min(this.labelAxisStart, this.labelAxisEnd);
            double max = Math.max(this.labelAxisStart, this.labelAxisEnd);
            for (NumberTick tick : ticks) {
                double v = tick.getValue();
                double vv = (v - min) / (max - min);
                if (this.axisForAutoLabels.isInverted()) {
                    vv = 1.0 - vv;
                }
                normalisedTicks.add(new NumberTick((Number)new Double(vv), tick.getText(), tick.getTextAnchor(), tick.getRotationAnchor(), tick.getAngle()));
            }
            return normalisedTicks;
        }
        ArrayList<NumberTick> result = new ArrayList<NumberTick>();
        int labelCount = this.tickLabels.size();
        int positionCount = this.tickLabelPositions.size();
        int tickCount = Math.max(labelCount, positionCount);
        TextAnchor anchor = null;
        TextAnchor rotationAnchor = TextAnchor.CENTER;
        if (edge == RectangleEdge.LEFT) {
            anchor = TextAnchor.CENTER_RIGHT;
        } else if (edge == RectangleEdge.BOTTOM) {
            anchor = TextAnchor.TOP_CENTER;
        } else if (edge == RectangleEdge.TOP) {
            anchor = TextAnchor.BOTTOM_CENTER;
        } else if (edge == RectangleEdge.RIGHT) {
            anchor = TextAnchor.CENTER_LEFT;
        }
        for (int i = 0; i < tickCount; ++i) {
            Number tv;
            String tickLabel = null;
            tickLabel = i < labelCount ? this.tickLabels.get(i).toString() : String.valueOf(this.tickLabelPositions.get(i));
            double tickValue = Double.NaN;
            if (i < positionCount && (tv = (Number)this.tickLabelPositions.get(i)) != null) {
                tickValue = (tv.doubleValue() - this.labelAxisStart) / (this.labelAxisEnd - this.labelAxisStart);
            }
            if (Double.isNaN(tickValue)) {
                tickValue = (double)i * (1.0 / (double)Math.max(labelCount - 1, 1));
            }
            NumberTick tick = new NumberTick((Number)new Double(tickValue), tickLabel, anchor, rotationAnchor, 0.0);
            result.add(tick);
        }
        return result;
    }
}

