/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.expression;

import java.util.Map;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.factory.Hints;
import org.geotools.xsd.impl.jxpath.JXPathUtils;

public class MapPropertyAccessorFactory
implements PropertyAccessorFactory {
    private static PropertyAccessor MAP_ACCESSOR = new PropertyAccessor(){

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Map;
        }

        @Override
        public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
            return (T)JXPathUtils.newSafeContext((Object)object, (boolean)true).getValue(xpath);
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException, IllegalArgumentException {
            throw new IllegalAttributeException("not implemented");
        }
    };

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (Map.class.isAssignableFrom(type)) {
            return MAP_ACCESSOR;
        }
        return null;
    }
}

