/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public interface ImageLoader {
    public Image getImage(ImageRecord var1);

    default public Image getSizedImage(ImageRecord ir, Dimension imageSize) {
        Image image = this.getImage(ir);
        if (image != null) {
            return ImageUtils.buildResizedImage(image, imageSize.width, imageSize.height);
        }
        return null;
    }

    default public ImageInputStream getImageInputStream(ImageRecord ir) throws IOException {
        Image image = this.getImage(ir);
        ByteArrayOutputStream bos = ImageUtils.buildByteStreamFromImage(image);
        return new ImageInputStream(new ByteArrayInputStream(bos.toByteArray()), bos.size());
    }

    default public boolean isTransientSource() {
        return false;
    }

    public record ImageInputStream(InputStream inputStream, int len) {
    }
}

