/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import java.io.File;

public record ImageRecord(int imageID, String caption, String picPath, ImageRecordType type) {
    public ImageRecord(int imageID, String caption, String picPath) {
        this(imageID, caption, picPath, ImageRecordType.DEFAULT);
    }

    public static ImageRecord SpecimenImageRecord(int imageID, String caption) {
        return new ImageRecord(imageID, caption, null, ImageRecordType.SPECIMEN);
    }

    public String fileName() {
        String fileName = "";
        if (this.picPath != null) {
            if (this.picPath.lastIndexOf(File.separatorChar) > 0) {
                fileName = this.picPath.substring(this.picPath.lastIndexOf(File.separatorChar) + 1);
            }
            if (fileName.lastIndexOf(46) > 0) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
        }
        return fileName;
    }

    public String getTableName() {
        return this.type.tableName;
    }

    public String getIdColumnName() {
        return this.type.idColumnName;
    }

    public String getDataColumnName() {
        return this.type.dataColumnName;
    }

    private static enum ImageRecordType {
        DEFAULT("SBIMAGE", "image_id", "image_data"),
        SPECIMEN("SPECIMEN_IMAGE", "specimen_image_id", "image");

        private final String tableName;
        private final String idColumnName;
        private final String dataColumnName;

        private ImageRecordType(String tableName, String idColumnName, String dataColumnName) {
            this.tableName = tableName;
            this.idColumnName = idColumnName;
            this.dataColumnName = dataColumnName;
        }
    }
}

