/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageRecordSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ImageRecordServiceImpl
implements ImageRecordService {
    private final Map<Integer, ImageRecordSet> imageSets = new HashMap<Integer, ImageRecordSet>();
    private final Map<Integer, ImageRecord> imageRecords = new HashMap<Integer, ImageRecord>();

    @Override
    public List<ImageRecord> getImageRecords(int imageSetID) {
        ImageRecordSet imageRecordSet = this.imageSets.get(imageSetID);
        if (imageRecordSet != null) {
            return imageRecordSet.getImageRecords();
        }
        return Collections.emptyList();
    }

    @Override
    public ImageRecord getImageRecord(int imageID) {
        return this.imageRecords.get(imageID);
    }

    @Override
    public void deleteImageRecords(int imageSetID) {
        this.imageSets.remove(imageSetID);
    }

    @Override
    public void deleteImageRecord(int imageID) {
        this.imageRecords.remove(imageID);
    }

    @Override
    public void updateCaption(int imageSetID, int imageID, String newCaption) {
        ImageRecordSet imageRecordSet = this.imageSets.get(imageSetID);
        if (imageRecordSet == null) {
            return;
        }
        List<ImageRecord> imageRecords = imageRecordSet.getImageRecords();
        List<ImageRecord> newImageRecords = imageRecords.stream().map(ir -> ir.imageID() == imageID ? new ImageRecord(imageID, newCaption, ir.picPath()) : ir).toList();
        imageRecordSet.setImageRecords(newImageRecords);
    }

    @Override
    public int storeImageSet(int imageSetID, List<ImageRecord> imageRecords, ImageLoader imageSource) {
        if (imageSetID < 1) {
            int newID = this.imageSets.keySet().stream().max(Integer::compareTo).orElse(0) + 1;
            this.imageSets.put(newID, new ImageRecordSet(newID, new ArrayList<ImageRecord>(imageRecords)));
            return newID;
        }
        this.imageSets.put(imageSetID, new ImageRecordSet(imageSetID, new ArrayList<ImageRecord>(imageRecords)));
        return imageSetID;
    }

    @Override
    public int storeImageRecord(ImageRecord imageRecord, ImageLoader imageSource) {
        if (imageRecord.imageID() < 1) {
            Set<Integer> allImageRecordIds = this.imageRecords.keySet();
            allImageRecordIds.addAll(this.imageSets.values().stream().flatMap(imageRecordSet -> imageRecordSet.getImageRecords().stream()).map(ImageRecord::imageID).collect(Collectors.toSet()));
            int newID = allImageRecordIds.stream().max(Integer::compareTo).orElse(0) + 1;
            this.imageRecords.put(newID, new ImageRecord(newID, imageRecord.caption(), imageRecord.picPath()));
            return newID;
        }
        this.imageRecords.put(imageRecord.imageID(), imageRecord);
        return imageRecord.imageID();
    }
}

