/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static Image buildResizedImage(Image image, int width, int height) {
        if (image.getWidth(null) < 0) {
            ImageUtils.loadImage(image);
        }
        float overWidth = (float)image.getWidth(null) / (float)width;
        float overHeight = (float)image.getHeight(null) / (float)height;
        Image resizedImage = overHeight > overWidth ? image.getScaledInstance(-1, height, 2) : image.getScaledInstance(width, -1, 2);
        return resizedImage;
    }

    private static void loadImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ImageUtils.class.getName()).log(Level.WARNING, "Image loading interrupted");
        }
    }

    public static ByteArrayOutputStream buildByteStreamFromImage(Image image) throws IOException {
        BufferedImage bufferedImage = ImageUtils.convertImageToBufferedImage(image);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", os);
        return os;
    }

    public static BufferedImage convertImageToBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            switch (bi.getType()) {
                case 1: 
                case 5: {
                    return bi;
                }
            }
        }
        if (image.getWidth(null) < 0) {
            ImageUtils.loadImage(image);
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bufferedImage;
    }
}

