/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.scheme;

public enum Boundary {
    POSS(1, "Possible", false, false),
    PROB(2, "Probable", false, false),
    CONF(3, "Confident", false, false),
    UNCF(4, "Unconformable", true, true),
    QUNCF(5, "?Unconformable", true, true),
    FAULT(6, "Fault", false, true),
    QFAULT(7, "?Fault", false, true),
    RFAULT(8, "ReverseFault", false, true);

    private final int bndInt;
    private final String descr;
    private final boolean unconformable;
    private final boolean disconformable;

    private Boundary(int bndInt, String descr, boolean uncnf, boolean discnf) {
        this.bndInt = bndInt;
        this.descr = descr;
        this.unconformable = uncnf;
        this.disconformable = discnf;
    }

    public int getBndInt() {
        return this.bndInt;
    }

    public static Boundary getBnd(int bndInt) {
        for (Boundary bnd : Boundary.values()) {
            if (bnd.getBndInt() != bndInt) continue;
            return bnd;
        }
        return null;
    }

    public static Boundary parseBnd(String bnd) {
        for (Boundary b : Boundary.values()) {
            if (!b.descr.equalsIgnoreCase(bnd)) continue;
            return b;
        }
        return CONF;
    }

    public String getDescription() {
        return this.descr;
    }

    public String toString() {
        return this.descr;
    }

    public boolean isUnconformable() {
        return this.unconformable;
    }

    public boolean isDisconformable() {
        return this.disconformable;
    }

    public boolean isFault() {
        return this == FAULT || this == RFAULT || this == QFAULT;
    }
}

