/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.scheme;

public enum UnitEWBoundary {
    NORMAL(0, "None", 0.0f),
    SHAZAM_SMALL(25, "Small", 5.0f),
    SHAZAM_MEDIUM(50, "Medium", 10.0f),
    SHAZAM_LARGE(75, "Large", 20.0f);

    private final Integer bndInt;
    private final String descr;
    private final float amplitude;

    private UnitEWBoundary(Integer bndInt, String descr, float amplitude) {
        this.bndInt = bndInt;
        this.descr = descr;
        this.amplitude = amplitude;
    }

    public Integer getBndInt() {
        return this.bndInt;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public static UnitEWBoundary getBnd(int bndInt) {
        for (UnitEWBoundary bnd : UnitEWBoundary.values()) {
            if (bnd.getBndInt() != bndInt) continue;
            return bnd;
        }
        return NORMAL;
    }

    public static UnitEWBoundary parseBnd(String bnd) {
        for (UnitEWBoundary b : UnitEWBoundary.values()) {
            if (!b.descr.equalsIgnoreCase(bnd)) continue;
            return b;
        }
        return NORMAL;
    }

    public String getDescription() {
        return this.descr;
    }

    public String toString() {
        return this.descr;
    }
}

