/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.slidestore;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SlideBox {
    private final int slideBoxID;
    private final int drawerID;
    private String cellType;
    private String name = "";
    private String collection = "";

    public SlideBox(int slideBoxID, int drawerID, String cellType, String name, String collection) {
        this.slideBoxID = slideBoxID;
        this.drawerID = drawerID;
        this.cellType = cellType;
        this.setName(name);
        this.setCollection(collection);
    }

    public int getSlideBoxID() {
        return this.slideBoxID;
    }

    public int getDrawerID() {
        return this.drawerID;
    }

    public String getCellType() {
        return this.cellType;
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNullElse(name, "").trim();
    }

    public String getCollection() {
        return this.collection;
    }

    public String getCollectionName() {
        Matcher m;
        String collectionName = this.collection;
        if (collectionName.contains(";")) {
            collectionName = this.collection.substring(0, this.collection.indexOf(";"));
        }
        if ((m = Pattern.compile("(.+)\\1+").matcher(collectionName)).find() && m.hitEnd()) {
            String colStart = collectionName.substring(0, collectionName.length() / 2);
            if (m.group().endsWith(colStart)) {
                return colStart;
            }
        }
        return collectionName;
    }

    public void setCollection(String collection) {
        this.collection = Objects.requireNonNullElse(collection, "").trim();
    }

    public String toString() {
        return this.name + ": " + this.getCollectionName() + " (" + this.cellType + ")";
    }
}

