/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.NotNull;
import com.stratadata.model3.validation.Validatable;
import java.awt.Color;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class Category
implements Comparable<Category> {
    @NotEmptyString
    @LimitedLengthString
    private final String mnemonic;
    @LimitedLengthString
    private String name = "";
    @NotNull
    private Discipline discipline;
    private Color colour = Color.BLACK;

    public Category(String mnemonic) {
        this.mnemonic = Objects.requireNonNullElse(mnemonic, "").trim().toUpperCase();
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNullElse(name, "").trim();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        if (colour == null || colour == Color.WHITE) {
            colour = Color.BLACK;
        }
        this.colour = colour;
    }

    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    public String toString() {
        return this.mnemonic;
    }

    public static Category copy(Category category) {
        Category cat = new Category(category.getMnemonic());
        cat.setName(category.getName());
        cat.setDiscipline(category.getDiscipline());
        cat.setColour(category.getColour());
        return cat;
    }

    @Override
    public int compareTo(Category c) {
        return Category.compare(this, c);
    }

    public static int compare(Category o1, Category o2) {
        if (o1 != null && o2 != null) {
            return o1.getMnemonic().compareTo(o2.getMnemonic());
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        return StringUtils.equalsIgnoreCase((CharSequence)this.mnemonic, (CharSequence)other.mnemonic);
    }

    public int hashCode() {
        return Objects.hash(this.mnemonic);
    }

    public static boolean equivalent(Category a, Category b) {
        if (Objects.equals(a, b) && a != null && b != null) {
            return a.getName().equalsIgnoreCase(b.getName()) && a.getDiscipline() == b.getDiscipline() && a.getColour().equals(b.getColour());
        }
        return false;
    }
}

