/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface SynonymService {
    public Optional<Taxon> getPreferredTerm(int var1, int var2, TaxonService var3);

    public List<Taxon> getSynonyms(int var1, int var2, TaxonService var3);

    default public String getPrefString(int synSchID, int specID, TaxonService taxonService) {
        if (specID < 1) {
            return "";
        }
        String preferred = this.getPreferredTerm(synSchID, specID, taxonService).map(Taxon::toString).orElse(null);
        if (preferred != null) {
            return preferred;
        }
        List<String> synonymList = this.getSynonyms(synSchID, specID, taxonService).stream().map(Taxon::toString).toList();
        if (!synonymList.isEmpty()) {
            return "(" + String.join((CharSequence)", ", synonymList) + ")";
        }
        return "";
    }

    public void addSynonym(int var1, int var2, int var3);

    public void removeSpecies(int var1);

    public void updateSynonymy(int var1, int var2, List<Integer> var3, TaxonService var4);

    public Map<Integer, Integer> getSchemeEntries(int var1);

    public List<Integer> getAllSchemeIDs();

    public String getSchemeName(int var1);

    default public void setSchemeName(int synSchID, String schemeName) {
    }
}

