/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SynonymServiceImpl
implements SynonymService {
    private final Map<Integer, NamedIntegerIntegerMap> map = new HashMap<Integer, NamedIntegerIntegerMap>();

    @Override
    public Optional<Taxon> getPreferredTerm(int synSchID, int specID, TaxonService taxonService) {
        Integer preferredID;
        if (this.map.get(synSchID) != null && (preferredID = (Integer)this.map.get(synSchID).get(specID)) != null) {
            return taxonService.findTaxon(preferredID);
        }
        return Optional.empty();
    }

    @Override
    public List<Taxon> getSynonyms(int synSchID, int specID, TaxonService taxonService) {
        if (this.map.get(synSchID) != null) {
            Map synSch = this.map.get(synSchID);
            return synSch.entrySet().stream().filter(entry -> (Integer)entry.getValue() == specID).map(entry -> taxonService.findTaxon((Integer)entry.getKey())).flatMap(Optional::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private NamedIntegerIntegerMap getScheme(int synSchID) {
        if (this.map.get(synSchID) == null) {
            this.map.put(synSchID, new NamedIntegerIntegerMap());
        }
        return this.map.get(synSchID);
    }

    @Override
    public Map<Integer, Integer> getSchemeEntries(int synSchID) {
        return new HashMap<Integer, Integer>(this.getScheme(synSchID));
    }

    @Override
    public List<Integer> getAllSchemeIDs() {
        return this.map.entrySet().stream().filter(entry -> entry.getValue() != null && !((NamedIntegerIntegerMap)entry.getValue()).isEmpty()).map(Map.Entry::getKey).sorted().toList();
    }

    @Override
    public void addSynonym(int synSchID, int specID, int preferredSpecID) throws IllegalArgumentException {
        NamedIntegerIntegerMap scheme = this.getScheme(synSchID);
        Integer existingPreferredTerm = (Integer)scheme.get(specID);
        if (existingPreferredTerm != null && existingPreferredTerm != preferredSpecID) {
            throw new IllegalArgumentException("Attempt to add preferred term for specID: " + specID + " which already has preferred term: " + existingPreferredTerm);
        }
        scheme.put(specID, preferredSpecID);
    }

    @Override
    public void removeSpecies(int specID) {
        for (Map map : this.map.values()) {
            map.entrySet().removeIf(entry -> (Integer)entry.getKey() == specID || (Integer)entry.getValue() == specID);
        }
    }

    @Override
    public void updateSynonymy(int synSchID, int preferredSpecID, List<Integer> juniorSynonyms, TaxonService taxonService) {
        if (juniorSynonyms.contains(preferredSpecID)) {
            throw new IllegalStateException("Can't be a junior synonym of itself");
        }
        NamedIntegerIntegerMap scheme = this.getScheme(synSchID);
        Integer existingPreferredTermOfNewPref = (Integer)scheme.get(preferredSpecID);
        if (existingPreferredTermOfNewPref != null) {
            Logger.getLogger(SynonymServiceImpl.class.getName()).log(Level.INFO, "New preferred term " + String.valueOf(taxonService.findTaxon(preferredSpecID).orElse(null)) + " was already a junior synonym - removing");
            scheme.remove(preferredSpecID);
        }
        scheme.entrySet().removeIf(entry -> (Integer)entry.getValue() == preferredSpecID);
        for (Integer synonym : juniorSynonyms) {
            Integer previousPreferredTerm = scheme.put(synonym, preferredSpecID);
            if (previousPreferredTerm == null) continue;
            Logger.getLogger(SynonymServiceImpl.class.getName()).log(Level.INFO, "Replaced previous preferred term for species " + String.valueOf(taxonService.findTaxon(synonym).orElse(null)));
        }
    }

    @Override
    public String getSchemeName(int synSchID) {
        return this.getScheme(synSchID).getName();
    }

    @Override
    public void setSchemeName(int synSchID, String schemeName) {
        this.getScheme(synSchID).setName(schemeName);
    }

    private static class NamedIntegerIntegerMap
    extends HashMap<Integer, Integer> {
        private String name;

        private NamedIntegerIntegerMap() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

