/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.TaxonNameService;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.Validatable;
import com.stratadata.model3.validation.Validation;
import java.text.AttributedString;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class Taxon
implements Comparable<Taxon>,
Audited {
    private final int specID;
    private final AuditImpl audit;
    private Genus genus;
    @NotEmptyString
    @LimitedLengthString
    private String species = "";
    @LimitedLengthString(fieldName="sub-species")
    private String subSpecies = "";
    private final Qualifier[] qualifiers = new Qualifier[4];
    @LimitedLengthString
    private String author;
    @LimitedLengthString
    private String alphaCode;
    @LimitedLengthString
    private String notes;
    @LimitedLengthString
    private String reference;
    @LimitedLengthString
    private String url;
    private static final boolean INCLUDE_AUTHOR_DEFAULT = false;
    private static final boolean INCLUDE_CATEGORY_DEFAULT = true;
    private static final boolean INCLUDE_ALPHACODE_DEFAULT = false;
    private static final String[] UNDIFFERENTIATED_SPECIES_PREFIX = new String[]{"spp.", "sp. ", "fragments", "group", ".", "indet", "undiff"};

    public Taxon(int specID, AuditImpl audit) {
        for (int i = 0; i < this.qualifiers.length; ++i) {
            this.qualifiers[i] = new Qualifier(i + 4);
        }
        this.author = "";
        this.alphaCode = "";
        this.notes = null;
        this.reference = null;
        this.url = null;
        this.specID = specID;
        this.audit = audit;
    }

    public Taxon(int specID) {
        this(specID, new AuditImpl());
    }

    public Taxon() {
        this(0, new AuditImpl());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Taxon taxon = (Taxon)o;
        return this.specID == taxon.specID;
    }

    public boolean equivalent(Taxon taxon) {
        if (taxon == null) {
            return false;
        }
        if (this.genus != null && taxon.getGenus() != null ? !this.genus.equivalent(taxon.genus, false) : !Objects.equals(this.genus, taxon.genus)) {
            return false;
        }
        return this.species.equals(taxon.species) && this.subSpecies.equals(taxon.subSpecies) && Arrays.equals(this.qualifiers, taxon.qualifiers);
    }

    public int hashCode() {
        return Objects.hash(this.specID);
    }

    public static Taxon copy(Taxon source) {
        Taxon target = new Taxon(source.getSpecID());
        Taxon.copyFields(target, source);
        return target;
    }

    public static void copyFields(Taxon target, Taxon source) {
        Taxon.copyFields(target, source, true);
    }

    public static void copyFields(Taxon target, Taxon source, boolean copyAudit) {
        target.setGenus(source.getGenus());
        target.setSpecies(source.getSpecies());
        target.setSubSpecies(source.getSubSpecies());
        for (int i = 4; i < 8; ++i) {
            target.setQualifier(i, new Qualifier(i, source.getQualifier(i).toString(false)));
        }
        target.setAuthor(source.getAuthor());
        target.setAlphaCode(source.getAlphaCode());
        target.setNotes(source.getNotes());
        target.setReference(source.getReference());
        target.setUrl(source.getUrl());
        if (copyAudit) {
            target.audit.copyFields(source.audit);
        }
    }

    public String toString() {
        return this.toString(false, true, false);
    }

    public String toString(boolean includeAuthor) {
        return this.toString(includeAuthor, true, false);
    }

    public String toString(boolean includeAuthor, boolean includeCategory) {
        return this.toString(includeAuthor, includeCategory, false);
    }

    public String toString(boolean includeAuthor, boolean includeCategory, boolean includeAlphaCode) {
        return this.toString(includeAuthor, includeCategory, includeAlphaCode, false);
    }

    public String toString(boolean includeAuthor, boolean includeCategory, boolean includeAlphaCode, boolean includeDotSpeciesName) {
        Object name = this.toString(includeAuthor, includeCategory, null, includeDotSpeciesName);
        if (includeAlphaCode && !StringUtils.isBlank((CharSequence)this.getAlphaCode())) {
            name = (String)name + " (" + this.getAlphaCode() + ")";
        }
        return name;
    }

    public String toAbbreviatedGenusString(boolean abbreviateGenus, boolean includeCategory) {
        String genusName;
        if (!abbreviateGenus) {
            return this.toString(false, includeCategory, false);
        }
        StringBuilder sb = new StringBuilder();
        if (includeCategory) {
            sb.append(StringUtils.rightPad((String)this.genus.getCategory().getMnemonic(), (int)6, (char)' '));
        }
        if ((genusName = this.genus.getGenusName()).isEmpty() || !Character.isUpperCase(genusName.charAt(0)) || this.isUndifferentiated()) {
            sb.append(this.genus.toString(false));
        } else {
            sb.append(genusName.charAt(0)).append(".");
        }
        if (!sb.isEmpty()) {
            sb.append(" ");
        }
        return sb.append(this.toSpeciesString(false, false, null)).toString();
    }

    String toString(boolean includeAuthor, boolean includeCategory, List<Integer> italics, boolean includeDotSpeciesName) {
        StringBuilder name = new StringBuilder();
        if (this.genus != null) {
            name.append(this.genus.toString(includeCategory, italics));
        }
        if (!name.isEmpty()) {
            name.append(" ");
        }
        int genusNameLen = name.length();
        LinkedList<Integer> speciesItalics = italics == null ? null : new LinkedList<Integer>();
        name.append(this.toSpeciesString(includeAuthor, includeDotSpeciesName, speciesItalics));
        if (speciesItalics != null) {
            italics.addAll(speciesItalics.stream().map(i -> i + genusNameLen).toList());
        }
        return name.toString();
    }

    public String toSpeciesString(boolean includeAuthor, boolean includeDotSpecName, List<Integer> italics) {
        boolean italicsFlag = false;
        StringBuilder name = new StringBuilder();
        if (!(this.species.isEmpty() || !includeDotSpecName && this.species.equals("."))) {
            if (this.getQ1().hasQuals()) {
                name.append(this.getQ1().toString(true));
            }
            if (!this.species.startsWith("sp.") && !this.species.startsWith("spp.") && italics != null) {
                italics.add(name.length());
                italicsFlag = true;
            }
            name.append(this.species);
            if (italicsFlag) {
                italics.add(name.length());
            }
            if (this.getQ2().hasQuals()) {
                name.append(this.getQ2().toString(true));
            }
        }
        if (this.getQ3().hasQuals()) {
            name.append(" ").append(this.getQ3().toString(true));
        }
        if (!this.subSpecies.isEmpty()) {
            if (italicsFlag && this.getQ2().hasQual(TaxonQual.SENSU)) {
                italicsFlag = false;
            }
            if (italicsFlag) {
                italics.add(name.length());
            }
            if (!this.getQ3().hasQuals()) {
                name.append(" ");
            }
            name.append(this.subSpecies);
            if (italicsFlag) {
                italics.add(name.length());
            }
        }
        if (this.getQ4().hasQuals()) {
            name.append(this.getQ4().toString(true));
        }
        name.append(this.getAuthorString(includeAuthor));
        return name.toString();
    }

    public String getAuthorString(boolean useAuthor) {
        if (!StringUtils.isBlank((CharSequence)this.author) && (useAuthor || this.getQ2().hasQual(TaxonQual.SENSU) && this.subSpecies.isEmpty() || this.getQ4().hasQual(TaxonQual.SENSU))) {
            return " " + this.author;
        }
        return "";
    }

    public AttributedString toAttributedString(boolean includeAuthor, boolean includeCategory) {
        return this.toAttributedString(true, includeAuthor, includeCategory);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean includeAuthor, boolean includeCategory) {
        return this.toAttributedString(useItalics, includeAuthor, includeCategory, null);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean includeAuthor, boolean includeCategory, String suffix) {
        LinkedList<Integer> italicsPos = useItalics ? new LinkedList<Integer>() : null;
        Object string = this.toString(includeAuthor, includeCategory, italicsPos, false);
        if (suffix != null) {
            string = (String)string + suffix;
        }
        return TaxonNameService.generateAttributedString((String)string, italicsPos);
    }

    @Ident
    public int getSpecID() {
        return this.specID;
    }

    public Genus getGenus() {
        return this.genus;
    }

    public Optional<Category> getCategory() {
        if (this.genus != null) {
            return Optional.ofNullable(this.genus.getCategory());
        }
        return Optional.empty();
    }

    public void setGenus(Genus genus) {
        this.genus = genus;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(species, ""));
    }

    public String getSubSpecies() {
        return this.subSpecies;
    }

    public void setSubSpecies(String subSpecies) {
        this.subSpecies = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(subSpecies, ""));
    }

    public Qualifier getQ1() {
        return this.qualifiers[0];
    }

    public Qualifier getQ2() {
        return this.qualifiers[1];
    }

    public Qualifier getQ3() {
        return this.qualifiers[2];
    }

    public Qualifier getQ4() {
        return this.qualifiers[3];
    }

    public Qualifier getQualifier(int pos) {
        if (pos < 0 || pos > 7) {
            throw new IllegalArgumentException("Attempt to get taxon qualifier " + pos);
        }
        if (pos < 4) {
            return this.genus.getQualifier(pos);
        }
        return this.qualifiers[pos - 4];
    }

    public boolean hasQualifier(TaxonQual q) {
        return Arrays.stream(this.qualifiers).anyMatch(qualifier -> qualifier.hasQual(q));
    }

    public void setQ1(Qualifier q) {
        this.setQualifier(4, q);
    }

    public void setQ2(Qualifier q) {
        this.setQualifier(5, q);
    }

    public void setQ3(Qualifier q) {
        this.setQualifier(6, q);
    }

    public void setQ4(Qualifier q) {
        this.setQualifier(7, q);
    }

    public void setQualifier(int pos, Qualifier q) {
        if (pos < 4 || pos > 7 || q.position() != pos) {
            throw new IllegalArgumentException("Illegal qualifier for position " + pos);
        }
        this.qualifiers[pos - 4] = q;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(author, ""));
    }

    public String getAlphaCode() {
        return this.alphaCode;
    }

    public void setAlphaCode(String alphaCode) {
        this.alphaCode = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(alphaCode, ""));
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean hasReferencesOrNotes() {
        return StringUtils.isNotBlank((CharSequence)this.reference) || StringUtils.isNotBlank((CharSequence)this.notes) || StringUtils.isNotBlank((CharSequence)this.url);
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    @Override
    public int compareTo(Taxon taxon) {
        return Taxon.compare(this, taxon);
    }

    public static int compare(Taxon o1, Taxon o2) {
        if (o1 != null && o2 != null) {
            int o2Undiff;
            if (o1.specID == o2.getSpecID()) {
                return 0;
            }
            if (!Objects.equals(o1.genus, o2.genus)) {
                return Genus.compare(o1.genus, o2.genus);
            }
            int o1Undiff = o1.isUndifferentiated() ? 1 : 0;
            int n = o2Undiff = o2.isUndifferentiated() ? 1 : 0;
            if (o1Undiff != o2Undiff) {
                return o2Undiff - o1Undiff;
            }
            if (!o1.species.equals(o2.species)) {
                return o1.species.compareTo(o2.species);
            }
            if (!o1.subSpecies.equals(o2.subSpecies)) {
                return o1.subSpecies.compareTo(o2.subSpecies);
            }
            for (int i = 0; i < 4; ++i) {
                if (o1.qualifiers[i].equals(o2.qualifiers[i])) continue;
                return o1.qualifiers[i].toString().compareTo(o2.qualifiers[i].toString());
            }
            return 0;
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        return -1;
    }

    public void updateAudit(UserService userService, Instant databaseServerDate) {
        this.updateAudit(this.audit, userService, databaseServerDate);
    }

    public void updateAudit(Audit originalAudit, UserService userService, Instant databaseServerDate) {
        AuditImpl auditUpdate = AuditImpl.getAuditUpdate(originalAudit, userService, databaseServerDate, false);
        this.audit.copyFields(auditUpdate);
    }

    public void clean(boolean convertSpeciesCase, Boolean spSpp) {
        if (convertSpeciesCase) {
            this.species = Taxon.toSpeciesCase(this.species);
            this.subSpecies = Taxon.toSpeciesCase(this.subSpecies);
        }
        if (spSpp != null) {
            if (spSpp.booleanValue()) {
                if ((this.species.equals("sp") || this.species.equals("sp.")) && this.subSpecies.isEmpty()) {
                    this.species = "spp.";
                }
            } else if (this.species.equals("sp") && this.subSpecies.isEmpty()) {
                this.species = "sp.";
            }
            if (this.species.equals("spp")) {
                this.species = "spp.";
            }
        }
    }

    public static String toSpeciesCase(String species) {
        String[] replacers;
        if (((String)(species = ((String)species).toLowerCase())).startsWith("sp.") || ((String)species).startsWith("sp ") || ((String)species).startsWith("var ")) {
            species = ((String)species).substring(0, 3) + ((String)species).substring(3).toUpperCase();
        }
        for (String replacer : replacers = new String[]{"spt", "rri", "ms"}) {
            species = ((String)species).replaceAll("\\b" + replacer + "\\b", replacer.toUpperCase());
        }
        return species;
    }

    public boolean isUndifferentiated() {
        return Arrays.stream(UNDIFFERENTIATED_SPECIES_PREFIX).anyMatch(prefix -> this.species.startsWith((String)prefix));
    }

    @Validation
    public List<String> validateQualifiers() {
        if (this.getQ1().hasQual(TaxonQual.QUOTE) || this.getQ2().hasQual(TaxonQual.QUOTE)) {
            this.getQ1().addQual(TaxonQual.QUOTE);
            this.getQ2().addQual(TaxonQual.QUOTE);
        }
        if (this.getQ3().hasQual(TaxonQual.QUOTE) || this.getQ4().hasQual(TaxonQual.QUOTE)) {
            this.getQ3().addQual(TaxonQual.QUOTE);
            this.getQ4().addQual(TaxonQual.QUOTE);
        }
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (String name : new String[]{this.species, this.subSpecies}) {
            if (TaxonQual.allowName(name)) continue;
            validationMessages.add("qualifiers must not be part of the taxon name: '" + name + "'");
        }
        if (this.getQ2().hasQual(TaxonQual.SENSU) && this.getQ4().hasQual(TaxonQual.SENSU)) {
            validationMessages.add("'sensu' qualifier may not be used twice");
        }
        if (this.getQ2().hasQual(TaxonQual.SENSU) && this.getSubSpecies().isEmpty() && this.getAuthor().isEmpty()) {
            validationMessages.add("author name (as sub-species or author) must be present to use 'sensu' after species");
        }
        if (this.getQ4().hasQual(TaxonQual.SENSU) && this.getAuthor().isEmpty()) {
            validationMessages.add("author name must be present to use 'sensu' after sub-species");
        }
        return validationMessages;
    }
}

