/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonQual;
import java.awt.Color;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TaxonFactory {
    private TaxonFactory() {
    }

    public static Taxon parse(String s) {
        return TaxonFactory.parse(s, 0);
    }

    public static Taxon parse(String s, int specID) {
        return TaxonFactory.parse(s, specID, ParseMode.STRICT, null);
    }

    public static Taxon parse(String s, int specID, ParseMode mode, CategoryService categoryService) {
        String stripped;
        String[] arr = s.split(" ");
        if (arr.length < 1) {
            return null;
        }
        Genus genus = new Genus();
        Taxon taxon = new Taxon(specID);
        taxon.setGenus(genus);
        int i = 0;
        if (categoryService != null) {
            String catToken = arr[0];
            categoryService.findCategory(catToken.toUpperCase()).ifPresent(category -> genus.setCategory((Category)category));
            if (genus.getCategory() != null) {
                ++i;
            }
        }
        Qualifier q1 = genus.getQualifier(0);
        Qualifier q2 = genus.getQualifier(1);
        while (i < arr.length) {
            if (!genus.getGenusName().isEmpty()) {
                if (arr[i].startsWith("(") && i < arr.length - 1) {
                    String subGen = arr[i].replaceAll("\\(", "").replaceAll("\\)", "");
                    genus.setSubGenus(subGen);
                    ++i;
                }
                q1 = genus.getQualifier(1);
                q2 = taxon.getQualifier(4);
                break;
            }
            stripped = TaxonQual.stripQualifiers(arr[i], q1, q2);
            if (!stripped.isEmpty()) {
                genus.setGenusName(stripped);
            }
            ++i;
        }
        if (i == arr.length) {
            return switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> taxon.getGenus().getGenusName().isEmpty() ? null : taxon;
            };
        }
        while (i < arr.length) {
            if (q1 == genus.getQualifier(1) && (arr[i].endsWith(TaxonQual.Q.toString()) || arr[i].startsWith(TaxonQual.Q.toString())) || arr[i].endsWith(TaxonQual.QUOTE.toString()) || arr[i].startsWith(TaxonQual.QUOTE.toString())) {
                q1 = taxon.getQualifier(4);
                q2 = taxon.getQualifier(5);
            }
            stripped = TaxonQual.stripQualifiers(arr[i], q1, q2);
            if (q1 == genus.getQualifier(1) && q1.hasQuals()) {
                q1 = q2;
                q2 = taxon.getQualifier(4);
            }
            if (!stripped.isEmpty()) {
                if (taxon.getSpecies().isEmpty() || !taxon.getQualifier(5).hasQuals() && !taxon.getQualifier(6).hasQuals()) {
                    taxon.setSpecies(StringUtils.joinWith((String)" ", (Object[])new Object[]{taxon.getSpecies(), stripped}));
                    q1 = taxon.getQualifier(5);
                    q2 = taxon.getQualifier(6);
                } else {
                    taxon.setSubSpecies(stripped);
                    ++i;
                    break;
                }
            }
            ++i;
        }
        if (taxon.getSpecies().isEmpty() && mode == ParseMode.STRICT) {
            return null;
        }
        if (i < arr.length) {
            q1 = taxon.getQualifier(6);
            q2 = taxon.getQualifier(7);
            while (i < arr.length) {
                stripped = TaxonQual.stripQualifiers(arr[i], q1, q2);
                if (!stripped.isEmpty()) {
                    taxon.setAuthor((String)(taxon.getAuthor().isEmpty() ? "" : taxon.getAuthor() + " ") + stripped);
                }
                ++i;
            }
        }
        return taxon;
    }

    public static Taxon parse(String s, int specID, boolean forceNotNull, GenusService genusService, CategoryService categoryService) {
        List<Genus> matchingGenera;
        Taxon taxon = TaxonFactory.parse(s, specID, ParseMode.STRICT, null);
        if (taxon == null) {
            if (forceNotNull) {
                Object string = s;
                for (int its = 3; taxon == null && its > 0; --its) {
                    string = (String)string + " unknown";
                    taxon = TaxonFactory.parse((String)string, specID, ParseMode.STRICT, null);
                }
                if (taxon == null) {
                    throw new IllegalArgumentException("Cannot create Taxon from string: '" + s + "'");
                }
            } else {
                return null;
            }
        }
        if (!(matchingGenera = genusService.findMatchingGenera(taxon.getGenus(), SearchMode.LOOKUP)).isEmpty()) {
            taxon.setGenus(matchingGenera.get(0));
        } else {
            Category cat = categoryService.findCategory("").orElseGet(() -> categoryService.addCategory("", Discipline.MICRO, "", Color.BLACK));
            taxon.getGenus().setCategory(cat);
            taxon.setGenus(genusService.addGenus(taxon.getGenus()));
        }
        return taxon;
    }

    public static Taxon parseForSearch(String s, CategoryService categoryService) {
        boolean endsInWhitespace = s.endsWith(" ");
        String text = s.trim();
        if (text.isBlank()) {
            return null;
        }
        Taxon taxon = TaxonFactory.parse(text, 0, ParseMode.LENIENT, categoryService);
        if (taxon == null) {
            return null;
        }
        Object genusName = taxon.getGenus().getGenusName();
        if (((String)genusName).endsWith(".")) {
            genusName = ((String)genusName).substring(0, ((String)genusName).length() - 1) + "%";
        }
        genusName = ((String)genusName).replace("*", "%");
        boolean wildcardGenus = true;
        if (((String)genusName).endsWith("%") || !taxon.getGenus().getSubGenus().isEmpty()) {
            wildcardGenus = false;
        }
        if (wildcardGenus) {
            genusName = (String)genusName + "%";
        }
        taxon.getGenus().setGenusName((String)genusName);
        if (taxon.getGenus().getSubGenus().isEmpty()) {
            taxon.getGenus().setSubGenus("%");
        }
        boolean wildcardSpecies = true;
        if (taxon.getSpecies().endsWith("%") || endsInWhitespace || !taxon.getSubSpecies().isEmpty()) {
            wildcardSpecies = false;
        }
        if (wildcardSpecies) {
            taxon.setSpecies(taxon.getSpecies() + "%");
        }
        if (!endsInWhitespace) {
            taxon.setSubSpecies(taxon.getSubSpecies() + "%");
        }
        return taxon;
    }

    public static enum ParseMode {
        STRICT,
        LENIENT;

    }
}

