/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.taxon.Qualifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public enum TaxonQual {
    QUOTE("\"", false, new int[]{2, 0, 1, 0, 1, 0, 1, 0}, false),
    Q("?", false, new int[]{0, 1, -1, 1, -1, 1, -1, 1}, false),
    CF("cf", true, new int[]{1, -1, 0, -1, 0, -1, 0, -1}, true),
    AFF("aff", true, new int[]{1, -1, 0, -1, 0, -1, 0, -1}, true),
    SS("ss", true, new int[]{-1, 2, -1, 2, -1, 2, -1, 2}, true),
    SL("sl", true, new int[]{-1, 2, -1, 2, -1, 2, -1, 2}, true),
    GRP("grp", true, new int[]{-1, 2, -1, 2, -1, 2, -1, -1}, true),
    SENSU("sensu", false, new int[]{-1, -1, -1, -1, -1, 2, -1, 2}, true),
    VAR("var", true, new int[]{-1, -1, -1, -1, -1, -1, 0, -1}, true);

    final String descr;
    final boolean whitespace;
    final boolean dot;
    private final int[] indexAtPosition;
    public static final int GQ1 = 0;
    public static final int GQ2 = 1;
    public static final int GQ3 = 2;
    public static final int GQ4 = 3;
    public static final int SQ1 = 4;
    public static final int SQ2 = 5;
    public static final int SQ3 = 6;
    public static final int SQ4 = 7;

    private TaxonQual(String s, boolean dot, int[] indexAtPosition, boolean whitespace) {
        this.descr = s;
        this.dot = dot;
        this.indexAtPosition = indexAtPosition;
        this.whitespace = whitespace;
    }

    public String toString() {
        return this.descr + (this.dot ? "." : "");
    }

    public static List<TaxonQual> parse(String s, int position) {
        if (position < 0 || position > 7) {
            throw new IllegalArgumentException("Cannot create qualifier comparator for position " + position);
        }
        LinkedList<TaxonQual> matches = new LinkedList<TaxonQual>();
        if (s != null) {
            s = s.toLowerCase();
            for (TaxonQual q : TaxonQual.values()) {
                if (!s.contains(q.toString()) || q.indexAtPosition[position] <= -1) continue;
                matches.add(q);
            }
            Collections.sort(matches, new QualComparator(position));
        }
        return matches;
    }

    public static String stripQualifiers(String s, Qualifier q1, Qualifier q2) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        for (TaxonQual qual : TaxonQual.values()) {
            String d;
            String string = d = qual == Q ? "\\?" : qual.descr;
            if (!s.equals(d) && !s.startsWith(qual.toString()) && !s.endsWith(qual.toString())) continue;
            if (qual == Q && q2 != null && q1.position() == 0 && q2.position() == 1) {
                if (s.startsWith(qual.toString())) {
                    q1.addQual(qual);
                } else {
                    q2.addQual(qual);
                }
            } else {
                q1.addQual(qual);
                if (q2 != null) {
                    q2.addQual(qual);
                }
            }
            s = qual.dot && s.contains(qual.toString()) ? s.replaceAll(qual.toString(), "") : s.replaceAll(d, "").trim();
            if (s.isEmpty()) break;
        }
        return s;
    }

    public static boolean allowName(String name) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        for (TaxonQual q : TaxonQual.values()) {
            if (!q.whitespace) {
                if (!name.startsWith(q.descr) && !name.endsWith(q.descr)) continue;
                return false;
            }
            if (name.startsWith(q.toString()) || name.endsWith(q.toString())) {
                return false;
            }
            if (!name.equals(q.descr)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsQualifier(String donorString) {
        return Arrays.stream(TaxonQual.values()).anyMatch(q -> donorString.contains(q.descr));
    }

    public boolean useAt(int position) {
        return this.indexAtPosition[position] > -1;
    }

    boolean isMutuallyExclusive(TaxonQual q, int position) {
        return this.indexAtPosition[position] == q.indexAtPosition[position];
    }

    static class QualComparator
    implements Comparator<TaxonQual> {
        private final int qualifier;

        public QualComparator(int qualifier) {
            if (qualifier < 0 || qualifier > 7) {
                throw new IllegalArgumentException("Cannot create qualifier comparator for qualifier " + qualifier);
            }
            this.qualifier = qualifier;
        }

        @Override
        public int compare(TaxonQual o1, TaxonQual o2) {
            return o1.indexAtPosition[this.qualifier] - o2.indexAtPosition[this.qualifier];
        }
    }
}

