/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon.process;

import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.util.process.ProgressMonitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TaxonDelete {
    private final ProgressMonitor progressMonitor;
    private final TaxonService taxonService;
    private final GenusService genusService;
    private final SynonymService synonymService;
    private int nSpeciesDeleted;
    private Set<Integer> deletedGenera = Collections.emptySet();

    private TaxonDelete(ProgressMonitor progressMonitor, TaxonService taxonService, SynonymService synonymService, GenusService genusService, Collection<Integer> specIDsToDelete) {
        this.progressMonitor = progressMonitor;
        this.taxonService = taxonService;
        this.synonymService = synonymService;
        this.genusService = genusService;
        this.start(specIDsToDelete);
    }

    public static TaxonDelete deleteSpeciesOnly(TaxonService ts, SynonymService ss, Collection<Integer> specIDsToDelete) {
        return new TaxonDelete(null, ts, ss, null, specIDsToDelete);
    }

    public static TaxonDelete deleteSpeciesAndUnusedGenera(ProgressMonitor monitor, TaxonService ts, SynonymService ss, GenusService gs, Collection<Integer> specIDsToDelete) {
        return new TaxonDelete(monitor, ts, ss, gs, specIDsToDelete);
    }

    private void start(Collection<Integer> specIDsToDelete) {
        if (specIDsToDelete.isEmpty()) {
            return;
        }
        Set<Integer> genIDs = Collections.emptySet();
        if (this.genusService != null) {
            genIDs = specIDsToDelete.stream().map(this.taxonService::findTaxon).filter(Optional::isPresent).map(Optional::get).map(taxon -> taxon.getGenus().getGenID()).filter(genID -> this.genusService.findGenus((int)genID).isPresent()).collect(Collectors.toSet());
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.init(specIDsToDelete.size(), "Deleting species...");
        }
        this.taxonService.deleteTaxa(specIDsToDelete, this.progressMonitor);
        if (this.progressMonitor != null && this.progressMonitor.isInterrupted()) {
            return;
        }
        specIDsToDelete.forEach(specID -> this.synonymService.removeSpecies((int)specID));
        this.nSpeciesDeleted = specIDsToDelete.size();
        if (this.genusService != null && !genIDs.isEmpty()) {
            Set<Integer> unusedGenIDs = this.taxonService.getUnusedGenera(genIDs);
            if (this.progressMonitor != null) {
                this.progressMonitor.init(unusedGenIDs.size(), "Deleting unused genera...");
            }
            this.genusService.deleteGenera(unusedGenIDs, this.progressMonitor);
            this.deletedGenera = unusedGenIDs;
        }
    }

    public Set<Integer> getDeletedGenera() {
        return this.deletedGenera;
    }

    public int getnSpeciesDeleted() {
        return this.nSpeciesDeleted;
    }
}

