/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

import com.stratadata.model3.well.CoreShiftDepth;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CoreShift {
    private final List<CoreShiftDepth> list = new LinkedList<CoreShiftDepth>();

    public CoreShift() {
    }

    public CoreShift(CoreShift rhs) {
        rhs.list.forEach(csd -> this.list.add(new CoreShiftDepth(csd.getDepth(), csd.getShift())));
    }

    public void add(CoreShiftDepth csd) {
        this.list.add(csd);
    }

    public void add(int index, CoreShiftDepth csd) {
        this.list.add(index, csd);
    }

    public void sort() {
        Collections.sort(this.list);
    }

    public int size() {
        return this.list.size();
    }

    public List<CoreShiftDepth> getListCopy() {
        return new LinkedList<CoreShiftDepth>(this.list);
    }

    public Iterator<CoreShiftDepth> iterator() {
        return this.list.iterator();
    }

    public CoreShiftDepth get(int index) {
        return this.list.get(index);
    }

    public void remove(CoreShiftDepth csd) {
        this.list.remove(csd);
    }

    public double getCorrectedDepth(double depth) {
        if (this.list.isEmpty()) {
            return depth;
        }
        CoreShiftDepth lower = null;
        CoreShiftDepth upper = null;
        for (CoreShiftDepth csd : this.list) {
            if (lower == null || depth >= csd.getDepth()) {
                lower = csd;
                continue;
            }
            upper = csd;
            break;
        }
        if (upper == null) {
            upper = lower;
        }
        if (upper.getDepth() < lower.getDepth()) {
            upper = lower;
        }
        if (lower == upper) {
            return depth + (double)lower.getShift();
        }
        if (depth < lower.getDepth()) {
            return depth + (double)lower.getShift();
        }
        if (depth > upper.getDepth()) {
            return depth + (double)upper.getShift();
        }
        double proportion = (depth - upper.getDepth()) / (lower.getDepth() - upper.getDepth());
        double deltaSample = (double)upper.getShift() + proportion * (double)(lower.getShift() - upper.getShift());
        return depth += deltaSample;
    }

    public double getShift(double depth) {
        double correctedDepth = this.getCorrectedDepth(depth);
        return correctedDepth - depth;
    }

    public float getMinShift() {
        double min = this.list.stream().mapToDouble(CoreShiftDepth::getShift).min().orElse(0.0);
        return (float)min;
    }

    public float getMaxShift() {
        double max = this.list.stream().mapToDouble(CoreShiftDepth::getShift).max().orElse(0.0);
        return (float)max;
    }

    public boolean hasDuplicateDepths() {
        for (CoreShiftDepth csd : this.list) {
            double depth = csd.getDepth();
            int nMatches = 0;
            for (CoreShiftDepth csd2 : this.list) {
                double depth2 = csd2.getDepth();
                if (!(Math.abs(depth2 - depth) < 0.0029)) continue;
                ++nMatches;
            }
            if (nMatches <= true) continue;
            return true;
        }
        return false;
    }
}

