/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

import java.util.Optional;

public record DegreesMinutesSecondsCoordinate(short degrees, short minutes, float seconds, char ind) {
    public static DegreesMinutesSecondsCoordinate longitude(Double decimalLongitude) {
        return DegreesMinutesSecondsCoordinate.parse(decimalLongitude).map(c -> new DegreesMinutesSecondsCoordinate(c.degrees, c.minutes, c.seconds, decimalLongitude < 0.0 ? (char)'W' : (char)'E')).orElse(null);
    }

    public static DegreesMinutesSecondsCoordinate latitude(Double decimalLatitude) {
        return DegreesMinutesSecondsCoordinate.parse(decimalLatitude).map(c -> new DegreesMinutesSecondsCoordinate(c.degrees, c.minutes, c.seconds, decimalLatitude >= 0.0 ? (char)'N' : (char)'S')).orElse(null);
    }

    private static Optional<DegreesMinutesSecondsCoordinate> parse(Double decimalDegrees) {
        if (decimalDegrees == null) {
            return Optional.empty();
        }
        short degrees = (short)Math.abs(decimalDegrees);
        double m = Math.abs(decimalDegrees - (double)decimalDegrees.intValue());
        short minutes = (short)(m *= 60.0);
        double s = Math.abs(decimalDegrees - (double)decimalDegrees.intValue());
        s *= 60.0;
        s -= (double)((int)s);
        float seconds = (float)(s *= 60.0);
        return Optional.of(new DegreesMinutesSecondsCoordinate(degrees, minutes, seconds, 'X'));
    }

    @Override
    public String toString() {
        return String.valueOf(this.degrees) + "\u00b0" + String.valueOf(this.minutes) + "'" + this.seconds + "\"" + this.ind;
    }

    public double getDecimalDegrees() {
        double dDeg = (double)this.degrees + (double)this.minutes / 60.0 + (double)this.seconds / 3600.0;
        if (this.ind == 'S' || this.ind == 'W') {
            dDeg = -dDeg;
        }
        return dDeg;
    }
}

