/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

public enum SectionType {
    WELL('W', "Borehole"),
    OUTCROP('O', "Outcrop");

    final char charType;
    final String stringType;

    private SectionType(char charType, String stringType) {
        this.charType = charType;
        this.stringType = stringType;
    }

    public static SectionType getSectionType(char charType) {
        char uppChar = Character.toUpperCase(charType);
        for (SectionType type : SectionType.values()) {
            if (uppChar != type.charType) continue;
            return type;
        }
        return WELL;
    }

    public char getCharType() {
        return this.charType;
    }

    public String getStringType() {
        return this.stringType;
    }
}

