/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

public enum WellDatum {
    ROTARY_TABLE(1, "RTE", "Rotary table", "KB", "KELLY BUSHING"),
    SEA_LEVEL(2, "SL", "Sea level", "MSL", "MEAN SEA LEVEL"),
    SEA_BED(3, "SB", "Sea bed", new String[0]);

    private final int dbInt;
    private final String shortDescr;
    private final String descr;
    private final String[] otherNames;

    private WellDatum(int dbInt, String shortDescr, String descr, String ... otherNames) {
        this.dbInt = dbInt;
        this.shortDescr = shortDescr;
        this.descr = descr;
        this.otherNames = otherNames;
    }

    public static WellDatum parse(int dbInt) {
        for (WellDatum datum : WellDatum.values()) {
            if (datum.dbInt != dbInt) continue;
            return datum;
        }
        return null;
    }

    public static WellDatum parse(String s) {
        if (s != null) {
            s = s.toUpperCase();
            for (WellDatum datum : WellDatum.values()) {
                if (datum.shortDescr.startsWith(s)) {
                    return datum;
                }
                for (String other : datum.otherNames) {
                    if (!other.startsWith(s)) continue;
                    return datum;
                }
            }
        }
        return null;
    }

    public String getShortDescr() {
        return this.shortDescr;
    }

    public String getDescr() {
        return this.descr;
    }

    public int getDbInt() {
        return this.dbInt;
    }
}

