/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

import com.stratadata.model3.validation.ConstrainedNumber;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.NotNull;
import com.stratadata.model3.validation.Validatable;
import com.stratadata.model3.validation.Validation;
import com.stratadata.model3.well.DegreesMinutesSecondsCoordinate;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.util.depth.DepthUnits;
import java.awt.Color;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class WellHeader
implements Comparable<WellHeader>,
Serializable {
    final int wellID;
    @NotEmptyString
    @LimitedLengthString
    private String wellCode = "";
    @NotEmptyString
    @LimitedLengthString(fieldName="Well name")
    private String wellName = "";
    @LimitedLengthString(fieldName="Alternative name")
    private String wellAltName = "";
    @NotNull
    private SectionType sectionType = SectionType.WELL;
    @NotNull
    private DepthUnits units = DepthUnits.M;
    @LimitedLengthString
    private String operator = "";
    @LimitedLengthString
    private String client = "";
    @LimitedLengthString
    private String ocs = "";
    @LimitedLengthString
    private String description = "";
    private LocalDate spudDate;
    private LocalDate completionDate;
    private Color colour = Color.BLACK;
    private int acm;
    private Integer parentWellID;
    public static final float DEFAULT_SCALE = 2000.0f;
    private float defaultChartScale = 2000.0f;
    private boolean lithologyDepthsAreDrilled = false;
    @NotEmptyString
    @LimitedLengthString
    private String country = "";
    @LimitedLengthString
    private String county = "";
    @LimitedLengthString(fieldName="State")
    private String locState = "";
    @LimitedLengthString
    private String field = "";
    @LimitedLengthString
    private String basin = "";
    @LimitedLengthString
    private String area = "";
    @ConstrainedNumber(minVal=0.0)
    private double gridX;
    @ConstrainedNumber(minVal=0.0)
    private double gridY;
    @LimitedLengthString(fieldName="UTM zone")
    private String utmZone = "";
    @ConstrainedNumber(minVal=-90.0, maxVal=90.0, nullable=true, fieldName="Decimal degrees latitude")
    private Double lat_dec;
    @ConstrainedNumber(minVal=-180.0, maxVal=180.0, nullable=true, fieldName="Decimal degrees longitude")
    private Double long_dec;
    @LimitedLengthString
    private String geoDatum = "";
    @NotNull
    private WellDatum datum = WellDatum.ROTARY_TABLE;
    @ConstrainedNumber(nullable=false, fieldName="Terminal depth")
    private double terminalDepth;
    @ConstrainedNumber(nullable=true, fieldName="Sea level")
    private Double seaLevel;
    @ConstrainedNumber(nullable=true, fieldName="Sea bed")
    private Double seaBed;
    @ConstrainedNumber(nullable=true, fieldName="Rotary table elevation")
    private Double rotaryTableElevation;
    @ConstrainedNumber(nullable=true, fieldName="Sidetrack kick-off depth")
    private Double kickOff;

    public WellHeader() {
        this.wellID = 0;
    }

    public WellHeader(int wellID) {
        this.wellID = wellID;
    }

    public String toString() {
        Object strg = this.wellName;
        if (!this.wellCode.equals(this.wellName)) {
            strg = (String)strg + " (" + this.wellCode + ")";
        }
        return strg;
    }

    @Validation
    public List<String> validate() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.sectionType == SectionType.OUTCROP && this.kickOff == null) {
            messages.add("Top of section is required");
        }
        if (this.parentWellID != null && this.kickOff == null) {
            messages.add("Kick-off depth is required for sidetracks");
        }
        if (this.kickOff != null && this.kickOff > this.terminalDepth) {
            messages.add((this.sectionType == SectionType.OUTCROP ? "Top of section" : "Kick-off depth") + " exceeds terminal depth");
        }
        if (this.getCompletionDate() != null && this.getSpudDate() != null && this.getCompletionDate().isBefore(this.getSpudDate())) {
            messages.add("Completion date is before spud date");
        }
        return messages;
    }

    @Override
    public int compareTo(WellHeader rhs) {
        if (this.wellName.equalsIgnoreCase(rhs.wellName)) {
            return this.wellCode.compareToIgnoreCase(rhs.wellCode);
        }
        return WellHeader.compareWellNames(this.wellName, rhs.wellName);
    }

    private static int compareWellNames(String lhs, String rhs) {
        String splitParams = "[\\ \\/\\-\\_]";
        String[] s1 = lhs.split("[\\ \\/\\-\\_]");
        String[] s2 = rhs.split("[\\ \\/\\-\\_]");
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            int r;
            int c = s1[i].compareTo(s2[i]);
            if (c == 0 || (r = WellHeader.compareNameComponent(s1[i], s2[i])) == 0) continue;
            return r;
        }
        return lhs.compareTo(rhs);
    }

    private static int compareNameComponent(String s1, String s2) {
        try {
            if (s1.length() > 0 && s2.length() > 0) {
                int i2;
                int i;
                String s1Suffix = "";
                String s2Suffix = "";
                for (i = 0; i < s1.length() && Character.isDigit(s1.charAt(i)); ++i) {
                }
                if (i < s1.length()) {
                    s1Suffix = s1.substring(i);
                }
                s1 = s1.substring(0, i);
                for (i = 0; i < s2.length() && Character.isDigit(s2.charAt(i)); ++i) {
                }
                if (i < s2.length()) {
                    s2Suffix = s2.substring(i);
                }
                s2 = s2.substring(0, i);
                int i1 = s1.isEmpty() ? 0 : Integer.parseInt(s1);
                int n = i2 = s2.isEmpty() ? 0 : Integer.parseInt(s2);
                if (i1 == i2) {
                    return s1Suffix.compareTo(s2Suffix);
                }
                return i1 - i2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return s1.compareTo(s2);
    }

    private double value(Double d) {
        return Objects.requireNonNullElse(d, 0.0);
    }

    public double getRTDepth() {
        return switch (this.datum) {
            default -> throw new MatchException(null, null);
            case WellDatum.SEA_BED -> -1.0 * (this.value(this.seaBed) + this.value(this.seaLevel) + this.value(this.rotaryTableElevation));
            case WellDatum.SEA_LEVEL -> -1.0 * (this.value(this.seaLevel) + this.value(this.rotaryTableElevation));
            case WellDatum.ROTARY_TABLE -> 0.0;
        };
    }

    public double getSLDepth() {
        return switch (this.datum) {
            default -> throw new MatchException(null, null);
            case WellDatum.SEA_BED -> -this.value(this.seaBed);
            case WellDatum.SEA_LEVEL -> 0.0;
            case WellDatum.ROTARY_TABLE -> this.value(this.seaLevel) + this.value(this.rotaryTableElevation);
        };
    }

    public double getSBDepth() {
        return switch (this.datum) {
            default -> throw new MatchException(null, null);
            case WellDatum.SEA_BED -> 0.0;
            case WellDatum.SEA_LEVEL -> this.value(this.seaBed);
            case WellDatum.ROTARY_TABLE -> this.value(this.seaBed) + this.value(this.seaLevel) + this.value(this.rotaryTableElevation);
        };
    }

    public double getDatumConversion(WellDatum d) {
        if (d == this.datum) {
            return 0.0;
        }
        return switch (d) {
            default -> throw new MatchException(null, null);
            case WellDatum.ROTARY_TABLE -> this.getRTDepth() * -1.0;
            case WellDatum.SEA_LEVEL -> this.getSLDepth() * -1.0;
            case WellDatum.SEA_BED -> this.getSBDepth() * -1.0;
        };
    }

    public int getWellID() {
        return this.wellID;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public void setWellCode(String wellCode) {
        this.wellCode = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(wellCode, "").toUpperCase());
    }

    public String getWellName() {
        return this.wellName;
    }

    public void setWellName(String wellName) {
        this.wellName = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(wellName, ""));
    }

    public SectionType getSectionType() {
        return this.sectionType;
    }

    public void setSectionType(SectionType sectionType) {
        this.sectionType = sectionType;
    }

    public double getTerminalDepth() {
        return this.terminalDepth;
    }

    public void setTerminalDepth(double terminalDepth) {
        this.terminalDepth = terminalDepth;
    }

    public WellDatum getDatum() {
        return this.datum;
    }

    public void setDatum(WellDatum datum) {
        this.datum = Objects.requireNonNullElse(datum, this.datum);
    }

    public Double getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(Double seaLevel) {
        this.seaLevel = seaLevel;
    }

    public Double getSeaBed() {
        return this.seaBed;
    }

    public void setSeaBed(Double seaBed) {
        this.seaBed = seaBed;
    }

    public Double getRotaryTableElevation() {
        return this.rotaryTableElevation;
    }

    public void setRotaryTableElevation(Double rotaryTableElevation) {
        this.rotaryTableElevation = rotaryTableElevation;
    }

    public Double getKickOff() {
        return this.kickOff;
    }

    public void setKickOff(Double kickOff) {
        this.kickOff = kickOff;
    }

    public String getWellAltName() {
        return this.wellAltName;
    }

    public String getWellAltName(boolean defaultToWellName) {
        if (defaultToWellName && this.wellAltName.isBlank()) {
            return this.wellName;
        }
        return this.wellAltName;
    }

    public void setWellAltName(String wellAltName) {
        this.wellAltName = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(wellAltName, ""));
    }

    public DepthUnits getUnits() {
        return this.units;
    }

    public void setUnits(DepthUnits units) {
        this.units = Objects.requireNonNullElse(units, this.units);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(country, ""));
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(field, ""));
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(area, ""));
    }

    public String getBasin() {
        return this.basin;
    }

    public void setBasin(String basin) {
        this.basin = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(basin, ""));
    }

    public String getLocState() {
        return this.locState;
    }

    public void setLocState(String locState) {
        this.locState = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(locState, ""));
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(operator, ""));
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(client, ""));
    }

    public String getOcs() {
        return this.ocs;
    }

    public void setOcs(String ocs) {
        this.ocs = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(ocs, ""));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(description, ""));
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = Objects.requireNonNullElse(colour, Color.BLACK);
    }

    public LocalDate getSpudDate() {
        return this.spudDate;
    }

    public void setSpudDate(LocalDate spudDate) {
        this.spudDate = spudDate;
    }

    public LocalDate getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(LocalDate completionDate) {
        this.completionDate = completionDate;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(county, ""));
    }

    public int getAcm() {
        return this.acm;
    }

    public void setAcm(int acm) {
        this.acm = acm;
    }

    public double getGridX() {
        return this.gridX;
    }

    public void setGridX(double gridX) {
        this.gridX = gridX;
    }

    public double getGridY() {
        return this.gridY;
    }

    public void setGridY(double gridY) {
        this.gridY = gridY;
    }

    public String getUtmZone() {
        return this.utmZone;
    }

    public void setUtmZone(String utmZone) {
        this.utmZone = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(utmZone, ""));
    }

    public Double getLat_dec() {
        return this.lat_dec;
    }

    public void setLat_dec(Double lat_dec) {
        this.lat_dec = lat_dec;
    }

    public DegreesMinutesSecondsCoordinate getLatitudeCoordinate() {
        return DegreesMinutesSecondsCoordinate.latitude(this.lat_dec);
    }

    public String getLatitudeString(boolean decimal) {
        if (this.lat_dec == null) {
            return "";
        }
        return decimal ? String.valueOf(this.lat_dec) : this.getLatitudeCoordinate().toString();
    }

    public Double getLong_dec() {
        return this.long_dec;
    }

    public void setLong_dec(Double long_dec) {
        this.long_dec = long_dec;
    }

    public DegreesMinutesSecondsCoordinate getLongitudeCoordinate() {
        return DegreesMinutesSecondsCoordinate.longitude(this.long_dec);
    }

    public String getLongitudeString(boolean decimal) {
        if (this.long_dec == null) {
            return "";
        }
        return decimal ? String.valueOf(this.long_dec) : this.getLongitudeCoordinate().toString();
    }

    public String getGeoDatum() {
        return this.geoDatum;
    }

    public void setGeoDatum(String geoDatum) {
        this.geoDatum = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(geoDatum, ""));
    }

    public float getDefaultChartScale() {
        return this.defaultChartScale;
    }

    public void setDefaultChartScale(float defaultChartScale) {
        this.defaultChartScale = defaultChartScale;
    }

    public boolean lithologyDepthsAreDrilled() {
        return this.lithologyDepthsAreDrilled;
    }

    public void setLithologyDepthsAreDrilled(boolean lithologyDepthsAreDrilled) {
        this.lithologyDepthsAreDrilled = lithologyDepthsAreDrilled;
    }

    public Integer getParentWellID() {
        return this.parentWellID;
    }

    public void setParentWellID(Integer parentWellID) {
        this.parentWellID = parentWellID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WellHeader that = (WellHeader)o;
        return this.wellCode.equals(that.wellCode) && this.wellName.equals(that.wellName) && this.wellAltName.equals(that.wellAltName) && this.sectionType == that.sectionType && this.units == that.units && Double.compare(that.gridX, this.gridX) == 0 && Double.compare(that.gridY, this.gridY) == 0 && Double.compare(that.terminalDepth, this.terminalDepth) == 0 && this.operator.equals(that.operator) && this.client.equals(that.client) && this.ocs.equals(that.ocs) && this.description.equals(that.description) && Objects.equals(this.spudDate, that.spudDate) && Objects.equals(this.completionDate, that.completionDate) && this.colour.equals(that.colour) && this.country.equals(that.country) && this.locState.equals(that.locState) && this.county.equals(that.county) && this.field.equals(that.field) && this.area.equals(that.area) && this.basin.equals(that.basin) && this.utmZone.equals(that.utmZone) && Objects.equals(this.lat_dec, that.lat_dec) && Objects.equals(this.long_dec, that.long_dec) && this.geoDatum.equals(that.geoDatum) && this.datum == that.datum && Objects.equals(this.seaLevel, that.seaLevel) && Objects.equals(this.seaBed, that.seaBed) && Objects.equals(this.rotaryTableElevation, that.rotaryTableElevation) && Objects.equals(this.kickOff, that.kickOff) && this.lithologyDepthsAreDrilled == that.lithologyDepthsAreDrilled && Float.compare(that.defaultChartScale, this.defaultChartScale) == 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.wellCode, this.wellName, this.wellAltName, this.sectionType, this.units, this.operator, this.client, this.ocs, this.description, this.spudDate, this.completionDate, this.colour, this.acm, Float.valueOf(this.defaultChartScale), this.lithologyDepthsAreDrilled, this.country, this.locState, this.county, this.field, this.area, this.basin, this.gridX, this.gridY, this.utmZone, this.lat_dec, this.long_dec, this.geoDatum, this.datum, this.terminalDepth, this.seaLevel, this.seaBed, this.rotaryTableElevation, this.kickOff});
    }
}

