/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.user.User;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.well.analysis.Occurrence;
import com.stratadata.model3.well.analysis.hdr.AnalystHeader;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Analysis
implements Audited {
    private final int sampID;
    private final AnalystHeader analystHeader;
    private Audit audit = new AuditImpl();
    @LimitedLengthString
    private String label;
    @LimitedLengthString
    private String picker;
    @LimitedLengthString
    private String source;
    @LimitedLengthString
    private String notes;
    private float weight;
    private float coarse;
    private float medium;
    private float fine;
    private int fieldsOfView;
    private int proximal;
    private int distal;
    private Set<Occurrence> occurrences = Collections.emptySet();

    public Analysis(int sampID, AnalystHeader analystHeader) {
        this.sampID = sampID;
        this.analystHeader = analystHeader;
    }

    public int getSampID() {
        return this.sampID;
    }

    public long getWellID() {
        return Optional.ofNullable(this.analystHeader).map(AnalystHeader::getWellID).orElse(0L);
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public void setAudit(Audit audit) {
        this.audit = Objects.requireNonNullElse(audit, new AuditImpl());
    }

    public Discipline getDiscipline() {
        if (this.analystHeader != null) {
            return this.analystHeader.getDiscipline();
        }
        return null;
    }

    public int getAnalyID() {
        if (this.analystHeader != null) {
            return this.analystHeader.getAnalyID();
        }
        return 0;
    }

    public int getSuiteNumber() {
        if (this.analystHeader != null) {
            return this.analystHeader.getSuiteNumber();
        }
        return 0;
    }

    public User getAnalyst() {
        if (this.analystHeader != null) {
            return this.analystHeader.getAnalyst();
        }
        return null;
    }

    public int getAbnSchID() {
        if (this.analystHeader != null) {
            return this.analystHeader.getAbnSchID();
        }
        return 0;
    }

    public Set<Occurrence> getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(Set<Occurrence> occurrences) {
        this.occurrences = Objects.requireNonNullElse(occurrences, Collections.emptySet());
    }
}

