/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public sealed interface AbundanceScheme
extends Audited,
Comparable<AbundanceScheme>
permits AbundanceSchemeImpl {
    public static final int MAX_CLASSES = 12;
    public static final int MAX_ABR_LENGTH = 4;
    public static final int MAX_ENTRY_NAME_LENGTH = 25;
    public static final String OTC_STRG = "Outside the count (+)";

    @Override
    default public int compareTo(AbundanceScheme o) {
        return StringUtils.compareIgnoreCase((String)this.getName(), (String)o.getName());
    }

    public int getAbnSchID();

    public String getName();

    @Override
    public Audit getAudit();

    public List<AbundanceSchemeEntry> getEntries();

    public int getEntryCount();

    public AbundanceSchemeEntry getEntry(int var1);

    public Optional<AbundanceSchemeEntry> findEntryByName(String var1);

    public Optional<AbundanceSchemeEntry> findEntryBySubjAbund(String var1);

    default public int getCountBySubjAbund(String subjAbund) {
        return this.findEntryBySubjAbund(subjAbund).map(AbundanceSchemeEntry::getCount).orElse(0);
    }

    public Optional<AbundanceSchemeEntry> findEntryByCount(int var1);

    default public String getSubjAbundByCount(int count) {
        return this.findEntryByCount(count).map(AbundanceSchemeEntry::abr).orElse(OTC_STRG);
    }

    public int getIndex(int var1);

    public int getIndex(String var1);

    public boolean canIncrementSubjAbund(String var1);

    public record AbundanceSchemeEntry(String entryName, String abr, int lowBound, int outputVal) {
        @Override
        public String toString() {
            return this.entryName;
        }

        public int getCount() {
            return this.outputVal > 0 ? this.outputVal : this.lowBound;
        }
    }
}

