/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.Validatable;
import com.stratadata.model3.validation.Validation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@Validatable
public final class AbundanceSchemeImpl
implements AbundanceScheme {
    private final int abnSchID;
    @NotEmptyString(fieldName="scheme name")
    @LimitedLengthString
    private String name = "";
    private final Audit audit;
    private final List<AbundanceScheme.AbundanceSchemeEntry> entries = new ArrayList<AbundanceScheme.AbundanceSchemeEntry>();

    public AbundanceSchemeImpl(int abnSchID) {
        this(abnSchID, new AuditImpl(), Collections.emptyList());
    }

    public AbundanceSchemeImpl(int abnSchID, AuditImpl audit, List<AbundanceScheme.AbundanceSchemeEntry> entries) {
        this.abnSchID = abnSchID;
        this.audit = audit;
        this.entries.addAll(entries);
    }

    public AbundanceSchemeImpl(AbundanceScheme abundanceScheme) {
        this.abnSchID = abundanceScheme.getAbnSchID();
        this.name = abundanceScheme.getName();
        this.audit = abundanceScheme.getAudit();
        this.entries.addAll(abundanceScheme.getEntries());
    }

    @Override
    @Ident
    public int getAbnSchID() {
        return this.abnSchID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.trimToEmpty((String)Objects.requireNonNullElse(name, ""));
    }

    @Override
    public List<AbundanceScheme.AbundanceSchemeEntry> getEntries() {
        return new ArrayList<AbundanceScheme.AbundanceSchemeEntry>(this.entries);
    }

    @Override
    public int getEntryCount() {
        return this.entries.size();
    }

    @Override
    public AbundanceScheme.AbundanceSchemeEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public void addEntry(AbundanceScheme.AbundanceSchemeEntry entry) {
        this.entries.add(entry);
    }

    public void addEntries(Collection<AbundanceScheme.AbundanceSchemeEntry> toAdd) {
        this.entries.addAll(toAdd);
    }

    public void setEntry(int index, AbundanceScheme.AbundanceSchemeEntry entry) {
        this.entries.set(index, entry);
    }

    public void insertEntry(int index, AbundanceScheme.AbundanceSchemeEntry entry) {
        this.entries.add(index, entry);
    }

    public void removeEntry(int index) {
        this.entries.remove(index);
    }

    public void clearEntries() {
        this.entries.clear();
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    @Validation
    public List<String> validateEntries() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.entries.size() > 12) {
            validationMessages.add("Too many entries (max 12)");
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            AbundanceScheme.AbundanceSchemeEntry entry = this.entries.get(i);
            if (StringUtils.isBlank((CharSequence)entry.abr())) {
                validationMessages.add("Entry at row " + (i + 1) + " is blank");
            } else {
                if (!StringUtils.isAlpha((CharSequence)entry.abr())) {
                    validationMessages.add("Entry at row " + (i + 1) + " contains non-letter characters");
                }
                if (entry.abr().length() > 4) {
                    validationMessages.add("Entry at row " + (i + 1) + " exceeds maximum length of 4");
                }
            }
            if (StringUtils.isBlank((CharSequence)entry.entryName())) {
                validationMessages.add("Description at row " + (i + 1) + " is blank");
            }
            if (entry.lowBound() >= 0) continue;
            validationMessages.add("Minimum value at row " + (i + 1) + " is invalid");
        }
        HashSet uniqueAbrs = new HashSet();
        List<String> duplicateAbrs = this.entries.stream().map(AbundanceScheme.AbundanceSchemeEntry::abr).filter(abr -> !uniqueAbrs.add(abr)).toList();
        if (!duplicateAbrs.isEmpty()) {
            validationMessages.add("Duplicate entries: " + StringUtils.join(duplicateAbrs, (String)", "));
        }
        HashSet uniqueEntryNames = new HashSet();
        List<String> duplicateEntryNames = this.entries.stream().map(AbundanceScheme.AbundanceSchemeEntry::entryName).filter(name -> !uniqueEntryNames.add(name)).toList();
        if (!duplicateEntryNames.isEmpty()) {
            validationMessages.add("Duplicate descriptions: " + StringUtils.join(duplicateEntryNames, (String)", "));
        }
        HashSet uniqueLowBounds = new HashSet();
        List<Integer> duplicateLowBounds = this.entries.stream().map(AbundanceScheme.AbundanceSchemeEntry::lowBound).filter(lowBound -> !uniqueLowBounds.add(lowBound)).toList();
        if (!duplicateLowBounds.isEmpty()) {
            validationMessages.add("Duplicate values: " + StringUtils.join(duplicateLowBounds, (String)", "));
        }
        return validationMessages;
    }

    public void sortEntries() {
        this.entries.sort(Comparator.comparingInt(AbundanceScheme.AbundanceSchemeEntry::lowBound));
    }

    public String toString() {
        if (this.getName().isEmpty()) {
            return "AbundanceScheme:" + this.getAbnSchID();
        }
        return this.getName();
    }

    @Override
    public Optional<AbundanceScheme.AbundanceSchemeEntry> findEntryByName(String entryName) {
        return this.getEntries().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)entry.entryName(), (CharSequence)entryName)).findFirst();
    }

    @Override
    public Optional<AbundanceScheme.AbundanceSchemeEntry> findEntryBySubjAbund(String subjAbund) {
        if (StringUtils.isBlank((CharSequence)subjAbund)) {
            return Optional.empty();
        }
        for (AbundanceScheme.AbundanceSchemeEntry entry : this.getEntries()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entry.abr(), (CharSequence)subjAbund)) continue;
            return Optional.of(entry);
        }
        for (AbundanceScheme.AbundanceSchemeEntry entry : this.getEntries()) {
            if (entry.abr().length() <= 1 || !entry.abr().toLowerCase().startsWith(subjAbund.toLowerCase())) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    @Override
    public Optional<AbundanceScheme.AbundanceSchemeEntry> findEntryByCount(int count) {
        Optional<AbundanceScheme.AbundanceSchemeEntry> outsideTheCount;
        if (this.entries.isEmpty()) {
            return Optional.empty();
        }
        if (count == 0 && (outsideTheCount = this.entries.stream().filter(e -> "+".equals(e.abr())).findAny()).isPresent()) {
            return outsideTheCount;
        }
        for (int i = 0; i < this.entries.size() - 1; ++i) {
            AbundanceScheme.AbundanceSchemeEntry entry = this.entries.get(i);
            if (count < entry.lowBound()) {
                return Optional.of(entry);
            }
            if (count < entry.lowBound() || count >= this.entries.get(i + 1).lowBound()) continue;
            return Optional.of(entry);
        }
        return Optional.of(this.entries.getLast());
    }

    @Override
    public int getIndex(int count) {
        return this.findEntryByCount(count).map(this.entries::indexOf).orElse(-1);
    }

    @Override
    public int getIndex(String subjAbund) {
        return this.findEntryBySubjAbund(subjAbund).map(this.entries::indexOf).orElse(-1);
    }

    @Override
    public boolean canIncrementSubjAbund(String subjAbund) {
        return this.findEntryBySubjAbund(subjAbund).map(entry -> entry != this.entries.getLast()).orElse(!this.entries.isEmpty());
    }
}

