/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class AbundanceSchemeServiceImpl
implements AbundanceSchemeService {
    private final HashMap<Integer, AbundanceScheme> abundanceSchemes = new HashMap();
    private HashMap<Integer, AbundanceScheme> links = new HashMap();

    @Override
    public Optional<AbundanceScheme> findAbundanceScheme(int abnSchID) {
        return Optional.ofNullable(this.abundanceSchemes.get(abnSchID));
    }

    @Override
    public List<AbundanceScheme> getAllAbundanceSchemes() {
        return new ArrayList<AbundanceScheme>(this.abundanceSchemes.values());
    }

    @Override
    public int getAbundanceSchemeCount() {
        return this.abundanceSchemes.size();
    }

    @Override
    public AbundanceScheme addAbundanceScheme(AbundanceScheme scheme) {
        SbugsValidator validator;
        int abnSchID = scheme.getAbnSchID();
        if (abnSchID == 0) {
            abnSchID = this.abundanceSchemes.values().stream().map(AbundanceScheme::getAbnSchID).max(Integer::compareTo).orElse(0) + 1;
            String schemeName = scheme.getName();
            scheme = new AbundanceSchemeImpl(abnSchID, new AuditImpl(), scheme.getEntries());
            ((AbundanceSchemeImpl)scheme).setName(schemeName);
        }
        if (!(validator = SbugsValidator.validate(scheme, SbugsValidator.ValidationStrategy.IGNORE_ID)).isValid()) {
            System.out.println("WARNING: invalid abundance scheme in workspace " + String.valueOf(validator.getMessages()));
        } else if (this.abundanceSchemes.get(scheme.getAbnSchID()) != null) {
            throw new IllegalStateException("Scheme already exists");
        }
        this.abundanceSchemes.put(scheme.getAbnSchID(), scheme);
        return scheme;
    }

    @Override
    public void deleteAbundanceScheme(int abnSchID) {
        this.abundanceSchemes.remove(abnSchID);
    }

    @Override
    public void updateAbundanceScheme(AbundanceSchemeImpl updatedScheme) {
        this.abundanceSchemes.put(updatedScheme.getAbnSchID(), updatedScheme);
    }

    public Integer getLink(int abnSchID) {
        return Optional.ofNullable(this.links.get(abnSchID)).map(AbundanceScheme::getAbnSchID).orElse(null);
    }

    public AbundanceScheme getLinkObject(int abnSchID) {
        return this.links.get(abnSchID);
    }

    public void setLink(int abnSchID, AbundanceScheme linkAbnSch) {
        if (this.abundanceSchemes.get(abnSchID) == null) {
            throw new IllegalArgumentException("Abundance scheme " + abnSchID + " does not exist in workspace");
        }
        this.links.put(abnSchID, linkAbnSch);
    }
}

