/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.user.User;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotNull;
import com.stratadata.model3.validation.Validatable;
import java.awt.Color;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class AnalystHeader
implements Audited {
    private final long wellID;
    private final int analyID;
    @NotNull
    private Discipline discipline = Discipline.MICRO;
    @NotNull
    private User analyst;
    private int suiteNumber = 1;
    private final AuditImpl audit;
    private LocalDate from;
    private LocalDate to;
    private Double depthFrom;
    private Double depthTo;
    @LimitedLengthString
    private String comments;
    private Color colour = Color.BLACK;
    private int envSchID;
    private int abnSchID;

    public AnalystHeader(long wellID, int analyID, AuditImpl audit) {
        this.wellID = wellID;
        this.analyID = analyID;
        this.audit = audit;
    }

    public AnalystHeader(long wellID, int analyID) {
        this(wellID, analyID, new AuditImpl());
    }

    public String toString() {
        if (this.analyst != null) {
            return this.analyst.getAbr() + "/" + this.suiteNumber;
        }
        return super.toString();
    }

    @Ident
    public long getWellID() {
        return this.wellID;
    }

    @Ident
    public int getAnalyID() {
        return this.analyID;
    }

    public int getSuiteNumber() {
        return this.suiteNumber;
    }

    public void setSuiteNumber(int suiteNumber) {
        if (suiteNumber < 1) {
            throw new IllegalArgumentException();
        }
        this.suiteNumber = suiteNumber;
    }

    public int getAnalystID() {
        return Optional.ofNullable(this.analyst).map(User::getUserID).orElse(0);
    }

    public User getAnalyst() {
        return this.analyst;
    }

    public void setAnalyst(User analyst) {
        this.analyst = analyst;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = Objects.requireNonNullElse(discipline, this.discipline);
    }

    public void setColour(Color colour) {
        this.colour = Objects.requireNonNullElse(colour, this.colour);
    }

    public int getAbnSchID() {
        return this.abnSchID;
    }

    public void setAbnSchID(int abnSchID) {
        if (abnSchID < 0) {
            abnSchID = 0;
        }
        this.abnSchID = abnSchID;
    }

    public int getEnvSchID() {
        return this.envSchID;
    }

    public void setEnvSchID(int envSchID) {
        if (envSchID < 0) {
            envSchID = 0;
        }
        this.envSchID = envSchID;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = StringUtils.trimToNull((String)comments);
    }

    public Double getDepthTo() {
        return this.depthTo;
    }

    public void setDepthTo(Double depthTo) {
        this.depthTo = depthTo;
    }

    public Double getDepthFrom() {
        return this.depthFrom;
    }

    public void setDepthFrom(Double depthFrom) {
        this.depthFrom = depthFrom;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public void setTo(LocalDate to) {
        this.to = to;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public void setFrom(LocalDate from) {
        this.from = from;
    }
}

