/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.sample;

import com.stratadata.model3.well.sample.SampleTypePrecisionException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum SampleType {
    CU("CU", "Cutt.", "Cutting", 0, true, true),
    CO("CO", "Core", "Core sample", 2, true, true),
    SC("SC", "Swc", "Sidewall core", 1, false, true),
    SP("SP", "Spot", "Spot cutting", 2, false, true),
    LOG("LOG", "Log", "Log pick", 1, false, false),
    OC("OC", "Outcrop", "Outcrop sample", 2, true, true);

    private final String abr;
    private final String shortName;
    private final String longName;
    private int precision;
    private final boolean depthRange;
    private final boolean analysis;

    private SampleType(String abr, String shortName, String longName, int precision, boolean depthRange, boolean analysis) {
        this.abr = abr;
        this.shortName = shortName;
        this.longName = longName;
        this.precision = precision;
        this.depthRange = depthRange;
        this.analysis = analysis;
    }

    public double getRoundedDepth(double depth) {
        double d = Math.pow(10.0, this.precision);
        return (double)Math.round(depth * d) / d;
    }

    public static void setLogSamplePrecision(int dp) throws SampleTypePrecisionException {
        if (dp < 1 || dp > 3) {
            throw new SampleTypePrecisionException("Log sample precision must be in the range 1-3");
        }
        SampleType.LOG.precision = dp;
    }

    public static SampleType getType(String typeAbr) {
        for (SampleType t : SampleType.values()) {
            if (!typeAbr.equalsIgnoreCase(t.name())) continue;
            return t;
        }
        throw new IllegalArgumentException("Unrecognised sample type: " + typeAbr);
    }

    public static SampleType parseType(String buff) {
        for (SampleType t : SampleType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)t.abr, (CharSequence)buff) && !StringUtils.equalsIgnoreCase((CharSequence)t.shortName, (CharSequence)buff) && !StringUtils.equalsIgnoreCase((CharSequence)t.longName, (CharSequence)buff)) continue;
            return t;
        }
        buff = buff.toUpperCase(Locale.UK).trim();
        switch (buff) {
            case "CU": 
            case "DC": 
            case "WDC": 
            case "DDC": 
            case "CUTTING": 
            case "CUTT": 
            case "DITCH CUTTING": 
            case "CTG": {
                return CU;
            }
            case "SC": 
            case "SWC": 
            case "MSCT": 
            case "SW": 
            case "SWS": 
            case "SIDEWALL CORE": {
                return SC;
            }
            case "CO": 
            case "CORE": 
            case "CC": {
                return CO;
            }
            case "OC": {
                return OC;
            }
            case "LOG": {
                return LOG;
            }
            case "SP": {
                return SP;
            }
        }
        if (buff.startsWith("SWC") || buff.startsWith("SC")) {
            return SC;
        }
        return null;
    }

    public boolean correctDepth(boolean correctCores, boolean correctCuttings) {
        return switch (this.ordinal()) {
            case 1, 3 -> correctCores;
            case 0 -> correctCuttings;
            default -> false;
        };
    }

    public String getAbr() {
        return this.abr;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isDepthRange() {
        return this.depthRange;
    }

    public boolean isAnalysis() {
        return this.analysis;
    }
}

