/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.wellinterp;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.wellinterp.DuplicateNodeException;
import com.stratadata.model3.wellinterp.LOCNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class DepthAgeCurve {
    private final List<LOCNode> nodes = new LinkedList<LOCNode>();

    public List<LOCNode> getNodes() {
        return new LinkedList<LOCNode>(this.nodes);
    }

    public Iterator<LOCNode> getNodeIterator() {
        return this.nodes.iterator();
    }

    public LOCNode addNode(LOCNode node) throws DuplicateNodeException {
        return this.addNode(node.getDepth(), node.getAge(), node.getBnd());
    }

    public LOCNode addNode(double depth, double age, int bnd) throws DuplicateNodeException {
        return this.addNode(depth, age, bnd, true);
    }

    public LOCNode addNode(double depth, double age, int bnd, boolean sort) throws DuplicateNodeException {
        this.checkNewNode(depth, age);
        LOCNode node = new LOCNode(depth, age, bnd);
        this.nodes.add(node);
        if (sort) {
            Collections.sort(this.nodes);
        }
        return node;
    }

    public void addNodes(Collection<LOCNode> nodesToAdd) {
        nodesToAdd.forEach(nodeToAdd -> {
            try {
                this.checkNewNode(nodeToAdd.getDepth(), nodeToAdd.getAge());
            }
            catch (DuplicateNodeException ex) {
                throw new RuntimeException("Unexpected duplicate node in stream", ex);
            }
            LOCNode node = new LOCNode((LOCNode)nodeToAdd);
            this.nodes.add(node);
        });
        Collections.sort(this.nodes);
    }

    public void checkNewNode(double depth, double age) throws DuplicateNodeException {
        String key = LOCNode.getNodeKey(depth, age);
        for (LOCNode node : this.nodes) {
            if (!node.getKey().equals(key)) continue;
            throw new DuplicateNodeException(node);
        }
    }

    public void validateBoundaries() {
        Collections.sort(this.nodes);
        for (int i = 0; i < this.nodes.size() - 1; ++i) {
            LOCNode node = this.nodes.get(i);
            LOCNode next = this.nodes.get(i + 1);
            Boundary bnd = Boundary.getBnd(node.getBnd());
            if (Math.abs(next.getDepth() - node.getDepth()) < 0.0029) {
                if (bnd.isDisconformable()) continue;
                node.setBnd(Boundary.UNCF.getBndInt());
                continue;
            }
            if (!bnd.isDisconformable()) continue;
            node.setBnd(Boundary.CONF.getBndInt());
        }
    }

    public void updateBnd(LOCNode node, int newBnd) {
        for (LOCNode n : this.nodes) {
            if (!n.getKey().equals(node.getKey())) continue;
            node.setBnd(newBnd);
            return;
        }
    }

    public boolean removeNode(LOCNode node) {
        for (LOCNode n : this.nodes) {
            if (!n.getKey().equals(node.getKey())) continue;
            this.nodes.remove(n);
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.nodes.size();
    }

    public LOCNode getNode(int index) {
        return this.nodes.get(index);
    }

    public int getIndexOfNode(LOCNode node) {
        String nodeKey = node.getKey();
        for (int i = 0; i < this.nodes.size(); ++i) {
            LOCNode n = this.nodes.get(i);
            if (!n.getKey().equals(nodeKey)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(String key) {
        return this.nodes.stream().anyMatch(n -> n.getKey().equals(key));
    }

    private LOCNode[] getBoundingNodes(Number depthNumber, boolean extrapolate) {
        float depth = depthNumber.floatValue();
        LOCNode node1 = null;
        boolean nFirst = false;
        boolean nSecond = true;
        int nLast = this.nodes.size() - 1;
        int nPenultimate = this.nodes.size() - 2;
        if (extrapolate) {
            if (depth >= (float)this.nodes.get(nLast).getDepth()) {
                return new LOCNode[]{this.nodes.get(nPenultimate), this.nodes.get(nLast)};
            }
            if (depth <= (float)this.nodes.get(0).getDepth()) {
                return new LOCNode[]{this.nodes.get(0), this.nodes.get(1)};
            }
        }
        Iterator<LOCNode> it = this.nodes.iterator();
        while (it.hasNext()) {
            LOCNode node = it.next();
            if (Boundary.getBnd(node.getBnd()).isDisconformable() && (double)Math.abs((float)node.getDepth() - depth) < 0.0029) {
                return new LOCNode[]{node, it.hasNext() ? it.next() : null};
            }
            if (depth >= (float)node.getDepth()) {
                node1 = node;
                continue;
            }
            if (!((double)depth < node.getDepth()) || node1 == null) continue;
            return new LOCNode[]{node1, node};
        }
        if (node1 != null && (double)Math.abs((float)node1.getDepth() - depth) < 0.0029) {
            return new LOCNode[]{node1, node1};
        }
        return null;
    }

    public double getAge(Number depthNumber, boolean extrapolate, boolean minPref) {
        if (this.nodes.isEmpty()) {
            return -1.0;
        }
        LOCNode[] boundingNodes = this.getBoundingNodes(depthNumber, extrapolate);
        if (boundingNodes == null) {
            return -1.0;
        }
        LOCNode node1 = boundingNodes[0];
        LOCNode node2 = boundingNodes[1];
        if (node1 != null && node2 != null) {
            if (node1 == node2 || Math.abs(node1.getDepth() - node2.getDepth()) < 0.0029) {
                return minPref ? Math.min(node1.getAge(), node2.getAge()) : Math.max(node1.getAge(), node2.getAge());
            }
            return node1.getAge() + (depthNumber.doubleValue() - node1.getDepth()) * (node2.getAge() - node1.getAge()) / (node2.getDepth() - node1.getDepth());
        }
        return -1.0;
    }

    public int getBoundary(double depth) {
        if (this.nodes.isEmpty()) {
            return -1;
        }
        LOCNode node1 = null;
        for (LOCNode node : this.nodes) {
            if (Math.abs(depth - node.getDepth()) < 0.0029) {
                return node.getBnd();
            }
            if (node.getDepth() < depth) {
                node1 = node;
            }
            if (!(node.getDepth() > depth)) continue;
            if (node1 == null) break;
            return node1.getBnd();
        }
        return -1;
    }

    public double getMinAge() {
        double age = 9999.0;
        for (LOCNode node : this.nodes) {
            if (!(node.getAge() < age)) continue;
            age = node.getAge();
        }
        if (age > 9000.0) {
            return 0.0;
        }
        return age;
    }

    public double getMinAge(double minDepth) {
        double age = this.getMaxAge();
        ListIterator<LOCNode> it = this.nodes.listIterator(this.nodes.size() - 1);
        while (it.hasPrevious()) {
            LOCNode node = it.previous();
            if (node.getDepth() < minDepth) {
                return age;
            }
            if (!(node.getAge() < age)) continue;
            age = node.getAge();
        }
        return age;
    }

    public double getMaxAge() {
        double age = 0.0;
        for (LOCNode node : this.nodes) {
            if (!(node.getAge() > age)) continue;
            age = node.getAge();
        }
        return age;
    }

    public double getMaxAge(Double maxDepth) {
        double age = 0.0;
        for (LOCNode node : this.nodes) {
            if (node.getAge() > age && (maxDepth == null || node.getDepth() <= maxDepth)) {
                age = node.getAge();
            }
            if (maxDepth == null || !(node.getDepth() > maxDepth)) continue;
            break;
        }
        return age;
    }

    public float[] getAgeLimits(float fromDepth, float toDepth) {
        if (this.nodes.isEmpty()) {
            return new float[]{-1.0f, -1.0f};
        }
        float[] limits = new float[2];
        double age1 = this.getAge(Float.valueOf(fromDepth), true, true);
        double age2 = this.getAge(Float.valueOf(toDepth), false, true);
        limits[0] = (float)Math.min(age1, age2);
        limits[1] = (float)Math.max(age1, age2);
        for (LOCNode node : this.nodes) {
            if (node.getDepth() < (double)fromDepth) continue;
            if (node.getDepth() > (double)toDepth) break;
            if (node.getAge() < (double)limits[0]) {
                limits[0] = (float)node.getAge();
            }
            if (!(node.getAge() > (double)limits[1])) continue;
            limits[1] = (float)node.getAge();
        }
        return limits;
    }

    public double[] getAgeRange(double minDepth, double maxDepth) {
        double age1 = this.getAge(minDepth, false, true);
        double age2 = this.getAge(maxDepth, false, true);
        if (age1 < 0.0) {
            age1 = this.nodes.get(0).getAge();
        }
        if (age2 < 0.0) {
            age2 = this.nodes.get(this.nodes.size() - 1).getAge();
        }
        double min = Math.min(age1, age2);
        double max = Math.max(age1, age2);
        for (LOCNode node : this.nodes) {
            if (node.getDepth() < minDepth) continue;
            if (node.getDepth() > maxDepth) break;
            if (node.getAge() < min) {
                min = node.getAge();
            }
            if (!(node.getAge() > max)) continue;
            max = node.getAge();
        }
        assert (min >= 0.0 && max >= 0.0);
        return new double[]{min, max};
    }

    public Boolean isAgeIncreasing(double depth) {
        if (this.nodes.isEmpty()) {
            return null;
        }
        LOCNode[] boundingNodes = this.getBoundingNodes(depth, false);
        if (boundingNodes == null) {
            return null;
        }
        LOCNode node1 = boundingNodes[0];
        LOCNode node2 = boundingNodes[1];
        return node2.getAge() >= node1.getAge();
    }

    public double[] getDepthRange(double minAge, double maxAge) {
        assert (minAge < maxAge);
        Double depth1 = this.getDepthOfAge(minAge, null, null, true);
        Double depth2 = this.getDepthOfAge(maxAge, null, null, false);
        if (depth1 == null) {
            depth1 = this.nodes.get(0).getDepth();
        }
        if (depth2 == null) {
            depth2 = this.nodes.get(this.nodes.size() - 1).getDepth();
        }
        double min = Math.min(depth1, depth2);
        double max = Math.max(depth1, depth2);
        for (LOCNode node : this.nodes) {
            if (!(node.getAge() >= minAge) || !(node.getAge() <= maxAge)) continue;
            if (node.getDepth() < min) {
                min = node.getDepth();
            }
            if (!(node.getDepth() > max)) continue;
            max = node.getDepth();
        }
        assert (min >= 0.0 && max >= 0.0);
        return new double[]{min, max};
    }

    public double getMaxDepth() {
        if (this.nodes.isEmpty()) {
            return 0.0;
        }
        return this.nodes.get(this.nodes.size() - 1).getDepth();
    }

    public double getMinDepth() {
        if (this.nodes.isEmpty()) {
            return 0.0;
        }
        return this.nodes.get(0).getDepth();
    }

    public Double getDepthOfAge(double age, boolean first) {
        return this.getDepthOfAge(age, null, null, first);
    }

    public Double getDepthOfAge(double age, Double minDepth, Double maxDepth, boolean first) {
        if (Double.isNaN(age)) {
            return null;
        }
        if (minDepth == null ^ maxDepth == null) {
            throw new IllegalArgumentException("Only one depth bracket specified in LOC.getDepth");
        }
        if (this.nodes.isEmpty()) {
            return null;
        }
        ListIterator<LOCNode> it = first ? this.nodes.listIterator() : this.nodes.listIterator(this.nodes.size());
        LOCNode last = null;
        while (first ? it.hasNext() : it.hasPrevious()) {
            LOCNode node;
            LOCNode lOCNode = node = first ? it.next() : it.previous();
            if (Math.abs(node.getAge() - age) < 0.001) {
                return node.getDepth();
            }
            if (last != null && age > Math.min(node.getAge(), last.getAge()) && age <= Math.max(node.getAge(), last.getAge())) {
                LOCNode node1 = node;
                LOCNode node2 = last;
                double depth = DepthAgeCurve.getDepth(age, node1, node2);
                if (minDepth == null || depth >= minDepth && depth <= maxDepth) {
                    return depth;
                }
            }
            last = node;
        }
        return null;
    }

    private static double getDepth(double age, LOCNode node1, LOCNode node2) {
        if (node1 == null || node2 == null) {
            return -1.0;
        }
        if (!(age >= Math.min(node1.getAge(), node2.getAge())) || !(age <= Math.max(node1.getAge(), node2.getAge()))) {
            assert (false);
            return -1.0;
        }
        if (node1 == node2 || Math.abs(node1.getDepth() - node2.getDepth()) < 0.0029) {
            return node1.getDepth();
        }
        if (Math.abs(age - node1.getAge()) < 0.0029) {
            return node1.getDepth();
        }
        if (Math.abs(node2.getAge() - age) < 0.0029) {
            return node2.getDepth();
        }
        if (node1.getDepth() > node2.getDepth()) {
            LOCNode temp = node1;
            node1 = node2;
            node2 = temp;
        }
        boolean normal = node1.getAge() < node2.getAge();
        return node1.getDepth() + (node2.getDepth() - node1.getDepth()) / (normal ? node2.getAge() - node1.getAge() : node1.getAge() - node2.getAge()) * (normal ? age - node1.getAge() : node1.getAge() - age);
    }

    public double[] getDepths(double age) {
        if (this.nodes.isEmpty()) {
            return null;
        }
        if (age < this.getMinAge()) {
            return null;
        }
        if (age > this.getMaxAge()) {
            return null;
        }
        LinkedList<Double> depths = new LinkedList<Double>();
        LOCNode lastNode = null;
        for (LOCNode node : this.nodes) {
            LOCNode older;
            if (lastNode == null) {
                lastNode = node;
                continue;
            }
            LOCNode younger = lastNode.getAge() < node.getAge() ? lastNode : node;
            LOCNode lOCNode = older = younger == lastNode ? node : lastNode;
            if (age >= younger.getAge() && age <= older.getAge()) {
                boolean normal;
                LOCNode node1 = lastNode.getDepth() < node.getDepth() ? lastNode : node;
                LOCNode node2 = node1 == lastNode ? node : lastNode;
                boolean bl = normal = node1.getAge() < node2.getAge();
                if (Math.abs(node1.getDepth() - node2.getDepth()) < 0.01) {
                    depths.add(node1.getDepth());
                } else {
                    depths.add(node1.getDepth() + (node2.getDepth() - node1.getDepth()) / (normal ? node2.getAge() - node1.getAge() : node1.getAge() - node2.getAge()) * (normal ? age - node1.getAge() : node1.getAge() - age));
                }
            }
            lastNode = node;
        }
        if (!depths.isEmpty()) {
            double[] d = new double[depths.size()];
            for (int i = 0; i < depths.size(); ++i) {
                d[i] = (Double)depths.get(i);
            }
            return d;
        }
        return null;
    }

    public double getTopDepth() {
        double topDepth = 99999.0;
        for (LOCNode node : this.nodes) {
            if (!(node.getDepth() < topDepth)) continue;
            topDepth = node.getDepth();
        }
        return topDepth;
    }

    public double getBaseDepth() {
        double baseDepth = -99999.0;
        for (LOCNode node : this.nodes) {
            if (!(node.getDepth() > baseDepth)) continue;
            baseDepth = node.getDepth();
        }
        return baseDepth;
    }

    public float getSedimentationRate(double depth) {
        if (this.nodes.isEmpty()) {
            return -1.0f;
        }
        LOCNode[] boundingNodes = this.getBoundingNodes(depth, true);
        LOCNode node1 = boundingNodes[0];
        LOCNode node2 = boundingNodes[1];
        if (node1 != null && node2 != null) {
            return (float)((node2.getDepth() - node1.getDepth()) / (node2.getAge() - node1.getAge()));
        }
        return -1.0f;
    }
}

