/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.wellinterp;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.scheme.IgdType;
import com.stratadata.model3.well.sample.Sample;
import java.util.Objects;

public class StratigraphicInterval
implements Audited,
Comparable<StratigraphicInterval> {
    private final IgdType igdType;
    private final int schID;
    private final long wellID;
    private final int interpID;
    private Sample topSample;
    private Sample baseSample;
    private int hier;
    private int uppZone = 0;
    private int lowZone = 0;
    private Boundary topBoundary = Boundary.PROB;
    private Boundary baseBoundary = Boundary.PROB;
    private Confidence confidence = Confidence.CONFIDENT;
    private String uppInf = "";
    private String lowInf = "";
    private boolean qUzone;
    private boolean qLzone;
    private String sep = "-";
    private Audit audit = new AuditImpl();
    private int topAnalyst;
    private int baseAnalyst;

    public StratigraphicInterval(IgdType igdType, int schID, long wellID, int interpID) {
        this.igdType = igdType;
        this.schID = schID;
        this.wellID = wellID;
        this.interpID = interpID;
    }

    public String getNameString() {
        StringBuilder nameBuilder = new StringBuilder();
        if (this.qUzone) {
            nameBuilder.append("?");
        }
        nameBuilder.append(this.uppInf);
        if (!this.lowInf.isEmpty() && !this.lowInf.equalsIgnoreCase(this.uppInf)) {
            nameBuilder.append(" " + this.sep + " ");
            if (this.qUzone) {
                nameBuilder.append("?");
            }
            nameBuilder.append(this.lowInf);
        }
        return nameBuilder.toString();
    }

    public IgdType getIgdType() {
        return this.igdType;
    }

    public long getWellID() {
        return this.wellID;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public int getSchID() {
        return this.schID;
    }

    public int getUppZone() {
        return this.uppZone;
    }

    public int getLowZone() {
        return this.lowZone;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public double getTopDepth() {
        return this.topSample.getDepth();
    }

    public double getBaseDepth() {
        return this.baseSample.getDepth();
    }

    public Sample getTopSample() {
        return this.topSample;
    }

    public void setTopSample(Sample topSample) {
        this.topSample = topSample;
    }

    public Sample getBaseSample() {
        return this.baseSample;
    }

    public void setBaseSample(Sample baseSample) {
        this.baseSample = baseSample;
    }

    public Boundary getTopBoundary() {
        return this.topBoundary;
    }

    public void setTopBoundary(Boundary topBoundary) {
        this.topBoundary = topBoundary;
    }

    public Boundary getBaseBoundary() {
        return this.baseBoundary;
    }

    public void setBaseBoundary(Boundary baseBoundary) {
        this.baseBoundary = baseBoundary;
    }

    public int getHier() {
        return this.hier;
    }

    public void setHier(int hier) {
        this.hier = hier;
    }

    public void setUppZone(int uppZone) {
        this.uppZone = uppZone;
    }

    public void setLowZone(int lowZone) {
        this.lowZone = lowZone;
    }

    public String getUppInf() {
        return this.uppInf;
    }

    public void setUppInf(String uppInf) {
        this.uppInf = Objects.requireNonNullElse(uppInf, "").trim();
    }

    public String getLowInf() {
        return this.lowInf;
    }

    public void setLowInf(String lowInf) {
        this.lowInf = Objects.requireNonNullElse(lowInf, "").trim();
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @Override
    public int compareTo(StratigraphicInterval o) {
        int topSampleCompare = this.topSample.compareTo(o.getTopSample());
        if (topSampleCompare != 0) {
            return topSampleCompare;
        }
        return Integer.compare(this.hier, o.getHier());
    }
}

