/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.wellinterp.generate;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.StratigraphicUnit;
import com.stratadata.model3.scheme.StratigraphicUnitService;
import com.stratadata.model3.wellinterp.DepthAgeCurve;
import com.stratadata.model3.wellinterp.DuplicateNodeException;
import com.stratadata.model3.wellinterp.StratigraphicInterval;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class DepthAgeGenerator {
    private static final Logger LOGGER = Logger.getLogger(DepthAgeGenerator.class.getName());
    private final StratigraphicUnitService unitService;
    private List<StratigraphicInterval> intervals;

    public DepthAgeGenerator(StratigraphicUnitService unitService) {
        this.unitService = unitService;
    }

    public void setIntervals(List<StratigraphicInterval> intervals) {
        this.intervals = intervals;
    }

    private boolean isValid() {
        if (this.unitService == null) {
            return false;
        }
        return this.intervals != null && !this.intervals.isEmpty();
    }

    public Optional<DepthAgeCurve> deriveCurve() {
        if (!this.isValid()) {
            LOGGER.warning("DepthAgeGenerator is not valid - could not derive curve");
            return Optional.empty();
        }
        record Node(double depth, double age) {
        }
        LinkedList<Node> nodeList = new LinkedList<Node>();
        for (StratigraphicInterval zone : this.intervals) {
            StratigraphicUnit uppUnit = this.unitService.findUnit(zone.getSchID(), zone.getUppZone()).orElse(null);
            if (uppUnit == null || !uppUnit.hasAges() || !(Math.abs(uppUnit.getuAge() - uppUnit.getlAge()) > 0.0)) continue;
            StratigraphicUnit lowUnit = this.unitService.findUnit(zone.getSchID(), zone.getLowZone()).orElse(uppUnit);
            if (!(Math.abs(lowUnit.getuAge() - lowUnit.getlAge()) > 0.0)) {
                lowUnit = uppUnit;
            }
            nodeList.add(new Node(zone.getTopDepth(), uppUnit.getuAge()));
            nodeList.add(new Node(zone.getBaseDepth(), lowUnit.getlAge()));
        }
        if (nodeList.isEmpty()) {
            return Optional.empty();
        }
        DepthAgeCurve depthAgeCurve = new DepthAgeCurve();
        for (Node node : nodeList) {
            try {
                depthAgeCurve.addNode(node.depth, node.age, Boundary.CONF.getBndInt(), false);
            }
            catch (DuplicateNodeException duplicateNodeException) {}
        }
        depthAgeCurve.validateBoundaries();
        return Optional.of(depthAgeCurve);
    }
}

