/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtils {
    public static DateTimeFormatter DISPLAY_FORMAT;
    public static DateTimeFormatter DISPLAY_FORMAT_UK;
    public static DateTimeFormatter DB_DATE_FORMAT;
    public static DateTimeFormatter DB_DATETIME_FORMAT;
    private static final List<Integer> NON_BUSINESS_DAYS;

    public static Date asDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date businessDaysFrom(Date date, int businessDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int i = 0;
        while (i < Math.abs(businessDays)) {
            calendar.add(5, businessDays > 0 ? 1 : -1);
            if (NON_BUSINESS_DAYS.contains(calendar.get(7))) continue;
            ++i;
        }
        return calendar.getTime();
    }

    static {
        DB_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DB_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        NON_BUSINESS_DAYS = Arrays.asList(7, 1);
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.parseCaseInsensitive();
        builder.appendPattern("dd-MMM-yyyy");
        DISPLAY_FORMAT = builder.toFormatter();
        DISPLAY_FORMAT_UK = builder.toFormatter(Locale.UK);
    }
}

