/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.depth;

import com.stratadata.model3.well.SectionType;
import com.stratadata.util.depth.DepthUnits;

public class DepthUtils {
    private static final double DEPTH_TOLERANCE = 0.003048;
    public static final double FT_PER_M = 0.3048;

    private DepthUtils() {
    }

    public static boolean equalWithinTolerance(double d1, double d2) {
        double diff = Math.abs(d2 - d1);
        return diff < 0.006096;
    }

    public static boolean gtOrEqWithinTolerance(double depth, double comp) {
        if (DepthUtils.equalWithinTolerance(depth, comp)) {
            return true;
        }
        return depth > comp;
    }

    public static boolean ltOrEqWithinTolerance(double depth, double comp) {
        if (DepthUtils.equalWithinTolerance(depth, comp)) {
            return true;
        }
        return depth < comp;
    }

    public static double convToM(double value, DepthUnits units) {
        if (units == DepthUnits.F) {
            value *= 0.3048;
        }
        if (units != null) {
            value = (double)Math.round(value * 1000.0) / 1000.0;
        }
        return value;
    }

    public static float convToM(float value, DepthUnits units) {
        if (units == DepthUnits.F) {
            value *= 0.3048f;
        }
        if (units != null) {
            value = (float)Math.round(value * 1000.0f) / 1000.0f;
        }
        return value;
    }

    public static double convToM(double value, DepthUnits units, SectionType type) {
        value = DepthUtils.convToM(value, units);
        return value * (double)DepthUtils.getSectionTypeConversion(type);
    }

    public static double convToM(float value, DepthUnits units, SectionType type) {
        value = DepthUtils.convToM(value, units);
        return value * (float)DepthUtils.getSectionTypeConversion(type);
    }

    private static int getSectionTypeConversion(SectionType sectionType) {
        return switch (sectionType) {
            case SectionType.OUTCROP -> -1;
            default -> 1;
        };
    }

    public static double convFromM(double value, DepthUnits units) {
        if (units == DepthUnits.F) {
            value /= (double)0.3048f;
            value = (double)Math.round(value * 100.0) / 100.0;
        }
        return value;
    }

    public static float convFromM(float value, DepthUnits units) {
        if (units == DepthUnits.F) {
            value /= 0.3048f;
            value = (float)Math.round(value * 100.0f) / 100.0f;
        }
        return value;
    }

    public static double convFromM(double value, DepthUnits units, SectionType type) {
        if (Math.abs(value = DepthUtils.convFromM(value, units)) > 0.0) {
            value *= (double)DepthUtils.getSectionTypeConversion(type);
        }
        return value;
    }

    public static float convFromM(float value, DepthUnits units, SectionType type) {
        if (Math.abs(value = DepthUtils.convFromM(value, units)) > 0.0f) {
            value *= (float)DepthUtils.getSectionTypeConversion(type);
        }
        return value;
    }

    public static String depthString(float value, int dp) {
        String s;
        double div = Math.pow(10.0, dp);
        value = (float)((double)Math.round((double)value * div) / div);
        if (dp > 0) {
            ++dp;
        }
        if ((s = Float.toString(value)).contains("E")) {
            return s;
        }
        return DepthUtils.depthString(s, dp);
    }

    public static String depthString(double value, int dp) {
        String s;
        double div = Math.pow(10.0, dp);
        value = (double)Math.round(value * div) / div;
        if (dp > 0) {
            ++dp;
        }
        if ((s = Double.toString(value)).contains("E")) {
            return s;
        }
        return DepthUtils.depthString(s, dp);
    }

    public static String depthString(double value, DepthUnits units, int precision, SectionType type) {
        return DepthUtils.depthString(value, units, precision, type, true);
    }

    public static String depthString(double value, DepthUnits units, int precision, SectionType type, boolean withSymbol) {
        return DepthUtils.depthString(DepthUtils.convFromM(value, units, type), precision) + (withSymbol ? units.getSymbol() : "");
    }

    private static String depthString(String s, int dp) {
        s = (String)s + "0000000";
        s = ((String)s).substring(0, ((String)s).indexOf(46) + dp);
        int leftPad = 4;
        if (((String)s).indexOf(46) > 0) {
            while (((String)s).indexOf(46) < leftPad) {
                s = " " + (String)s;
            }
        } else {
            while (((String)s).length() < leftPad) {
                s = " " + (String)s;
            }
        }
        return s;
    }
}

