/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.process;

import com.stratadata.util.process.ProcessMessage;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMultiStageProcess<T extends Enum<?>> {
    private final Map<T, ProcessMessage> messageMap = new HashMap<T, ProcessMessage>();
    private ProcessResult result;

    public void go() {
        if (this.result != null) {
            throw new IllegalStateException("Process has ended");
        }
        if (this.hasBeenCancelled()) {
            this.result = new ProcessResult(ResultType.FAIL, "Cancelled");
            return;
        }
        try {
            if (this.getCurrentMessage() != null) {
                throw new IllegalStateException("Process is waiting for response: " + this.getCurrentMessage().message);
            }
            this.process();
        }
        catch (RuntimeException e) {
            this.result = new ProcessResult(ResultType.FAIL, e.getMessage());
            throw e;
        }
    }

    protected abstract void process();

    protected void addProcessMessage(T type, String message, String title) {
        this.messageMap.put(type, new ProcessMessage(message, title));
    }

    public boolean isReady() {
        return this.result == null;
    }

    public ProcessMessage getCurrentMessage() {
        return this.messageMap.values().stream().filter(m -> m.getResponse() == null).findFirst().orElse(null);
    }

    public abstract T getCurrentStep();

    private boolean hasBeenCancelled() {
        return this.messageMap.values().stream().anyMatch(m -> m.getResponse() == ProcessMessage.Response.CANCEL);
    }

    public ProcessMessage.Response getResponse(T messageType) {
        ProcessMessage message = this.messageMap.get(messageType);
        if (message != null) {
            return message.getResponse();
        }
        return null;
    }

    public void setResponse(ProcessMessage.Response response) {
        ProcessMessage message = this.getCurrentMessage();
        if (message == null) {
            throw new IllegalStateException("Can't set response when there is no current message");
        }
        message.setResponse(response);
        if (response == ProcessMessage.Response.CANCEL) {
            this.result = new ProcessResult(ResultType.FAIL, "Process cancelled");
        }
    }

    public void setResponse(T messageType, ProcessMessage.Response response) {
        ProcessMessage message = this.messageMap.get(messageType);
        if (message == null) {
            message = new ProcessMessage("", "");
            this.messageMap.put(messageType, message);
        }
        message.setResponse(response);
    }

    protected void setResult(ProcessResult result) {
        this.result = result;
    }

    public ProcessResult getResult() {
        return this.result;
    }

    public boolean succeeded() {
        return this.result != null && this.result.result() == ResultType.SUCCESS;
    }

    public record ProcessResult(ResultType result, String resultMessage) {
    }

    public static enum ResultType {
        SUCCESS,
        FAIL;

    }
}

