/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.SBTables;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sbconvert.CopySource;
import com.stratadata.sbconvert.JPanelConnection;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import model3.SBdb;
import util.SBException;
import util.exception.SqlCache;

public class DialogCopyConvertDatabase
extends JDialog {
    private static final String[] titles = new String[]{"Table", "Source Rows", "Target Rows", "Select"};
    private static final int COL_TABLENAME = 0;
    private static final int COL_SOURCEROW = 1;
    private static final int COL_TARGETROWS = 2;
    private static final int COL_SELECT = 3;
    private static final int[] widths = new int[]{50, 30, 30, 20};
    private final List<TableCopy> tables = new LinkedList<TableCopy>();
    private static final Logger LOGGER = Logger.getLogger(DialogCopyConvertDatabase.class.getName());
    private final TableModelCopyDatabase model = new TableModelCopyDatabase(this);
    private final ConnectionParameters sourceParams;
    private final ConnectionParameters targetParams;
    private final CopySource sourceDB;
    private final SBdb targetDB;
    private boolean sameInstance = false;
    private TableCopyTask currentCopyTask;
    private DefaultComboBoxModel copyLevel = new DefaultComboBoxModel();
    private JButton jButtonCancelTask;
    private JButton jButtonClearAll;
    private JButton jButtonClose;
    private JButton jButtonCopy;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectMin;
    private JComboBox<String> jComboBoxPreSelect;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanelConnection jPanelConnectionSource;
    private JPanelConnection jPanelConnectionTarget;
    private JProgressBar jProgressBarCopy;
    private JScrollPane jScrollPane1;
    private JTable jTableCopyDB;
    private JTextField jTextFieldBatchSize;

    public DialogCopyConvertDatabase(Frame parent, boolean modal, ConnectionParameters sourceParms, CopySource sourceDB, ConnectionParameters targetParms, SBdb targetDB) throws SQLException {
        super(parent, modal);
        this.sourceParams = sourceParms;
        this.targetParams = targetParms;
        this.sourceDB = sourceDB;
        this.targetDB = targetDB;
        this.initComponents();
        this.init(sourceParms, targetParms);
    }

    private void init(ConnectionParameters sourceParms, ConnectionParameters targetParms) throws SQLException {
        this.setTitle("StrataBugs Database Copy");
        ((TitledBorder)this.jPanelConnectionSource.getBorder()).setTitle("Source Connection (" + String.valueOf((Object)sourceParms.getModelVersion()) + "):");
        this.jPanelConnectionSource.updateFields(this.sourceDB.getSchema(), this.sourceDB.getDBTypeName(), "");
        ((TitledBorder)this.jPanelConnectionTarget.getBorder()).setTitle("Target Connection (" + String.valueOf((Object)targetParms.getModelVersion()) + "):");
        this.jPanelConnectionTarget.updateFields(this.targetDB.getSchema(), this.targetDB.getDBType().getName(), "");
        this.model.setupTable(this.jTableCopyDB);
        this.jButtonSelectMin.setVisible(false);
        this.copyLevel.addElement("<Table pre-select>");
        for (SBTables.CopyLevel l : SBTables.CopyLevel.values()) {
            this.copyLevel.addElement(l);
        }
        try (Statement sourceStmt = this.sourceDB.createStatement();
             Statement targetStmt = this.targetDB.getDatabase().createStatement();){
            for (String tableName : SBTables.tableList()) {
                TableCopy t = new TableCopy(tableName);
                String tableCopyQuery = SBTables.getSelectQuery(this.sourceDB.getDBTypeName(), this.sourceDB.getModelVersion(), this.sourceDB.getSchema(), tableName).orElse(null);
                try {
                    t.sourceRows = this.sourceDB.getTableRowCount(sourceStmt, t.getTableName(this.sourceDB.getDBTypeName()), tableCopyQuery);
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.WARNING, "Error from source table row query: {0}\nSQL:{1}", new Object[]{ex.toString(), SqlCache.getSql()});
                }
                try {
                    t.targetRows = this.targetDB.getTableRowCount(targetStmt, t.getTableName(this.targetDB.getDBType()));
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.WARNING, "Error from target table row query: {0}\nSQL: {1}", new Object[]{ex.toString(), SqlCache.getSql()});
                }
                t.select = t.sourceRows != null && t.sourceRows > 0 && t.targetRows != null && t.targetRows == 0;
                this.tables.add(t);
            }
        }
        this.model.fireTableDataChanged();
        this.sameInstance = this.getSameInstance(sourceParms, targetParms);
    }

    private boolean getSameInstance(ConnectionParameters sourceParms, ConnectionParameters targetParms) {
        if (!sourceParms.getDriverName().equalsIgnoreCase(targetParms.getDriverName()) || !sourceParms.getHostName().equalsIgnoreCase(targetParms.getHostName())) {
            return false;
        }
        return !(sourceParms.getInstanceName().contains(".") && targetParms.getInstanceName().contains(".") ? !sourceParms.getInstanceName().substring(0, sourceParms.getInstanceName().indexOf(46)).equals(targetParms.getInstanceName().substring(0, targetParms.getInstanceName().indexOf(46))) : !sourceParms.getInstanceName().equalsIgnoreCase(targetParms.getInstanceName()));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCopyDB = new JTable();
        this.jButtonSelectAll = new JButton();
        this.jButtonClearAll = new JButton();
        this.jButtonCopy = new JButton();
        this.jProgressBarCopy = new JProgressBar();
        this.jButtonClose = new JButton();
        this.jButtonCancelTask = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanelConnectionTarget = new JPanelConnection(this.targetParams);
        this.jPanelConnectionSource = new JPanelConnection(this.sourceParams);
        this.jButtonSelectMin = new JButton();
        this.jComboBoxPreSelect = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldBatchSize = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 600));
        this.jTableCopyDB.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCopyDB);
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonClearAll.setText("Clear all");
        this.jButtonClearAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearAllActionPerformed(evt);
            }
        });
        this.jButtonCopy.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonCopy.setText("Copy");
        this.jButtonCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonCancelTask.setText("Cancel");
        this.jButtonCancelTask.setEnabled(false);
        this.jButtonCancelTask.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelTaskActionPerformed(evt);
            }
        });
        this.jPanelConnectionTarget.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "Target Connection", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanelConnectionSource.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "Source Connection", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelConnectionTarget, GroupLayout.Alignment.TRAILING, -1, 557, Short.MAX_VALUE).addComponent(this.jPanelConnectionSource, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelConnectionTarget, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelConnectionSource, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonSelectMin.setText("Select min");
        this.jButtonSelectMin.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectMinActionPerformed(evt);
            }
        });
        this.jComboBoxPreSelect.setModel(this.copyLevel);
        this.jComboBoxPreSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCopyConvertDatabase this$0;
            {
                DialogCopyConvertDatabase dialogCopyConvertDatabase = this$0;
                Objects.requireNonNull(dialogCopyConvertDatabase);
                this.this$0 = dialogCopyConvertDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxPreSelectActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Size of batch (rows):");
        this.jTextFieldBatchSize.setHorizontalAlignment(11);
        this.jTextFieldBatchSize.setText("50000");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClearAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxPreSelect, 0, -1, Short.MAX_VALUE)).addComponent(this.jButtonSelectAll, GroupLayout.Alignment.LEADING, -1, 119, Short.MAX_VALUE)).addComponent(this.jLabel1).addComponent(this.jTextFieldBatchSize)).addComponent(this.jButtonSelectMin, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCopy, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancelTask, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBarCopy, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancelTask, this.jButtonClearAll, this.jButtonClose, this.jButtonCopy, this.jButtonSelectAll, this.jButtonSelectMin, this.jComboBoxPreSelect, this.jProgressBarCopy);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxPreSelect, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldBatchSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBarCopy, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancelTask).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSelectMin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 427, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.tables.forEach(t -> {
            t.select = true;
        });
        this.model.fireTableDataChanged();
    }

    private void jButtonClearAllActionPerformed(ActionEvent evt) {
        this.tables.forEach(t -> {
            t.select = false;
        });
        this.model.fireTableDataChanged();
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        int nToCopy = (int)this.tables.stream().filter(t -> t.select).count();
        if (nToCopy == 0) {
            JOptionPane.showMessageDialog(this, "Please select some tables to copy", "No Tables Selected", 1);
            return;
        }
        String batchSizeString = this.jTextFieldBatchSize.getText().trim();
        try {
            int batchSize = Integer.valueOf(batchSizeString);
            if (batchSize < 10 || batchSize > 10000000) {
                JOptionPane.showMessageDialog(this, "Enter a batch size between: 10 and 10000000", this.getTitle(), 2);
                return;
            }
            this.jProgressBarCopy.setValue(0);
            this.jButtonCancelTask.setEnabled(true);
            this.jButtonCopy.setEnabled(false);
            this.currentCopyTask = new TableCopyTask(this);
            this.currentCopyTask.setBatchSize(batchSize);
            this.currentCopyTask.addPropertyChangeListener(pEvt -> {
                if ("progress".equals(pEvt.getPropertyName())) {
                    int progress = (Integer)pEvt.getNewValue();
                    this.jProgressBarCopy.setValue(progress);
                }
            });
            this.currentCopyTask.execute();
        }
        catch (NumberFormatException ne) {
            JOptionPane.showMessageDialog(this, "Can't read batch size, enter a valid number", this.getTitle(), 2);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonCancelTaskActionPerformed(ActionEvent evt) {
        if (this.currentCopyTask != null) {
            this.currentCopyTask.cancel(false);
        }
    }

    private void jButtonSelectMinActionPerformed(ActionEvent evt) {
        block17: for (TableCopy t : this.tables) {
            switch (t.getTableName("")) {
                default: {
                    t.select = false;
                    continue block17;
                }
                case "USERDEF": 
                case "CASDIAM": 
                case "DISCS": 
                case "CATEGORY": 
                case "SMPTYPES": 
                case "IGD_DEF": 
                case "LITHDESC": 
                case "SBLTHSCH": 
                case "SBLTHMBR": 
                case "SBLTHPAT": 
                case "SPECIESTYPE": 
                case "DBVERSION": 
            }
            t.select = true;
        }
        this.model.fireTableDataChanged();
    }

    private void jComboBoxPreSelectActionPerformed(ActionEvent evt) {
        Object o = this.jComboBoxPreSelect.getSelectedItem();
        if (!(o instanceof SBTables.CopyLevel)) {
            this.jComboBoxPreSelect.setToolTipText("Pre-select a set of tables to customise copied database");
            return;
        }
        SBTables.CopyLevel l = (SBTables.CopyLevel)((Object)o);
        int i = 0;
        List<Boolean> selectList = SBTables.selectList(l);
        for (Boolean select : selectList) {
            TableCopy tc = this.tables.get(i++);
            if (tc.targetRows != 0) continue;
            tc.select = select;
        }
        this.jComboBoxPreSelect.setToolTipText(l.getDescr());
        this.model.fireTableDataChanged();
    }

    private class TableModelCopyDatabase
    extends AbstractTableModel {
        final /* synthetic */ DialogCopyConvertDatabase this$0;

        private TableModelCopyDatabase(DialogCopyConvertDatabase dialogCopyConvertDatabase) {
            DialogCopyConvertDatabase dialogCopyConvertDatabase2 = dialogCopyConvertDatabase;
            Objects.requireNonNull(dialogCopyConvertDatabase2);
            this.this$0 = dialogCopyConvertDatabase2;
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.tables == null) {
                return 0;
            }
            return this.this$0.tables.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            TableCopy table = this.this$0.tables.get(row);
            switch (col) {
                case 0: {
                    return table.tableName;
                }
                case 1: {
                    if (table.sourceRows != null && table.sourceRows >= 0) {
                        return "" + table.sourceRows;
                    }
                    return "Not found";
                }
                case 2: {
                    if (table.targetRows != null) {
                        if (table.targetRows < 0) {
                            if (table.targetRows == -1) {
                                return "Copying...";
                            }
                            if (table.targetRows == -2) {
                                return "Error";
                            }
                        }
                        return "" + table.targetRows;
                    }
                    return "Not found";
                }
                case 3: {
                    return table.select;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 3;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            TableCopy table = this.this$0.tables.get(row);
            switch (col) {
                default: {
                    break;
                }
                case 3: {
                    table.select = (Boolean)obj;
                }
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        void setupTable(JTable table) {
            TableUtils.setTableHeaderBold(table);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                table.getColumnModel().getColumn(i).setHeaderValue(titles[i]);
                table.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    private static class TableCopy {
        static final int STATUS_COPYING = -1;
        static final int STATUS_ERROR = -2;
        final String tableName;
        Integer sourceRows;
        Integer targetRows;
        boolean select;

        TableCopy(String tableName) {
            this.tableName = tableName;
        }

        String getTableName(String dbTypeName) {
            if (dbTypeName.contains("Postgre")) {
                return this.tableName.toLowerCase();
            }
            return this.tableName;
        }

        String getTableName(DBType dbType) {
            if (dbType.equals((Object)DBType.POSTGRESQL)) {
                return this.tableName.toLowerCase();
            }
            return this.tableName;
        }

        boolean hasTargetRows() {
            return this.targetRows != null && this.targetRows > 0;
        }
    }

    private class TableCopyTask
    extends SwingWorker<Void, TableCopy> {
        private final Logger logger;
        private int BATCH_SIZE;
        public static final int BATCH_MIN = 10;
        public static final int BATCH_MAX = 10000000;
        private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
        final /* synthetic */ DialogCopyConvertDatabase this$0;

        private TableCopyTask(DialogCopyConvertDatabase dialogCopyConvertDatabase) {
            DialogCopyConvertDatabase dialogCopyConvertDatabase2 = dialogCopyConvertDatabase;
            Objects.requireNonNull(dialogCopyConvertDatabase2);
            this.this$0 = dialogCopyConvertDatabase2;
            this.logger = Logger.getLogger(TableCopyTask.class.getName());
            this.BATCH_SIZE = 50000;
        }

        @Override
        public void done() {
            try {
                this.get();
                if (this.getProgress() == 100) {
                    JOptionPane.showMessageDialog(this.this$0, "Copy complete", this.this$0.getTitle(), 1);
                } else if (this.getProgress() == 0) {
                    JOptionPane.showMessageDialog(this.this$0, "No data copied", this.this$0.getTitle(), 1);
                } else {
                    this.logger.log(Level.INFO, "Finished task, progress {0}%", this.getProgress());
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.this$0, "Error copying: " + ex.toString(), "Error Copying Data", 0);
            }
            catch (CancellationException ce) {
                this.logger.log(Level.INFO, "The task was cancelled. Progress: {0}%", this.getProgress());
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            finally {
                this.this$0.setCursor(Cursor.getDefaultCursor());
                this.this$0.jButtonCopy.setEnabled(true);
                this.this$0.jButtonCancelTask.setEnabled(false);
            }
        }

        @Override
        protected void process(List<TableCopy> chunks) {
            this.this$0.jScrollPane1.scrollRectToVisible(this.this$0.jTableCopyDB.getCellRect(this.this$0.tables.indexOf(chunks.get(chunks.size() - 1)), 0, false));
            this.this$0.model.fireTableDataChanged();
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.this$0.setCursor(Cursor.getPredefinedCursor(3));
            int nTablesToCopy = (int)this.this$0.tables.stream().filter(t -> t.select).count();
            int tablesCopied = 0;
            try (Statement stmt = this.this$0.targetDB.getDatabase().createStatement();){
                for (TableCopy table : this.this$0.tables) {
                    if (this.isCancelled()) {
                        break;
                    }
                    if (this.isCancelled()) {
                        Void void_ = null;
                        return void_;
                    }
                    if (!table.select) continue;
                    boolean clearValues = false;
                    if (table.hasTargetRows()) {
                        int opt = JOptionPane.showConfirmDialog(this.this$0, "Clear values from table: " + table.tableName + "?", "Table Copy", 1, 3);
                        if (opt == 2) {
                            Void void_ = null;
                            return void_;
                        }
                        if (opt == 0) {
                            clearValues = true;
                        }
                    }
                    table.targetRows = -1;
                    this.publish(table);
                    try {
                        this.this$0.jTableCopyDB.scrollRectToVisible(this.this$0.jTableCopyDB.getCellRect(this.this$0.tables.indexOf(table), 0, true));
                        this.doCopyTable(table, clearValues, this.BATCH_SIZE);
                    }
                    catch (SQLException | ParseException e) {
                        table.targetRows = -2;
                        this.publish(table);
                        this.this$0.targetDB.doRollback();
                        throw e;
                    }
                    table.select = false;
                    table.targetRows = this.this$0.targetDB.getTableRowCount(stmt, table.tableName);
                    this.publish(table);
                    this.setProgress(this.getProgress(++tablesCopied, nTablesToCopy));
                }
            }
            this.setProgress(100);
            return null;
        }

        void setBatchSize(int size) {
            if (size > 0 && size < 10000000) {
                this.BATCH_SIZE = size;
            }
        }

        private int getProgress(double tablesCopied, double tablesToCopy) {
            double percent = tablesCopied / tablesToCopy * 100.0;
            return (int)Math.floor(percent);
        }

        private void doCopyTable(TableCopy t, boolean clearValues, int BATCH_SIZE) throws SQLException, ParseException, SBException {
            if (t.tableName.equalsIgnoreCase("IGD_SCH")) {
                this.copyTable(t.tableName, " WHERE igd_type=3", clearValues, BATCH_SIZE);
                this.copyTable(t.tableName, " WHERE igd_type=10", false, BATCH_SIZE);
                this.copyTable(t.tableName, " WHERE igd_type<>3 AND igd_type<>10", false, BATCH_SIZE);
            } else if (t.tableName.equalsIgnoreCase("CHTBLOCK")) {
                this.copyTable(t.tableName, " WHERE parent_id is null", clearValues, BATCH_SIZE);
                this.copyTable(t.tableName, " WHERE parent_id is not null", false, BATCH_SIZE);
            } else {
                this.copyTable(t.tableName, null, clearValues, BATCH_SIZE);
            }
            this.this$0.targetDB.commit();
        }

        /*
         * Unable to fully structure code
         */
        private void copyTable(String tableName, String whereClause, boolean clearValues, int BATCH_SIZE) throws SQLException, ParseException, SBException {
            targetStmt = this.this$0.targetDB.getDatabase().createStatement();
            try {
                sourceStmt = this.this$0.sourceDB.createStatement();
                try {
                    block45: {
                        block47: {
                            if (clearValues) {
                                this.logger.log(Level.INFO, "Deleting from table: {0}", this.this$0.targetDB.DBTableName(tableName));
                                targetStmt.executeUpdate("DELETE FROM " + this.this$0.targetDB.DBTableName(tableName));
                            }
                            targetSelectQuery = "SELECT * FROM " + this.this$0.targetDB.DBTableName(tableName);
                            rsTargetSelect = targetStmt.executeQuery(targetSelectQuery);
                            targetMeta = rsTargetSelect.getMetaData();
                            targetColNames = new LinkedList<String>();
                            nTargetCols = targetMeta.getColumnCount();
                            for (i = 1; i <= nTargetCols; ++i) {
                                columnName = targetMeta.getColumnName(i);
                                if (columnName.equalsIgnoreCase("PLAN") && this.this$0.sourceDB.isSQLServer()) {
                                    columnName = "[" + (String)columnName + "]";
                                }
                                targetColNames.add((String)columnName);
                            }
                            selectQuery = SBTables.getSelectQuery(this.this$0.sourceDB.getDBTypeName(), this.this$0.sourceDB.getModelVersion(), this.this$0.sourceDB.getTablePrefix(), tableName).orElse("SELECT " + String.join((CharSequence)",", targetColNames) + " FROM " + this.this$0.sourceDB.DBTableName(tableName));
                            if (whereClause != null) {
                                selectQuery = (String)selectQuery + whereClause;
                            }
                            if (!this.this$0.sameInstance) break block47;
                            insertSql = "INSERT INTO " + this.this$0.targetDB.DBTableName(tableName) + " (" + String.join((CharSequence)",", targetColNames) + ") " + (String)selectQuery;
                            this.logger.log(Level.INFO, "Executing: {0}", insertSql);
                            nRows = targetStmt.executeUpdate(insertSql);
                            this.logger.log(Level.INFO, "Updated table: {0} with {1} rows.", new Object[]{tableName, nRows});
                            break block45;
                        }
                        this.logger.log(Level.INFO, "Executing query in copyTable: {0}", selectQuery);
                        selectionResults = sourceStmt.executeQuery((String)selectQuery);
                        copyFromMeta = selectionResults.getMetaData();
                        if (nTargetCols != copyFromMeta.getColumnCount()) {
                            throw new IllegalStateException("No. of columns in select query from source database, and target table don't match: " + nTargetCols + " vs. " + selectionResults.getMetaData().getColumnCount());
                        }
                        insertSql = "INSERT INTO " + this.this$0.targetDB.DBTableName(tableName) + " (" + String.join((CharSequence)",", targetColNames) + ") VALUES (" + String.join((CharSequence)",", Collections.nCopies(nTargetCols, "?")) + ")";
                        pStmt = this.this$0.targetDB.getDatabase().prepareStatement(insertSql);
                        try {
                            nRows = 0;
                            nBatch = 0;
                            while (selectionResults.next()) {
                                paramString = "";
                                if (this.this$0.targetDB.getDBType() != DBType.ORACLE) {
                                    pStmt.clearParameters();
                                }
                                block24: for (col = 1; col <= nTargetCols; ++col) {
                                    switch (copyFromMeta.getColumnType(col)) {
                                        case 2004: {
                                            pStmt.setBytes(col, selectionResults.getBytes(col));
                                            paramString = (String)paramString + "BLOB as GetBytes,";
                                            continue block24;
                                        }
                                        case 2005: {
                                            pStmt.setCharacterStream(col, selectionResults.getCharacterStream(col));
                                            paramString = (String)paramString + "CLOB,";
                                            continue block24;
                                        }
                                        case 2: {
                                            if (targetMeta.getColumnType(col) == -7 || targetMeta.getColumnType(col) == 16) {
                                                i = 0;
                                                if (selectionResults.getObject(col) != null) {
                                                    i = Integer.valueOf(selectionResults.getObject(col).toString());
                                                }
                                                pStmt.setBoolean(col, i > 0);
                                                continue block24;
                                            }
                                        }
                                        default: {
                                            obj = selectionResults.getObject(col);
                                            if (obj == null) ** GOTO lbl92
                                            if (this.this$0.targetDB.getDBType() == DBType.SQLITE && obj instanceof Float) {
                                                obj = (double)((Float)obj).floatValue();
                                            }
                                            if (!targetMeta.getColumnName(col).equalsIgnoreCase("CREATOR") && !targetMeta.getColumnName(col).equalsIgnoreCase("MODIFIER") && !targetMeta.getColumnName(col).equalsIgnoreCase("UPDATER")) ** GOTO lbl78
                                            try {
                                                usrID = Integer.parseInt(obj.toString());
                                                if (usrID <= 0 || !this.this$0.sourceDB.hasUser(usrID)) ** GOTO lbl73
                                                pStmt.setObject(col, obj);
                                                ** GOTO lbl93
lbl73:
                                                // 1 sources

                                                pStmt.setNull(col, targetMeta.getColumnType(col));
                                            }
                                            catch (NumberFormatException ex) {
                                                pStmt.setNull(col, targetMeta.getColumnType(col));
                                            }
                                            ** GOTO lbl93
lbl78:
                                            // 1 sources

                                            if (obj.getClass().getName().equals("oracle.sql.TIMESTAMP")) {
                                                d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(obj.toString());
                                                o = new Timestamp(d.getTime());
                                                pStmt.setObject(col, o);
                                            } else if (copyFromMeta.getColumnType(col) == 2) {
                                                if (obj.toString().length() > 40) {
                                                    this.logger.log(Level.INFO, "Truncating object: {0} in param string: {1}", new Object[]{obj, paramString});
                                                    pStmt.setObject(col, obj.toString().substring(0, 40));
                                                } else {
                                                    pStmt.setObject(col, obj);
                                                }
                                            } else {
                                                pStmt.setObject(col, obj);
                                            }
                                            ** GOTO lbl93
lbl92:
                                            // 1 sources

                                            pStmt.setNull(col, targetMeta.getColumnType(col));
lbl93:
                                            // 8 sources

                                            paramString = (String)paramString + String.valueOf(obj) + ",";
                                        }
                                    }
                                }
                                pStmt.addBatch();
                                if (++nRows % (Math.max(BATCH_SIZE, 50) / 50) == 0) {
                                    this.logger.info(String.format("Added %,d rows", new Object[]{nRows}));
                                }
                                if (nRows % BATCH_SIZE != 0) continue;
                                this.logger.log(Level.INFO, "Executing & committing batch # {0} ...", ++nBatch);
                                this.executeBatch(pStmt);
                                this.this$0.targetDB.commit();
                            }
                            this.logger.log(Level.INFO, "Executing & committing batch # {0}", ++nBatch);
                            this.executeBatch(pStmt);
                        }
                        finally {
                            if (pStmt != null) {
                                pStmt.close();
                            }
                        }
                    }
                    additionalDML = SBTables.getAdditionalDML(this.this$0.sourceDB.getModelVersion(), this.this$0.sourceDB.getTablePrefix(), this.this$0.targetDB.getTablePrefix(), tableName).orElse(null);
                    if (additionalDML != null) {
                        this.logger.log(Level.INFO, "Executing additional statements for: {0}", this.this$0.targetDB.DBTableName(tableName));
                        for (String stmt : sqlStmts = additionalDML.split(";")) {
                            this.logger.log(Level.INFO, "Executing: {0}", stmt);
                            targetStmt.executeUpdate(stmt);
                        }
                    }
                }
                finally {
                    if (sourceStmt != null) {
                        sourceStmt.close();
                    }
                }
            }
            finally {
                if (targetStmt != null) {
                    targetStmt.close();
                }
            }
            this.this$0.targetDB.commit();
        }

        private void executeBatch(PreparedStatement pStmt) throws SQLException {
            int[] affectedRows;
            try {
                affectedRows = pStmt.executeBatch();
            }
            catch (BatchUpdateException ex) {
                affectedRows = ex.getUpdateCounts();
                String msg = ex.getMessage().toUpperCase();
                if (!msg.contains("TXLOAD") && !msg.contains("SBQLITH")) {
                    throw ex;
                }
                LOGGER.log(Level.INFO, ex.getMessage());
            }
            int nInserted = 0;
            int nError = 0;
            int nNoInfo = 0;
            for (int row : affectedRows) {
                if (row > 0) {
                    ++nInserted;
                    continue;
                }
                if (row == -3) {
                    ++nError;
                    continue;
                }
                ++nNoInfo;
            }
            this.logger.log(Level.INFO, "Number of rows affected: {0}, Inserted: {1}, Error: {2}, No Info: {3}", new Object[]{affectedRows.length, nInserted, nError, nNoInfo});
        }
    }
}

