/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import com.stratadata.model3.db.BasicConnectionFactory;
import com.stratadata.model3.db.ConnectionDetails;
import com.stratadata.model3.db.ConnectionDetailsHelper;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.ModelVersion;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sbconnect.DialogConnection;
import com.stratadata.sbconvert.CopySource;
import com.stratadata.sbconvert.DialogCopyConvertDatabase;
import com.stratadata.sbconvert.DialogDownloadDB;
import com.stratadata.sbconvert.DialogSelectDbType;
import com.stratadata.sbconvert.JPanelConnection;
import com.stratadata.sbconvert.SbugsScriptUtilities;
import com.stratadata.util.script.DialogSQLResults;
import com.stratadata.util.script.QueryResult;
import com.stratadata.util.script.ScriptRunner;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.SwingTextFieldUtils;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import model2_1.SBdb;

public class FrameConv
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(FrameConv.class.getName());
    private final ComboBoxModel<Action> comboModel = new DefaultComboBoxModel<Action>(Action.values());
    private boolean allowUnrestrictedQueries;
    private final boolean allowUnrestrictedQueriesInit;
    private model3.SBdb targetDB;
    private ButtonGroup buttonGroupSourceVersion;
    private JButton jButtonClose;
    private JButton jButtonStartAction;
    private JCheckBox jCheckBoxActionCreateFKs;
    private JCheckBox jCheckBoxActionCreateWriteToFile;
    private JCheckBox jCheckBoxActionDeleteCascade;
    private JCheckBox jCheckBoxActionDeleteIfExists;
    private JCheckBox jCheckBoxActionDeleteWriteToFile;
    private JCheckBox jCheckBoxActionGrantWriteToFile;
    private JComboBox<Action> jComboBoxAction;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelOutput;
    private JPanel jPanel1;
    private JPanel jPanelActionCopy;
    private JPanel jPanelActionCreate;
    private JPanel jPanelActionDelete;
    private JPanel jPanelActionGrant;
    private JPanel jPanelActionNull;
    private JPanel jPanelActionOptions;
    private JPanel jPanelActionScript;
    private JPanelConnection jPanelConnection3;
    private JPanelConnection jPanelConnectionSource;
    private JRadioButton jRadioButtonSourceVersion2;
    private JRadioButton jRadioButtonSourceVersion3;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextAreaOutput;
    private JTextField jTextFieldActionGrantGrantee;
    private JTextField jTextFieldQueryTimeout;
    private JTextPane jTextPaneSQL;

    public FrameConv(boolean allowUnrestrictedQueries) {
        this.allowUnrestrictedQueriesInit = this.allowUnrestrictedQueries = allowUnrestrictedQueries;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("StrataBugs Database Utility");
        this.setLocationRelativeTo(null);
        this.getRootPane().setDefaultButton(this.jButtonStartAction);
        this.jComboBoxAction.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.actionSelected();
            }
        });
        this.jPanelActionOptions.add(Action.NULL.name(), this.jPanelActionNull);
        this.jPanelActionOptions.add(Action.CREATE.name(), this.jPanelActionCreate);
        this.jPanelActionOptions.add(Action.GRANT.name(), this.jPanelActionGrant);
        this.jPanelActionOptions.add(Action.DROP.name(), this.jPanelActionDelete);
        this.jPanelActionOptions.add(Action.COPY.name(), this.jPanelActionCopy);
        this.jPanelActionOptions.add(Action.DEMO.name(), this.jPanelActionNull);
        this.jPanelActionOptions.add(Action.SCRIPT.name(), this.jPanelActionScript);
        this.jPanelActionOptions.add(Action.COMPACTH2.name(), this.jPanelActionNull);
        this.jPanelActionOptions.add(Action.UPDATE_CONSTRAINT.name(), this.jPanelActionNull);
        this.jPanelActionOptions.validate();
        this.actionSelected();
        this.jPanelConnection3.setConnectionSelectionListener(() -> this.targetConnectionSelected());
        this.jPanelConnectionSource.setConnectionSelectionListener(() -> this.sourceConnectionSelected());
        this.forceWriteToFile(true);
    }

    private void actionSelected() {
        Action action = (Action)((Object)this.jComboBoxAction.getSelectedItem());
        ((CardLayout)this.jPanelActionOptions.getLayout()).show(this.jPanelActionOptions, action.name());
        this.jPanelActionOptions.repaint();
        switch (action.ordinal()) {
            case 6: {
                this.jPanelActionOptions.setPreferredSize(new Dimension(this.jPanelActionOptions.getPreferredSize().width, 290));
                this.setSchema();
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                this.jPanelActionOptions.setPreferredSize(new Dimension(this.jPanelActionOptions.getPreferredSize().width, 90));
                break;
            }
            default: {
                this.jPanelActionOptions.setPreferredSize(new Dimension(this.jPanelActionOptions.getPreferredSize().width, 50));
            }
        }
        this.jScrollPane3.setVisible(false);
        this.pack();
        this.jButtonStartAction.setEnabled(action != Action.NULL);
        this.jLabelOutput.setText("");
        this.jTextAreaOutput.setText("");
    }

    private void setSchema() {
        if (this.targetDB.isConnected() && this.targetDB.getTablePrefix() != null && this.targetDB.getTablePrefix().length() > 0) {
            if (this.targetDB.getDBType() == DBType.ORACLE) {
                try {
                    LOGGER.log(Level.INFO, "Altering session for table prefix: " + this.targetDB.getTablePrefix());
                    this.targetDB.getDatabase().createStatement().executeUpdate("ALTER SESSION SET CURRENT_SCHEMA=" + this.targetDB.getTablePrefix());
                    this.jPanelConnection3.updateStatusText("Session schema set to: " + this.targetDB.getTablePrefix());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.targetDB.getDBType() == DBType.POSTGRESQL) {
                try {
                    LOGGER.log(Level.INFO, "Setting schema for table prefix: " + this.targetDB.getTablePrefix());
                    this.targetDB.getDatabase().createStatement().executeUpdate("SET SCHEMA '" + this.targetDB.getTablePrefix() + "'");
                    this.targetDB.commit();
                    this.jPanelConnection3.updateStatusText("Session schema set to: " + this.targetDB.getTablePrefix());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void targetConnectionSelected() {
        try {
            String status;
            this.targetDB = new model3.SBdb();
            ConnectionParameters cp = this.jPanelConnection3.getParams();
            ConnectionDetails connectionDetails = ConnectionDetailsHelper.getConnectionDetails(cp.getDriverType(), cp.getHostName(), true, cp.getInstanceNameWithSec(), cp.getUID(), cp.getPWD(), null, cp.isEncrypt());
            this.targetDB.connect(new BasicConnectionFactory(connectionDetails));
            if (!this.targetDB.validSchema()) {
                status = "Connected to empty database (no schema).";
                this.allowUnrestrictedQueries = true;
            } else {
                status = "Connection successful.";
                this.allowUnrestrictedQueries = this.allowUnrestrictedQueriesInit;
            }
            this.jPanelConnection3.updateFields(this.targetDB.getSchema(), this.targetDB.getDBType().getName(), status);
            this.forceWriteToFile(false);
            model3.SBdb.preserveAudit = true;
            LOGGER.log(Level.INFO, "Connected to v3.0 database");
            LOGGER.log(Level.INFO, "Supports batch updates? " + this.targetDB.getDatabase().getMetaData().supportsBatchUpdates());
        }
        catch (RuntimeException | SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error getting database connection:\n" + ex.getMessage(), "Connect to v3.0", 0);
            ex.printStackTrace();
            this.jPanelConnection3.updateFields("", "", "Error getting connection");
        }
    }

    private void sourceConnectionSelected() {
        this.jPanelConnectionSource.updateFields("", "", "Press start to make connection");
    }

    private void forceWriteToFile(boolean forceWriteToFile) {
        List<JCheckBox> checkBoxes = List.of(this.jCheckBoxActionCreateWriteToFile, this.jCheckBoxActionGrantWriteToFile, this.jCheckBoxActionDeleteWriteToFile);
        checkBoxes.forEach(cb -> {
            cb.setSelected(forceWriteToFile);
            cb.setEnabled(!forceWriteToFile);
        });
    }

    private void initComponents() {
        this.jPanelActionCreate = new JPanel();
        this.jCheckBoxActionCreateFKs = new JCheckBox();
        this.jCheckBoxActionCreateWriteToFile = new JCheckBox();
        this.jPanelActionDelete = new JPanel();
        this.jCheckBoxActionDeleteIfExists = new JCheckBox();
        this.jCheckBoxActionDeleteWriteToFile = new JCheckBox();
        this.jCheckBoxActionDeleteCascade = new JCheckBox();
        this.jPanelActionGrant = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldActionGrantGrantee = new JTextField();
        this.jCheckBoxActionGrantWriteToFile = new JCheckBox();
        this.jPanelActionNull = new JPanel();
        this.jPanelActionCopy = new JPanel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSourceVersion3 = new JRadioButton();
        this.jRadioButtonSourceVersion2 = new JRadioButton();
        this.jPanelConnectionSource = new JPanelConnection(this, ModelVersion.v2_1_1);
        this.jPanelActionScript = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPaneSQL = new JTextPane();
        this.jLabel1 = new JLabel();
        this.jTextFieldQueryTimeout = new JTextField();
        this.jLabel3 = new JLabel();
        this.buttonGroupSourceVersion = new ButtonGroup();
        this.jButtonClose = new JButton();
        this.jPanelConnection3 = new JPanelConnection(this, ModelVersion.V3_0_0);
        this.jComboBoxAction = new JComboBox();
        this.jPanelActionOptions = new JPanel();
        this.jButtonStartAction = new JButton();
        this.jLabelOutput = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jCheckBoxActionCreateFKs.setText("Create foreign keys after tables");
        this.jCheckBoxActionCreateWriteToFile.setSelected(true);
        this.jCheckBoxActionCreateWriteToFile.setText("Write script to file");
        this.jCheckBoxActionCreateWriteToFile.setEnabled(false);
        GroupLayout jPanelActionCreateLayout = new GroupLayout(this.jPanelActionCreate);
        this.jPanelActionCreate.setLayout(jPanelActionCreateLayout);
        jPanelActionCreateLayout.setHorizontalGroup(jPanelActionCreateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionCreateLayout.createSequentialGroup().addContainerGap().addGroup(jPanelActionCreateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxActionCreateFKs).addComponent(this.jCheckBoxActionCreateWriteToFile)).addContainerGap(43, Short.MAX_VALUE)));
        jPanelActionCreateLayout.setVerticalGroup(jPanelActionCreateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionCreateLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxActionCreateFKs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxActionCreateWriteToFile).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxActionDeleteIfExists.setText("IF EXISTS");
        this.jCheckBoxActionDeleteWriteToFile.setText("Write scipt to file");
        this.jCheckBoxActionDeleteCascade.setText("CASCADE");
        GroupLayout jPanelActionDeleteLayout = new GroupLayout(this.jPanelActionDelete);
        this.jPanelActionDelete.setLayout(jPanelActionDeleteLayout);
        jPanelActionDeleteLayout.setHorizontalGroup(jPanelActionDeleteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionDeleteLayout.createSequentialGroup().addContainerGap().addGroup(jPanelActionDeleteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxActionDeleteIfExists).addComponent(this.jCheckBoxActionDeleteCascade).addComponent(this.jCheckBoxActionDeleteWriteToFile)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelActionDeleteLayout.setVerticalGroup(jPanelActionDeleteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionDeleteLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxActionDeleteIfExists).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxActionDeleteCascade).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxActionDeleteWriteToFile).addContainerGap(8, Short.MAX_VALUE)));
        this.jLabel2.setText("Grantee:");
        this.jTextFieldActionGrantGrantee.setText("SBUGS_USER");
        this.jCheckBoxActionGrantWriteToFile.setText("Write script to file");
        GroupLayout jPanelActionGrantLayout = new GroupLayout(this.jPanelActionGrant);
        this.jPanelActionGrant.setLayout(jPanelActionGrantLayout);
        jPanelActionGrantLayout.setHorizontalGroup(jPanelActionGrantLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionGrantLayout.createSequentialGroup().addContainerGap().addGroup(jPanelActionGrantLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionGrantLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldActionGrantGrantee, -1, 287, Short.MAX_VALUE)).addGroup(jPanelActionGrantLayout.createSequentialGroup().addComponent(this.jCheckBoxActionGrantWriteToFile).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelActionGrantLayout.setVerticalGroup(jPanelActionGrantLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionGrantLayout.createSequentialGroup().addContainerGap().addGroup(jPanelActionGrantLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldActionGrantGrantee, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxActionGrantWriteToFile).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelActionNullLayout = new GroupLayout(this.jPanelActionNull);
        this.jPanelActionNull.setLayout(jPanelActionNullLayout);
        jPanelActionNullLayout.setHorizontalGroup(jPanelActionNullLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanelActionNullLayout.setVerticalGroup(jPanelActionNullLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jPanelActionCopy.setPreferredSize(new Dimension(0, 0));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Source Connection", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupSourceVersion.add(this.jRadioButtonSourceVersion3);
        this.jRadioButtonSourceVersion3.setText("v3.0");
        this.jRadioButtonSourceVersion3.addItemListener(new ItemListener(this){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jRadioButtonSourceVersion3ItemStateChanged(evt);
            }
        });
        this.buttonGroupSourceVersion.add(this.jRadioButtonSourceVersion2);
        this.jRadioButtonSourceVersion2.setText("v2.1 or v2.1.1");
        this.jRadioButtonSourceVersion2.addItemListener(new ItemListener(this){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jRadioButtonSourceVersion2ItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSourceVersion3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSourceVersion2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanelConnectionSource, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSourceVersion3).addComponent(this.jRadioButtonSourceVersion2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelConnectionSource, -2, -1, -2)));
        GroupLayout jPanelActionCopyLayout = new GroupLayout(this.jPanelActionCopy);
        this.jPanelActionCopy.setLayout(jPanelActionCopyLayout);
        jPanelActionCopyLayout.setHorizontalGroup(jPanelActionCopyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionCopyLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelActionCopyLayout.setVerticalGroup(jPanelActionCopyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.jPanelActionScript.setPreferredSize(new Dimension(100, 400));
        this.jTextPaneSQL.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane2.setViewportView(this.jTextPaneSQL);
        this.jLabel1.setText("Query timeout:");
        this.jTextFieldQueryTimeout.setText("30");
        this.jTextFieldQueryTimeout.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldQueryTimeoutKeyTyped(evt);
            }
        });
        this.jLabel3.setText("seconds");
        GroupLayout jPanelActionScriptLayout = new GroupLayout(this.jPanelActionScript);
        this.jPanelActionScript.setLayout(jPanelActionScriptLayout);
        jPanelActionScriptLayout.setHorizontalGroup(jPanelActionScriptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionScriptLayout.createSequentialGroup().addContainerGap().addGroup(jPanelActionScriptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 582, Short.MAX_VALUE).addGroup(jPanelActionScriptLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldQueryTimeout, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelActionScriptLayout.setVerticalGroup(jPanelActionScriptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActionScriptLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 398, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelActionScriptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldQueryTimeout, -2, -1, -2).addComponent(this.jLabel3))));
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jButtonClose.setText("Exit");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanelConnection3.setBorder(BorderFactory.createTitledBorder(null, "Target v3.0 Connections", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jComboBoxAction.setModel(this.comboModel);
        this.jPanelActionOptions.setPreferredSize(new Dimension(466, 50));
        this.jPanelActionOptions.setLayout(new CardLayout());
        this.jButtonStartAction.setText("Start selected action");
        this.jButtonStartAction.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonStartActionActionPerformed(evt);
            }
        });
        this.jLabelOutput.setForeground(new Color(102, 102, 102));
        this.jLabelOutput.setText("jLabel3");
        this.jTextAreaOutput.setEditable(false);
        this.jTextAreaOutput.setColumns(20);
        this.jTextAreaOutput.setFont(new Font("Monospaced", 0, 12));
        this.jTextAreaOutput.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextAreaOutput);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelActionOptions, -1, 600, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3).addComponent(this.jPanelConnection3, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabelOutput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonStartAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jComboBoxAction, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelConnection3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxAction, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelActionOptions, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonStartAction).addComponent(this.jLabelOutput)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void exit() {
        try {
            if (this.targetDB != null) {
                this.targetDB.commit();
                this.targetDB.close();
            }
        }
        catch (SQLException ex) {
            System.out.println("Error closing database connection: " + ex.getMessage());
            ex.printStackTrace();
        }
        this.dispose();
    }

    private void runScript(String script, boolean freehandScript) {
        if (this.targetDB == null || !this.targetDB.isConnected()) {
            JOptionPane.showMessageDialog(this, "Not connected to database");
            return;
        }
        if (script.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No script entered");
            return;
        }
        this.jPanelConnection3.updateStatusText("");
        final ScriptRunner scriptRunner = new ScriptRunner(script, this.targetDB, this.jTextAreaOutput, this, this.allowUnrestrictedQueries);
        scriptRunner.setCommitMode(freehandScript ? ScriptRunner.CommitMode.WITH_CONFIRM : ScriptRunner.CommitMode.NONE);
        try {
            int timeout = Integer.parseInt(this.jTextFieldQueryTimeout.getText());
            scriptRunner.setQueryTimeout(timeout);
        }
        catch (Exception e) {
            scriptRunner.setQueryTimeout(60);
        }
        scriptRunner.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ FrameConv this$0;
            {
                FrameConv frameConv = this$0;
                Objects.requireNonNull(frameConv);
                this.this$0 = frameConv;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName())) {
                    SwingWorker.StateValue newState = (SwingWorker.StateValue)((Object)evt.getNewValue());
                    switch (newState) {
                        case STARTED: {
                            this.this$0.jLabelOutput.setText("Running script...");
                            this.this$0.jButtonStartAction.setEnabled(false);
                            return;
                        }
                        case DONE: {
                            if (scriptRunner.ranToComplete()) {
                                try {
                                    this.this$0.targetDB.commit();
                                }
                                catch (SQLException ex) {
                                    JOptionPane.showMessageDialog(this.this$0, "Script ran to completion but there was an error during the final commit:\n\n" + ex.getMessage(), "Error", 2);
                                    this.this$0.jLabelOutput.setText("Script ran to completion");
                                    return;
                                }
                                try {
                                    List results = (List)scriptRunner.get();
                                    if (results.isEmpty()) {
                                        if (scriptRunner.getCommitMode() != ScriptRunner.CommitMode.WITH_CONFIRM) {
                                            JOptionPane.showMessageDialog(this.this$0, "Script ran to completion", "Run Script", 1);
                                        }
                                    } else {
                                        for (QueryResult result : results) {
                                            DialogSQLResults dialog = new DialogSQLResults((Frame)this.this$0, this.this$0.targetDB, result);
                                            if (dialog.displayCancelled()) continue;
                                            dialog.setLocation(this.this$0.getX() - 30, this.this$0.getY() - 30);
                                            dialog.setVisible(true);
                                        }
                                    }
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    LOGGER.log(Level.SEVERE, "SwingWorker error", e);
                                }
                                this.this$0.jLabelOutput.setText("Script ran to completion");
                            } else {
                                this.this$0.jLabelOutput.setText("Error running script");
                            }
                            this.this$0.jButtonStartAction.setEnabled(true);
                        }
                    }
                }
            }
        });
        scriptRunner.execute();
    }

    private void writeScript(String script, String defaultOutputFileName) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(defaultOutputFileName));
        if (fileChooser.showSaveDialog(this) == 0) {
            File outFile = fileChooser.getSelectedFile();
            if (outFile.exists() && JOptionPane.showConfirmDialog(this, "Overwrite: " + outFile.getPath() + "?", "Confirm overwrite?", 0, 3) == 1) {
                return;
            }
            try (BufferedWriter out = new BufferedWriter(new FileWriter(outFile));){
                out.write("/* This script has been generated by StrataBugs Database Utility. Do not edit.\n");
                out.write("Date: " + Calendar.getInstance().getTime().toString() + "\n*/\n");
                out.write(script);
                JOptionPane.showMessageDialog(this, "File written: " + outFile.getPath());
            }
            catch (IOException ex) {
                String s = "IO Error: " + ex.toString();
                JOptionPane.showMessageDialog(this, s);
                ex.printStackTrace();
            }
        }
    }

    private void jButtonStartActionActionPerformed(ActionEvent evt) {
        this.runSelectedAction();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exit();
    }

    private void jRadioButtonSourceVersion3ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setSourceVersion();
        }
    }

    private void jRadioButtonSourceVersion2ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setSourceVersion();
        }
    }

    private void jTextFieldQueryTimeoutKeyTyped(KeyEvent evt) {
        if (SwingTextFieldUtils.intFieldVal(this.jTextFieldQueryTimeout, 4, evt, false)) {
            this.getToolkit().beep();
        }
    }

    private void setSourceVersion() {
        if (this.jRadioButtonSourceVersion2.isSelected()) {
            this.jPanelConnectionSource.setVersion(ModelVersion.v2_1);
        } else {
            this.jPanelConnectionSource.setVersion(ModelVersion.V3_0_0);
        }
        this.sourceConnectionSelected();
    }

    private void runSelectedAction() {
        Action action = (Action)((Object)this.jComboBoxAction.getSelectedItem());
        if (action == Action.NULL) {
            return;
        }
        switch (action.ordinal()) {
            case 1: {
                this.doCreateAction(this.jCheckBoxActionCreateFKs.isSelected(), this.jCheckBoxActionCreateWriteToFile.isSelected());
                break;
            }
            case 2: {
                this.doGrantAction(this.jTextFieldActionGrantGrantee.getText(), this.jCheckBoxActionGrantWriteToFile.isSelected());
                break;
            }
            case 3: {
                this.doDropAction(this.jCheckBoxActionDeleteIfExists.isSelected(), this.jCheckBoxActionDeleteCascade.isSelected(), this.jCheckBoxActionDeleteWriteToFile.isSelected());
                break;
            }
            case 5: {
                this.doDemoAction();
                break;
            }
            case 4: {
                this.doCopyAction();
                break;
            }
            case 6: {
                this.doScriptAction(this.jTextPaneSQL.getText());
                break;
            }
            case 7: {
                this.doCompactAction();
                break;
            }
            case 8: {
                this.doConstraintAction();
            }
        }
    }

    private void doCreateAction(boolean createFKsAfterTables, boolean writeToFile) {
        DBType dbType;
        if (this.targetDB == null) {
            DialogSelectDbType dialog = new DialogSelectDbType((Frame)this, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            dbType = dialog.getDbType();
            if (dbType == null) {
                return;
            }
        } else {
            dbType = this.targetDB.getDBType();
            try {
                this.targetDB.setSchema();
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(this, "Error setting schema: " + se.getMessage());
                LOGGER.log(Level.SEVERE, "Error setting schema");
                return;
            }
        }
        String createTableScript = SbugsScriptUtilities.createTableScript(dbType, createFKsAfterTables);
        this.runOrWrite(createTableScript, writeToFile, "SBUGS3-0_" + dbType.getName().toLowerCase() + ".sql");
    }

    private void doGrantAction(String grantee, boolean writeToFile) {
        if (grantee.isBlank()) {
            JOptionPane.showMessageDialog(this, "You must select a grantee.\nThis user must exist in the target schema.", "Grant Table Permissions", 2);
            return;
        }
        String grantScript = SbugsScriptUtilities.grantScript(grantee);
        if (this.targetDB != null) {
            try {
                this.targetDB.setSchema();
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(this, "Error setting schema: " + se.getMessage());
                LOGGER.log(Level.SEVERE, "Error setting schema");
                return;
            }
        }
        this.runOrWrite(grantScript, writeToFile, "SBUGS3-0_grant_" + grantee + ".sql");
    }

    private void doDropAction(boolean ifExists, boolean cascade, boolean writeToFile) {
        String msg;
        int opt;
        if (!writeToFile && (opt = JOptionPane.showConfirmDialog(this, msg = "This is an irreversbile action which will delete ALL data from your database.\nAre you sure you want to continue?", Action.DROP.description, 0)) != 0) {
            return;
        }
        String dropScript = SbugsScriptUtilities.dropScript(ifExists, cascade, this.targetDB.getDBType());
        this.runOrWrite(dropScript, writeToFile, "SBUGS3-0_drop.sql");
    }

    private void runOrWrite(String script, boolean writeToFile, String defaultOutputFileName) {
        if (writeToFile) {
            this.writeScript(script, defaultOutputFileName);
        } else {
            this.jScrollPane3.setVisible(true);
            this.pack();
            this.runScript(script, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyAction() {
        if (this.targetDB == null || !this.targetDB.isConnected()) {
            JOptionPane.showMessageDialog(this, "Select the target database.", "Copy Data", 2);
            return;
        }
        ConnectionParameters sourceParams = this.jPanelConnectionSource.getParams();
        if (sourceParams == null) {
            JOptionPane.showMessageDialog(this, "Select the source database.", "Copy Data", 2);
            return;
        }
        CopySource copySource = null;
        switch (sourceParams.getModelVersion()) {
            case v2_1: 
            case v2_1_1: {
                SBdb sourceDB;
                try {
                    sourceDB = new SBdb();
                    sourceDB.connect(sourceParams.getDriverName().toLowerCase(), sourceParams.getHostName(), sourceParams.getInstanceNameWithSec(), sourceParams.getUID(), sourceParams.getPWD());
                }
                catch (ReflectiveOperationException | SQLException ex) {
                    LOGGER.log(Level.SEVERE, "Error getting v2.1 database connection", ex);
                    JOptionPane.showMessageDialog(this, "Error getting database connection:\n" + ex.getMessage(), "Connect to v2.1", 0);
                    this.jPanelConnectionSource.updateFields("", "", "Error getting connection");
                    return;
                }
                if (!sourceDB.isConnected()) {
                    return;
                }
                this.jPanelConnectionSource.updateFields(sourceDB.getSchema(), sourceDB.getDBType().getName(), "Connection successful.");
                copySource = CopySource.newInstance(sourceDB);
                break;
            }
            case V3_0_0: {
                model3.SBdb sourceDB3;
                try {
                    sourceDB3 = new model3.SBdb();
                    ConnectionDetails connectionDetails = ConnectionDetailsHelper.getConnectionDetails(sourceParams.getDriverType(), sourceParams.getHostName(), false, sourceParams.getInstanceNameWithSec(), sourceParams.getUID(), sourceParams.getPWD(), null, false);
                    sourceDB3.connect(new BasicConnectionFactory(connectionDetails));
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.SEVERE, "Error getting v3.0 database connection", ex);
                    JOptionPane.showMessageDialog(this, "Error getting database connection:\n" + ex.getMessage(), "Connect to v3.0", 0);
                    this.jPanelConnectionSource.updateFields("", "", "Error getting connection");
                    return;
                }
                if (!sourceDB3.isConnected()) {
                    return;
                }
                this.jPanelConnectionSource.updateFields(sourceDB3.getSchema(), sourceDB3.getDBType().getName(), "Connection successful.");
                copySource = CopySource.newInstance(sourceDB3);
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogCopyConvertDatabase ccdialog = new DialogCopyConvertDatabase(this, true, sourceParams, copySource, this.jPanelConnection3.getParams(), this.targetDB);
            ccdialog.setLocationRelativeTo(this);
            this.setCursor(Cursor.getDefaultCursor());
            ccdialog.setVisible(true);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error opening copy dialog", e);
            JOptionPane.showMessageDialog(this, "Error " + e.getMessage(), this.getTitle(), 1);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void doDemoAction() {
        try {
            DialogDownloadDB dbdialog = new DialogDownloadDB((Frame)this, true);
            dbdialog.setLocationRelativeTo(this);
            dbdialog.setVisible(true);
            if (dbdialog.selectedFilePath != null) {
                DialogConnection dialog = new DialogConnection(this, true, ConnectionParameters.getConnections(model3.SBdb.MODEL_VERSION), null, model3.SBdb.MODEL_VERSION);
                dialog.initParms("Demo", dbdialog.selectedFilePath, DBType.H2);
                SBDialog.centreWindow(dialog);
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error opening copy demo database dialog", e);
            JOptionPane.showMessageDialog(this, "Error " + e.getMessage(), this.getTitle(), 1);
        }
    }

    private void doScriptAction(String script) {
        if (script.isBlank()) {
            return;
        }
        this.jScrollPane3.setVisible(true);
        this.pack();
        this.runScript(script, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompactAction() {
        if (this.targetDB == null) {
            JOptionPane.showMessageDialog(this, "Not connected to a database", this.getTitle(), 1);
            return;
        }
        if (this.targetDB.getDBType() != DBType.H2) {
            JOptionPane.showMessageDialog(this, "Connection is not an h2 database", this.getTitle(), 1);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try (Statement stmt = this.targetDB.getDatabase().createStatement();){
            stmt.execute("shutdown compact");
            this.targetDB = null;
            JOptionPane.showMessageDialog(this, "Compaction complete, database utillity will exit", this.getTitle(), 1);
            System.exit(0);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error compacting database", e);
            JOptionPane.showMessageDialog(this, "Error " + e.getMessage(), this.getTitle(), 1);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConstraintAction() {
        if (this.targetDB == null) {
            JOptionPane.showMessageDialog(this, "Not connected to a database", this.getTitle(), 1);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try (Statement stmt = this.targetDB.getDatabase().createStatement();){
            String sql;
            String SITUATION_CONS = "situation_cons";
            if (this.constraintExists(this.targetDB, "situation_cons")) {
                if (JOptionPane.showConfirmDialog(this, "New constraint already exists, delete and recreate?", this.getTitle(), 0, 3) == 1) {
                    return;
                }
                sql = "alter table " + this.targetDB.DBTableName("taxonocc") + " drop constraint situation_cons";
                stmt.execute(sql);
            } else {
                this.dropUnnamedConstraint(this.targetDB, "taxonocc", "situation");
            }
            sql = "alter table " + this.targetDB.DBTableName("taxonocc") + " add constraint situation_cons check (situation in ('I', 'T', 'R', 'C', 'N'))";
            int returnStatus = stmt.executeUpdate(sql);
            this.targetDB.commit();
            JOptionPane.showMessageDialog(this, "Update complete: return status: " + returnStatus, this.getTitle(), 1);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error setting constraint: ", e);
            JOptionPane.showMessageDialog(this, "Error " + e.getMessage(), this.getTitle(), 1);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean constraintExists(model3.SBdb db, String constraint_name) throws SQLException {
        String sql = switch (db.getDBType()) {
            default -> "SELECT constraint_name FROM information_schema.table_constraints WHERE constraint_name='" + constraint_name.toUpperCase() + "'";
            case DBType.ORACLE -> "SELECT constraint_name FROM sys.user_constraints WHERE constraint_name='" + constraint_name.toUpperCase() + "' AND owner='" + db.getSchema() + "'";
            case DBType.MSSQLSERVER -> "SELECT constraint_name FROM information_schema.key_column_usage WHERE constraint_name='" + constraint_name.toUpperCase() + "'";
            case DBType.POSTGRESQL -> "SELECT con.conname FROM pg_catalog.pg_constraint con INNER JOIN pg_catalog.pg_class rel ON rel.oid = con.conrelid INNER JOIN pg_catalog.pg_namespace nsp ON nsp.oid = connamespace WHERE nsp.nspname = '" + db.getSchema() + "' AND con.conname = '" + constraint_name + "'";
        };
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            boolean bl = rs.next();
            return bl;
        }
    }

    private void dropUnnamedConstraint(model3.SBdb db, String tableName, String columnName) throws SQLException {
        String sql = switch (db.getDBType()) {
            default -> "SELECT u.constraint_name FROM information_schema.constraint_column_usage u, information_schema.table_constraints t WHERE t.constraint_name=u.constraint_name and u.table_name='" + tableName.toUpperCase() + "' and u.column_name='" + columnName.toUpperCase() + "' AND T.constraint_type='CHECK'";
            case DBType.ORACLE -> "SELECT c1.constraint_name FROM sys.user_constraints c1, sys.usEr_cons_columns c2 WHERE c1.constraint_name=c2.constraint_name AND c1.constraint_type='C' AND c1.owner='" + db.getSchema() + "' AND c1.table_name='" + tableName.toUpperCase() + "' AND c2.column_name='" + columnName.toUpperCase() + "'";
            case DBType.MSSQLSERVER -> "SELECT u.constraint_name FROM information_schema.constraint_column_usage u, information_schema.table_constraints t WHERE t.table_name='" + tableName.toUpperCase() + "'AND t.constraint_name=u.constraint_name AND t.constraint_type='CHECK' AND u.column_name='" + columnName.toUpperCase() + "'";
            case DBType.POSTGRESQL -> "SELECT u.constraint_name FROM information_schema.constraint_column_usage u, information_schema.table_constraints t WHERE t.table_name='" + tableName.toLowerCase() + "'AND t.table_schema='" + db.getSchema() + "'AND t.constraint_name=u.constraint_name AND t.constraint_type='CHECK' AND u.column_name='" + columnName.toLowerCase() + "'";
        };
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            String constraintName = "";
            if (rs.next()) {
                constraintName = rs.getString("constraint_name");
            }
            if (!constraintName.isEmpty()) {
                sql = "alter table " + db.DBTableName(tableName) + " drop constraint " + constraintName;
                stmt.execute(sql);
            }
        }
    }

    private static enum Action {
        NULL("<Select an action>"),
        CREATE("Create tables"),
        GRANT("Grant table permissions"),
        DROP("Delete all tables"),
        COPY("Copy data from another database"),
        DEMO("Download demo database"),
        SCRIPT("Run custom script"),
        COMPACTH2("Compact h2 database"),
        UPDATE_CONSTRAINT("Enable recording of extended occurrence type (3.0.48)");

        final String description;

        private Action(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

