/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.db;

import com.stratadata.model3.db.ConnectionDetails;
import com.stratadata.model3.db.ConnectionFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HikariConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(HikariConnectionFactory.class.getName());
    private final ConnectionDetails connDetails;
    private HikariDataSource ds;
    private final int maxPoolSize;

    public HikariConnectionFactory(ConnectionDetails connDetails, int maxPoolSize) {
        this.connDetails = connDetails;
        this.maxPoolSize = maxPoolSize;
    }

    public void setupDataSource() {
        if (this.connDetails == null) {
            throw new IllegalStateException("Can't setup a data source with no connection details set.");
        }
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(this.maxPoolSize);
        if (this.connDetails.props() == null) {
            config.setJdbcUrl(this.connDetails.driverString());
            config.setUsername(this.connDetails.instanceLogin());
            config.setPassword(this.connDetails.password());
            config.addDataSourceProperty("cachePrepStmts", (Object)"true");
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        } else {
            config.setJdbcUrl(this.connDetails.driverString());
            config.setDataSourceProperties(this.connDetails.props());
        }
        String initSQL = this.connDetails.getInitSQL();
        if (!initSQL.isEmpty()) {
            config.setConnectionInitSql(initSQL);
        }
        LOGGER.log(Level.CONFIG, "Hikari connection timeout (secs) " + config.getConnectionTimeout() / 1000L);
        this.ds = new HikariDataSource(config);
        if (this.connDetails.driverString().contains("ActiveDirectory")) {
            try {
                LOGGER.log(Level.CONFIG, "Hikari login timeout (secs) " + this.ds.getLoginTimeout());
                if (this.ds.getLoginTimeout() < 20) {
                    this.ds.setLoginTimeout(20);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            this.setupDataSource();
        }
        return this.ds.getConnection();
    }

    @Override
    public String getTablePrefix() {
        return this.connDetails.tablePrefix();
    }

    @Override
    public void close() {
        if (this.ds != null) {
            this.ds.close();
            this.ds = null;
        }
    }
}

