/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.db;

import com.stratadata.model3.db.ModelVersion;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SBTables {
    private static final List<Table> TABLES = List.of(new Table("CONTROL", false, CopyLevel.ALL, "SELECT replace(table_name, 'WELL_IDENT', 'WELLS') as table_name, next_id FROM <schema>control "), new Table("USERDEF", true, CopyLevel.BARE_BONES, "SELECT user_id, name, abr, sys_name, disc, user_priv, password,<colour_translate>,null as created, null as creator, null as modified, null as modifier, null as updated, null as updater FROM <schema>userdef"), new Table("WELLS", true, CopyLevel.ALL, "SELECT i.well_id, w.well_name, null as well_alt_name, w.well_code, i.descrip, w.operator, null as client, w.country, null as loc_state, w.county, w.ocs, null as area, null as basin, w.field, w.grid_x, w.grid_y, null as utmzone, w.spud_date, w.comp_date, w.lat_dec, w.long_dec, COALESCE(w.td, 99999) as td, w.sl, w.sb, w.rte, w.kicko, w.datum, w.type, w.units, w.geodatum, w.lith_depth, <colour_translate>,null as data_source, w.chart_url, 2000 as scale, w.created, w.creator, w.modified, w.modifier, w.updated, w.updater, i.acm FROM <schema>wells w, <schema>well_ident i WHERE w.well_code=i.well_code", "w"), new Table("WELL_TRACK", true, CopyLevel.ALL, true), new Table("DOC_REFS", false, CopyLevel.ALL), new Table("INTERP", true, CopyLevel.BARE_BONES), new Table("WELL_DOCS", true, CopyLevel.ALL, true), new Table("SAMPLES", true, CopyLevel.ALL), new Table("ABNSCHME", true, CopyLevel.BARE_BONES), new Table("ABNSCHMBR", false, CopyLevel.BARE_BONES, "SELECT scheme_id,entry_no,entry_name,abr,min,output_val,null as symbol FROM <schema>abnschmbr"), new Table("CASDIAM", false, CopyLevel.BARE_BONES), new Table("CASING", true, CopyLevel.ALL), new Table("DISCS", false, CopyLevel.BARE_BONES), new Table("CATEGORY", false, CopyLevel.BARE_BONES, "SELECT c1.disc_id, c1.cat_mnem, c1.cat_name,<colour_translate> FROM <schema>category c1  LEFT  JOIN <schema>catcol c2 ON c1.cat_mnem=c2.abr"), new Table("SMPTYPES", false, CopyLevel.BARE_BONES), new Table("CHLABELS", false, CopyLevel.ALL), new Table("CORES", true, CopyLevel.ALL), new Table("CORESHIFT", false, CopyLevel.ALL), new Table("HC_SHOWS", true, CopyLevel.ALL), new Table("ENV_SCH", true, CopyLevel.BARE_BONES), new Table("ENVSCHMBR", false, CopyLevel.BARE_BONES, "SELECT envsch_id,term_no,term,<colour_translate>,comments FROM <schema>envschmbr"), new Table("ANALY_HDR", true, CopyLevel.ALL, "SELECT analy_id,well_id,disc_id,analyst,analy_no,date_from,date_to,depth_from,depth_to,comments,envsch_id,abnsch_id,<colour_translate>,created,creator,modified,modifier,updated,updater FROM <schema>analy_hdr"), new Table("BCMMNTS", true, CopyLevel.ALL), new Table("FAULTS", true, CopyLevel.ALL), new Table("GENUS", true, CopyLevel.TAXONDICT, "SELECT cat_mnem,gen_id,q1,genus,q2,q3,sub_genus,q4,created,creator,modified,modifier,updated,updater, null as colour FROM <schema>GENUS"), new Table("IGD_DEF", false, CopyLevel.BARE_BONES, "SELECT name,igd_type,parent,case when hier=4 and igd_type=2 then 8 when hier=3 and igd_type=2 then 5 when hier=2 and igd_type=2 then 4 when hier=1 and igd_type=2 then 2 when hier=1 and igd_type=10 then 2 when hier=2 and igd_type=10 then 3 else hier end as hier FROM <schema>igd_def", null, false, "insert into <targetSchema>IGD_DEF (name,igd_type,parent,hier) values ('Supergroup',2,2,1);insert into <targetSchema>IGD_DEF (name,igd_type,parent,hier) values ('Subgroup',2,2,3);insert into <targetSchema>IGD_DEF (name,igd_type,parent,hier) values ('Unit',2,2,6);insert into <targetSchema>IGD_DEF (name,igd_type,parent,hier) values ('Subunit',2,2,7);insert into <targetSchema>IGD_DEF (name,igd_type,parent,hier) values ('Megasequence',10,10,1);"), new Table("IGD_SCH", true, CopyLevel.SCHEMES, "SELECT sch_id, igd_type, disc_id, <false> as archive, name, null as comments, sqtype, acm, parent, created, creator, modified, modifier, updated, updater  FROM <schema>IGD_SCH"), new Table("IGD_DICT", true, CopyLevel.SCHEMES, "SELECT igd_id,sch_id,igd_type,case when igd_type=10 then hier+1 else hier end as hier,name,abr,case when u_age=0 and l_age=0 then null else u_age end as u_age,case when l_age=0 then null else l_age end as l_age,<colour_translate>,u_unit_ref,u_unit_val,u_conf,l_unit_ref,l_unit_val,l_conf,comments,created,creator,modified,modifier,updated,updater FROM <schema>igd_dict ORDER BY igd_type,sch_id,u_unit_ref <nulls first>,l_unit_ref <nulls first>"), new Table("CMPSTD", true, CopyLevel.TAXONDICT, "SELECT std_id, name, null as comments, <false> as archive, topcsu, basecsu, minage, maxage, units, acm, parent, CREATED,CREATOR,MODIFIED,MODIFIER,UPDATED,UPDATER FROM <schema>CMPSTD"), new Table("IGD_ENV", true, CopyLevel.ALL), new Table("IGD_HDR", true, CopyLevel.ALL), new Table("IGD", true, CopyLevel.ALL, "SELECT well_id,igd_type,hier,top_id,base_id,top_bnd,base_bnd,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf,interp_id,top_analy,base_analy,sep,0 as confidence,created,creator,modified,modifier,updated,updater FROM <schema>igd"), new Table("AGE_CURVE", true, CopyLevel.SCHEMES, "SELECT curve_id,sch_id,title,units,linewidth,<colour_translate>,style, created, creator, modified, modifier, updated, updater  FROM <schema>age_curve"), new Table("AGE_TRACE", false, CopyLevel.SCHEMES), new Table("IGD_COLMAP", false, CopyLevel.ALL, "SELECT well_id,interp_id,igd_type,col,title,case when maxhier=4 and igd_type=2 then 8 when maxhier=3 and igd_type=2 then 5 when maxhier=2 and igd_type=2 then 4 when maxhier=1 and igd_type=2 then 2 else maxhier end as maxhier FROM <schema>igd_colmap"), new Table("SBIMAGE", false, CopyLevel.ALL), new Table("IMAGE_SET", false, CopyLevel.ALL), new Table("IMAGE_SETMBR", false, CopyLevel.ALL), new Table("INTCMMNTS", true, CopyLevel.ALL), new Table("LITHDESC", false, CopyLevel.BARE_BONES), new Table("LOC", true, CopyLevel.ALL, "SELECT well_id,interp_id,std_id,<colour_translate>,linewidth, comments, created, creator, modified, modifier, updated, updater  FROM <schema>loc"), new Table("LOCNODE", false, CopyLevel.ALL, "SELECT well_id,interp_id,node_key,depth,age,bnd,<colour_translate> FROM <schema>locnode"), new Table("LOGDEF", false, CopyLevel.BARE_BONES), new Table("LOG_CURVE", true, CopyLevel.ALL), new Table("LOG_TRACE", false, CopyLevel.ALL), new Table("LTHTRNSCH", false, CopyLevel.ALL), new Table("PREF_SYSTEM", false, CopyLevel.BARE_BONES, "SELECT pref_key, pref_value FROM <schema>pref_system UNION SELECT REPLACE(abr,'**','COL_') AS pref_key,<colour_translate_pref> FROM <schema>catcol WHERE abr LIKE '**%'"), new Table("PREF_USER", false, CopyLevel.ALL), new Table("SBCHARTS", true, CopyLevel.ALL, "SELECT chart_id,global,owner,well_id,project,rtrim(name),top_depth,base_depth,scale,units,hdr_height,mono_lith,interp_id,syn_sch,asyn_sch,created,creator,modified,modifier,updated,updater FROM <schema>sbcharts"), new Table("SBCHCLIN", false, CopyLevel.ALL), new Table("SBCHPANL", false, CopyLevel.ALL), new Table("SBGS", false, CopyLevel.ALL), new Table("SBILITH", false, CopyLevel.ALL), new Table("SBLOGTRC", false, CopyLevel.ALL), new Table("SBLTHSCH", false, CopyLevel.BARE_BONES), new Table("SBLTHMBR", false, CopyLevel.BARE_BONES), new Table("SBLTHPAT", false, CopyLevel.BARE_BONES), new Table("SBLTHTRN", false, CopyLevel.ALL), new Table("SBQLITH", false, CopyLevel.ALL, "SELECT well_id,type,top_depth,null as base_depth,alignment,plotpos,lith_id,txt FROM <schema>sbqlith"), new Table("SBSCALES", false, CopyLevel.BARE_BONES), new Table("SBSLITH", false, CopyLevel.ALL), new Table("SBSSR", false, CopyLevel.ALL), new Table("SBTEMPLT", false, CopyLevel.ALL), new Table("SBPANELS", false, CopyLevel.ALL), new Table("SBLOGTPL", false, CopyLevel.ALL), new Table("PROJECT", true, CopyLevel.TEMPLATE, "SELECT id as proj_id, name, null as descr, created, creator, modified, modifier, updated, updater FROM <schema>sbwllst"), new Table("WELLIST", true, CopyLevel.TEMPLATE, "SELECT id as wellist_id, id as proj_id, name, null as descr, created, creator, modified, modifier, updated, updater FROM <schema>sbwllst"), new Table("WELLIST_MBR", false, CopyLevel.ALL, "SELECT id as wellist_id, well_id FROM <schema>sbwlmb"), new Table("SMPDTL", true, CopyLevel.ALL, "SELECT well_id,samp_id,analy_id,null as label,picker,source,barren,fov,weight,coarse,medium,fine,notes,proximal,distal,image_set_id,url,created,creator,modified,modifier,updated,updater FROM <schema>smpdtl"), new Table("SPECIES", true, CopyLevel.TAXONDICT, "SELECT s.gen_id, s.spec_id, s.q1, s.species, s.q2, s.q3, s.sub_spec, s.q4, s.alphacode, rtrim(replace(concat(s.author,concat(' ', replace(cast(s.year as <char>),'.0',''))),'  ',' ')) as author, r.reference, n.notes, u.url, s.created, s.creator, s.modified, s.modifier, s.updated, s.updater FROM <schema>SPECIES s LEFT JOIN <schema>TXREFS r on s.spec_id=r.spec_id LEFT JOIN <schema>TXNOTES n on s.spec_id=n.spec_id LEFT JOIN <schema>TXURL u on s.spec_id=u.spec_id"), new Table("SIPMDICT", false, CopyLevel.BARE_BONES), new Table("SIPMCODE", false, CopyLevel.TAXONDICT), new Table("EVENTDIC", true, CopyLevel.TAXONDICT, "SELECT ev_id, spec_id, null as disc_id, ev_extent, ev_desc, abr, case when generate='Y' then <true> else <false> end as generate,name, null as abnsch_id, null as abn_abr, abn,case when ev_type='R' then <true> else <false> end as has_top, case when ev_type='R' then <true> else <false> end as has_base, case when ev_type<>'R' then <true> else <false> end as has_single, null as pfx_well_top, null as pfx_well_base, null as pfx_well_single, null as pfs_scheme_top, null as pfx_scheme_base, null as pfx_scheme_single, <true> as pfx_sfx, created, creator, modified, modifier, updated, updater FROM <schema>EVENTDIC"), new Table("SOURCE", false, CopyLevel.ALL), new Table("EVENT_PFX_TRANS", false, CopyLevel.ALL, true), new Table("ENVTRN", false, CopyLevel.ALL), new Table("EVENTS", true, CopyLevel.ALL, "SELECT INTERP_ID,EV_ID,EV_TYPE,WELL_ID,SAMP_ID,DISC_ID,ANALYST,QUALIFIER,COMMENTS,SOURCE,COMPANY,case when CONFIDENCE is null then 0 else confidence end as CONFIDENCE,depthplus,depthminus,created,creator,modified,modifier,updated,updater FROM <schema>EVENTS"), new Table("CMPSTDEV", true, CopyLevel.TAXONDICT), new Table("CMPSTDEV_EX", false, CopyLevel.TAXONDICT), new Table("CMPSTD_ACL", false, CopyLevel.ALL), new Table("CMPSTD_PARENT", false, CopyLevel.TAXONDICT, true), new Table("OVERLAY", true, CopyLevel.TAXONDICT), new Table("OVR_MAP", false, CopyLevel.TAXONDICT), new Table("SPECIESTYPE", false, CopyLevel.BARE_BONES), new Table("TXGROUP", true, CopyLevel.TEMPLATE, "SELECT grp_id, name, c1.abr, proj_id, descr,<colour_translate>,acm, created, creator, modified, modifier, updated, updater FROM <schema>txgroup c1 LEFT JOIN (SELECT cast(abr as int) AS abr, red, green, blue FROM <schema>catcol WHERE abr > '0' and abr < 'A') c2 ON c1.grp_id=c2.abr"), new Table("GROUPMBR", false, CopyLevel.TEMPLATE), new Table("GROUPMBR_GENUS", false, CopyLevel.TEMPLATE), new Table("GROUPSET", true, CopyLevel.TEMPLATE), new Table("SETMBR", false, CopyLevel.TEMPLATE), new Table("SURFACE", true, CopyLevel.SCHEMES), new Table("SQPICK", true, CopyLevel.ALL), new Table("SYNSCH", false, CopyLevel.BARE_BONES), new Table("SYNONYMY", false, CopyLevel.TAXONDICT), new Table("TAXONOCC", true, CopyLevel.ALL, "SELECT well_id,samp_id,analy_id,spec_id,case when caved='C' and status='I' then 'C' else status end as status,ident_type, spec_type_id,marker,abund,coarse,medium,fine,preserv,colour,comments,image_set_id,created,creator,modified,modifier,updated,updater FROM <schema>TAXONOCC"), new Table("COREIMAGE", false, CopyLevel.ALL), new Table("TVDHDR", false, CopyLevel.ALL), new Table("TXIMAGE", false, CopyLevel.ALL), new Table("TXLOAD", false, CopyLevel.ALL), new Table("TXDEPTH", true, CopyLevel.ALL), new Table("EVLOAD", false, CopyLevel.ALL), new Table("WELLSMARK", true, CopyLevel.ALL, "SELECT well_id,depth,name,<colour_translate>,created, creator, modified, modifier, updated, updater FROM <schema>WELLSMARK"), new Table("WELLTVD", false, CopyLevel.ALL), new Table("WELLTWT", false, CopyLevel.ALL), new Table("SHAPESTORE", false, CopyLevel.TEMPLATE, true), new Table("SHAPESTORE_DATA", false, CopyLevel.TEMPLATE, true), new Table("CHART", true, CopyLevel.ALL, "SELECT chart_id,descr,comments,props,proj_id,proj_id as wellist_id,sch_id,header,cht_key,acm,created,creator,modified,modifier,updated,updater FROM <schema>CHART"), new Table("CHARTCORR", true, CopyLevel.TEMPLATE), new Table("CHTBLOCK", true, CopyLevel.TEMPLATE), new Table("CHTPANL", true, CopyLevel.TEMPLATE, "SELECT panel_id,type,descr,comments,isdefault,isvisible,prop,proj_id, null as WELLIST_ID,sch_id,std_id,envsch_id,synsch_id,grpset_id,agecurve_id,null as shape_id,acm,created,creator,modified,modifier,updated,updater FROM <schema>CHTPANL"), new Table("CHTBLOCKMBR", false, CopyLevel.TEMPLATE), new Table("CHTCORROCC", false, CopyLevel.ALL), new Table("CHTCORROCC_STD", false, CopyLevel.ALL), new Table("CHTCORROCC_STD_UNIT", false, CopyLevel.ALL), new Table("CHTLN_EV", false, CopyLevel.TEMPLATE), new Table("CHTLN_SURFACE", false, CopyLevel.TEMPLATE), new Table("CHTLN_UNIT", false, CopyLevel.TEMPLATE), new Table("CHTMBR", false, CopyLevel.ALL, "SELECT chart_id,block_id,block_no,well_id,proj_id as wellist_id,interp_id,props,caption FROM <schema>CHTMBR"), new Table("CHTPANL_BLKMBR", false, CopyLevel.TEMPLATE), new Table("CHTPANLMBR", false, CopyLevel.TEMPLATE), new Table("CHTLOG", false, CopyLevel.TEMPLATE), new Table("CHTPREF_BLK", false, CopyLevel.ALL), new Table("CHTPREF_CHT", false, CopyLevel.ALL), new Table("CHTPREF_SCH", false, CopyLevel.ALL, "SELECT block_id,user_id,well_id,proj_id as wellist_id,interp_id,sch_id,b_prop,c_prop,header,cht_key,location FROM <schema>CHTPREF_SCH"), new Table("CHTANALYST", false, CopyLevel.TEMPLATE), new Table("CHTSPECTYPE", false, CopyLevel.TEMPLATE), new Table("IGD_SCH_ACL", false, CopyLevel.ALL), new Table("WELLS_ACL", false, CopyLevel.ALL, "SELECT well_id, user_id FROM <schema>well_ident_acl", null, true, null), new Table("TXGROUP_ACL", false, CopyLevel.ALL), new Table("GROUPSET_ACL", false, CopyLevel.ALL), new Table("CHART_ACL", false, CopyLevel.ALL), new Table("CHTBLOCK_ACL", false, CopyLevel.ALL), new Table("CHTPANL_ACL", false, CopyLevel.ALL), new Table("CHARTCORR_ACL", false, CopyLevel.ALL), new Table("ENV_SCH_ACL", false, CopyLevel.ALL), new Table("CHRON", true, CopyLevel.SCHEMES), new Table("IGD_DICT_LSTRAT", true, CopyLevel.SCHEMES, "SELECT unit_id,sch_id,case when hier=4 then 8 when hier=3 then 5 when hier=2 then 4 when hier=1 then 2 else hier end as hier,name,abr,case when uw_age=0 and lw_age=0 then null else uw_age end as uw_age,case when ue_age=0 and le_age=0 then null else ue_age end as ue_age,case when lw_age=0 then null else lw_age end as lw_age,case when le_age=0 then null else le_age end as le_age,uw_x,ue_x,lw_x,le_x,0 as e_bnd, 0 as w_bnd,<colour_translate>,lith_id,u_bnd_int,l_bnd_int,created,creator,modified,modifier,updated,updater FROM <schema>igd_dict_lstrat"), new Table("CHTLN_UNIT_LSTRAT", false, CopyLevel.TEMPLATE), new Table("IGD_LSTRAT", true, CopyLevel.ALL, "SELECT well_id,igd_type,case when hier=4 then 8 when hier=3 then 5 when hier=2 then 4 when hier=1 then 2 else hier end as hier,top_id,base_id,top_bnd,base_bnd,sch_id,q_uzone,upp_zone,upp_inf,q_lzone,low_zone,low_inf,interp_id,sep,0 as confidence,created,creator,modified,modifier,updated,updater FROM <schema>igd_lstrat"), new Table("SRS_UNITS", true, CopyLevel.SCHEMES), new Table("SRS_ZONES", true, CopyLevel.ALL), new Table("AUDITTRAIL", false, CopyLevel.ALL), new Table("DBVERSION", false, CopyLevel.BARE_BONES), new Table("INTERVAL_LOG_DEF", false, CopyLevel.SCHEMES), new Table("INTERVAL_LOG_TRACE", false, CopyLevel.ALL, "SELECT well_id,abr,top_depth,base_depth,<colour_translate>,txt FROM <schema>interval_log_trace"), new Table("IPS_BATHY", false, CopyLevel.ALL), new Table("CHTTAG", false, CopyLevel.ALL), new Table("CABINET", false, CopyLevel.ALL), new Table("DRAWER", false, CopyLevel.ALL), new Table("SLIDEBOX", false, CopyLevel.ALL), new Table("SLIDECELL", false, CopyLevel.ALL), new Table("SPECIMEN", false, CopyLevel.ALL), new Table("PUBLICATION", false, CopyLevel.ALL), new Table("SPECIMEN_IMAGE", false, CopyLevel.ALL), new Table("CHEM_CAT", false, CopyLevel.ALL), new Table("CHEM_HDR", false, CopyLevel.ALL), new Table("CHEM_HDR_FORMULA", false, CopyLevel.ALL), new Table("CHEM_ANALY_HDR", false, CopyLevel.ALL), new Table("CHEM_ANALYSIS", false, CopyLevel.ALL), new Table("CHEM_TRACE", false, CopyLevel.ALL), new Table("CHEM_GROUP", false, CopyLevel.ALL), new Table("CHEM_GROUP_MBR", false, CopyLevel.ALL), new Table("CHT_CHEM", false, CopyLevel.ALL));

    private SBTables() {
    }

    public static List<String> tableList() {
        return TABLES.stream().map(Table::name).collect(Collectors.toList());
    }

    public static List<Boolean> selectList(CopyLevel level) {
        LinkedList<Boolean> selectors = new LinkedList<Boolean>();
        for (Table table : TABLES) {
            selectors.add(table.includeInCopy(level));
        }
        return selectors;
    }

    public static List<String> auditTables() {
        LinkedList<String> auditList = new LinkedList<String>();
        for (Table table : TABLES) {
            if (!table.hasAudit) continue;
            auditList.add(table.tableName);
        }
        return auditList;
    }

    public static Optional<String> getSelectQuery(String DBTypeName, ModelVersion version, String schema, String tableName) {
        return TABLES.stream().filter(t -> Objects.equals(t.name(), tableName)).findAny().map(t -> t.selectQuery(DBTypeName, version, StringUtils.trimToNull((String)schema))).orElseThrow(() -> new IllegalArgumentException("Table " + tableName + " not found in v3 Schema"));
    }

    public static Optional<String> getAdditionalDML(ModelVersion version, String sourceSchema, String targetSchema, String tableName) {
        return TABLES.stream().filter(t -> Objects.equals(t.name(), tableName)).findAny().map(t -> t.additionalDML(version, StringUtils.trimToNull((String)sourceSchema), StringUtils.trimToNull((String)targetSchema))).orElseThrow(() -> new IllegalArgumentException("Table " + tableName + " not found in v3 Schema"));
    }

    public static boolean isValidTableName(String tableName) {
        if (tableName.equalsIgnoreCase("SPLITID")) {
            return true;
        }
        return TABLES.stream().map(Table::name).anyMatch(name -> StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)tableName));
    }

    private static class Table {
        final String tableName;
        final String selectQuery;
        final String colourTableAlias;
        final String additionalDML;
        final boolean newInCurrentVersion;
        final boolean hasAudit;
        final CopyLevel copyLevel;

        Table(String tableName, boolean hasAudit, CopyLevel level, String selectQuery, String colourTableAlias, boolean newInCurrentVersion, String additionalDML) {
            this.tableName = tableName;
            this.selectQuery = selectQuery;
            this.colourTableAlias = colourTableAlias;
            this.newInCurrentVersion = newInCurrentVersion;
            this.additionalDML = additionalDML;
            this.hasAudit = hasAudit;
            this.copyLevel = level;
        }

        Table(String tableName, boolean hasAudit, CopyLevel level, String selectQuery) {
            this(tableName, hasAudit, level, selectQuery, null, false, null);
        }

        Table(String tableName, boolean hasAudit, CopyLevel level, String selectQuery, String colourTableAlias) {
            this(tableName, hasAudit, level, selectQuery, colourTableAlias, false, null);
        }

        Table(String tableName, boolean hasAudit, CopyLevel level, boolean newInCurrentVersion) {
            this(tableName, hasAudit, level, null, null, newInCurrentVersion, null);
        }

        Table(String tableName, boolean hasAudit, CopyLevel level) {
            this(tableName, hasAudit, level, null, null, false, null);
        }

        String name() {
            return this.tableName;
        }

        boolean includeInCopy(CopyLevel level) {
            return this.copyLevel.getLevel() <= level.getLevel();
        }

        Optional<String> selectQuery(String DBTypeName, ModelVersion version, String schema) {
            if (ModelVersion.isV2_1(version) && this.selectQuery != null) {
                return Optional.of(this.selectQuery.replace("<schema>", (CharSequence)(schema != null ? schema + "." : "")).replace("<colour_translate>", this.getColourTranslationString(DBTypeName)).replace("<colour_translate_pref>", this.getColourTranslationString(DBTypeName, "pref_value")).replace("<char>", this.getCharTypeTranslationString(DBTypeName)).replace("<true>", this.getBooleanTranslationString(DBTypeName, true)).replace("<false>", this.getBooleanTranslationString(DBTypeName, false)).replace("<nulls first>", this.getNullsTranslationString(DBTypeName)));
            }
            return Optional.ofNullable(null);
        }

        private String getColourTranslationString(String DBTypeName) {
            return this.getColourTranslationString(DBTypeName, "colour");
        }

        private String getColourTranslationString(String DBTypeName, String destinationField) {
            String alias;
            String string = alias = this.colourTableAlias != null ? this.colourTableAlias + "." : "";
            if (DBTypeName.contains("Postgre")) {
                return "case when " + alias + "red is null then null else  '#' || case when " + alias + "red=0 then '00' else to_hex(cast (" + alias + "red as int4)) end || case when " + alias + "green=0 then '00' else to_hex(cast (" + alias + "green as int4)) end || case when " + alias + "blue=0 then '00' else to_hex(cast (" + alias + "blue as int4)) end end as " + destinationField;
            }
            if (DBTypeName.contains("Access")) {
                return "'#000000' as " + destinationField;
            }
            if (DBTypeName.contains("SQL Server")) {
                return "case when " + alias + "red is null then null else  concat('#', rtrim(format (" + alias + "red, 'X2')) , rtrim(format(" + alias + "green,'X2')) , rtrim(format(" + alias + "blue,'X2'))) end as " + destinationField;
            }
            return "case when " + alias + "red is null then null else '#' || trim(to_char (" + alias + "red, '0X')) || trim(to_char(" + alias + "green,'0X')) || trim( to_char(" + alias + "blue,'0X') ) end as " + destinationField;
        }

        private String getCharTypeTranslationString(String DBTypeName) {
            if (DBTypeName.contains("Oracle")) {
                return "varchar2(4)";
            }
            return "char";
        }

        private String getBooleanTranslationString(String DBTypeName, boolean t) {
            if (DBTypeName.contains("Oracle") || DBTypeName.contains("SQL Server")) {
                return t ? "1" : "0";
            }
            return t ? "true" : "false";
        }

        private String getNullsTranslationString(String DBTypeName) {
            if (DBTypeName.contains("SQL Server")) {
                return "";
            }
            return "nulls first";
        }

        Optional<String> additionalDML(ModelVersion version, String sourceSchema, String targetSchema) {
            if (ModelVersion.isV2_1(version) && this.additionalDML != null) {
                return Optional.of(this.additionalDML.replace("<sourceSchema>", (CharSequence)(sourceSchema != null ? sourceSchema + "." : "")).replace("<targetSchema>", (CharSequence)(targetSchema != null ? targetSchema + "." : "")));
            }
            return Optional.ofNullable(null);
        }
    }

    public static enum CopyLevel {
        BARE_BONES(1, "Minimum", "Minimum database to log in and record data"),
        SCHEMES(2, "Schemes", "All IGD Schemes"),
        TAXONDICT(3, "Taxa", "Taxon dictionary, events and composite standards"),
        TEMPLATE(4, "Templates", "Block and panel templates, taxon groups and sets"),
        ALL(5, "Wells", "All data including Well/Outcrop data");

        int level;
        String descr;
        String name;

        private CopyLevel(int level, String name, String descr) {
            this.level = level;
            this.name = name;
            this.descr = descr;
        }

        public String toString() {
            return this.name;
        }

        public String getDescr() {
            return this.descr;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

