/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import util.ImageUtils;

public class PicPathImageLoader
implements ImageLoader {
    private static final Logger LOGGER = Logger.getLogger(PicPathImageLoader.class.getName());

    public Image getImage(ImageRecord ir) {
        try {
            return PicPathImageLoader.loadImageFromPicPath(ir);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error loading image from path: " + ir.picPath(), ioe);
            return null;
        }
    }

    public static Image loadImageFromPicPath(ImageRecord ir) throws IOException {
        if (!StringUtils.isBlank((CharSequence)ir.picPath()) && new File(ir.picPath()).exists()) {
            return ImageUtils.readImage((String)ir.picPath());
        }
        return null;
    }
}

