/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.OccurrenceImage;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.taxon.Taxon;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellHeader;
import model3.exception.SuppressedSQLException;
import util.SB;
import util.SBException;
import util.listener.WeakListenerList;

public class TaxonImageServiceDbImpl
implements TaxonImageService {
    private static final Logger LOGGER = Logger.getLogger(TaxonImageServiceDbImpl.class.getName());
    private final SBdb sbdb;
    private final HashMap<Integer, Integer> hasTypeImage = new HashMap();
    private WeakListenerList<TaxonImageService.TaxonImageListener> listenerList = new WeakListenerList();

    public TaxonImageServiceDbImpl(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasTypeImage(int specID) {
        if (this.hasTypeImage.containsKey(specID)) {
            if (this.hasTypeImage.get(specID) <= 0) return false;
            return true;
        }
        String sql = "SELECT count(image_set_id) AS nset FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + specID + " AND image_set_id > 0 and type='Y'";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            int nSet = 0;
            while (rs.next()) {
                nSet = rs.getInt("nset");
            }
            if (nSet > 0) {
                this.hasTypeImage.put(specID, nSet);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        TaxonImageSet unreferencedImageSet = this.getUnreferencedImageSet(specID);
        if (unreferencedImageSet != null) {
            this.hasTypeImage.merge(specID, 1, Integer::sum);
            return true;
        }
        this.hasTypeImage.put(specID, 0);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTypeImageSetID(int specID) {
        String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("TXIMAGE") + " WHERE spec_id=" + specID + " AND type='Y'";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int imageSetID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            do {
                if (!rs.next()) return 0;
            } while ((imageSetID = rs.getInt("image_set_id")) <= 0);
            int n = imageSetID;
            return n;
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
    }

    public List<TaxonImageSet> getImages(int specID) {
        LinkedList<TaxonImageSet> list = new LinkedList<TaxonImageSet>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT image_set_id, type FROM " + this.sbdb.DBTableName("TXIMAGE") + " WHERE spec_id=" + specID + " ORDER BY type DESC";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int imageSetID = rs.getInt("image_set_id");
                boolean isType = SB.getDBChar((ResultSet)rs, (String)"type") == 'Y';
                TaxonImageSet item = new TaxonImageSet(imageSetID, specID, isType);
                list.add(item);
            }
            sql = "SELECT well_id,samp_id,analy_id,image_set_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + specID + " AND image_set_id IS NOT NULL";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                int imageSetID = rs.getInt("image_set_id");
                boolean isType = false;
                try {
                    Well well = this.sbdb.getWell(wellID);
                    Sample sample = well.hasSamplesLoaded() ? well.getSample(sampID) : Sample.load(this.sbdb, wellID, sampID, well.getSectionType(), null);
                    Smpdtl smpdtl = sample.getSmpdtl(analyID);
                    if (smpdtl == null) {
                        smpdtl = new Smpdtl(this.sbdb, wellID, sample, well.getAnalystHeader(analyID, true));
                    }
                    for (TaxonImageSet twi : list) {
                        if (twi.getImageSetID() != imageSetID) continue;
                        if (twi.isType()) {
                            isType = true;
                        }
                        list.remove(twi);
                        break;
                    }
                    list.add(new OccurrenceImage(imageSetID, specID, well, sample, smpdtl, isType));
                }
                catch (SBException sbe) {
                    LOGGER.log(Level.FINE, "Error getting taxon image: ", sbe);
                }
                catch (WellHeader.MissingWellException missingWellException) {}
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        TaxonImageSet unreferencedImages = this.getUnreferencedImageSet(specID);
        if (unreferencedImages != null) {
            list.add(unreferencedImages);
        }
        TaxonImageSet slideStoreImageSet = null;
        try {
            slideStoreImageSet = this.getSlideStoreImageSet(specID);
            if (slideStoreImageSet != null) {
                list.add(slideStoreImageSet);
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public TaxonImageSet getTaxonImageSet(int imageSetID) {
        TaxonImageSet taxonImageSet = null;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT spec_id,type FROM " + this.sbdb.DBTableName("TXIMAGE") + " WHERE image_set_id=" + imageSetID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                boolean isType = SB.getDBChar((ResultSet)rs, (String)"type") == 'Y';
                taxonImageSet = new TaxonImageSet(imageSetID, specID, isType);
            }
            sql = "SELECT well_id,samp_id,analy_id,spec_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE image_set_id=" + imageSetID;
            ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs2.next()) {
                int wellID = rs2.getInt("well_id");
                int sampID = rs2.getInt("samp_id");
                int analyID = rs2.getInt("analy_id");
                int specID = rs2.getInt("spec_id");
                boolean isType = false;
                try {
                    Well well = this.sbdb.getWell(wellID);
                    Sample sample = well.hasSamplesLoaded() ? well.getSample(sampID) : Sample.load(this.sbdb, wellID, sampID, well.getSectionType(), null);
                    Smpdtl smpdtl = sample.getSmpdtl(analyID);
                    if (smpdtl == null) {
                        smpdtl = new Smpdtl(this.sbdb, wellID, sample, well.getAnalystHeader(analyID, true));
                    }
                    if (taxonImageSet != null) {
                        isType = true;
                    }
                    taxonImageSet = new OccurrenceImage(imageSetID, specID, well, sample, smpdtl, isType);
                }
                catch (SBException sbe) {
                    LOGGER.log(Level.FINE, "Error getting taxon image: ", sbe);
                }
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return taxonImageSet;
    }

    private TaxonImageSet getSlideStoreImageSet(int specID) throws SQLException {
        TaxonImageSet.SlideStoreImageSet imageSet = null;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT i.specimen_image_id, i.comments, s.specimen_id, s.slidecell_id FROM " + this.sbdb.DBTableName("SPECIMEN_IMAGE") + " i LEFT JOIN " + this.sbdb.DBTableName("SPECIMEN") + " s ON i.specimen_id = s.specimen_id WHERE s.spec_id=" + specID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                if (imageSet == null) {
                    imageSet = new TaxonImageSet.SlideStoreImageSet(specID);
                }
                int specimenImageID = rs.getInt("specimen_image_id");
                String caption = rs.getString("comments");
                int specimenID = rs.getInt("specimen_id");
                int slideCellID = rs.getInt("slidecell_id");
                imageSet.addSlideStoreImageRecord(new TaxonImageSet.SlideStoreImageSet.SlideStoreImageRecord(specimenImageID, caption, specimenID, slideCellID));
            }
        }
        return imageSet;
    }

    private TaxonImageSet getUnreferencedImageSet(int specID) {
        String imageFolder;
        try {
            imageFolder = this.sbdb.getImageFolder();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.WARNING, "Error getting preference for unreferenced images folder", ex);
            return null;
        }
        if (imageFolder == null) {
            return null;
        }
        Taxon taxon = this.sbdb.getTaxonService().findTaxon(specID).orElse(null);
        if (taxon == null) {
            LOGGER.log(Level.WARNING, "Can't get unreferenced images, no taxon found with ID " + specID);
            return null;
        }
        String imgPrefix = TaxonImageServiceDbImpl.subsFileNameChars(taxon.toString(false, false));
        File dir = new File(imageFolder);
        if (!dir.exists()) {
            throw new IllegalStateException("Specified image folder '" + dir.getPath() + "' does not exist.\nSet image storage option in Control Panel config menu.");
        }
        File[] files = dir.listFiles();
        ArrayList<ImageRecord> imageRecords = new ArrayList<ImageRecord>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getPath().toLowerCase().startsWith((imageFolder + "\\" + imgPrefix + "_").toLowerCase())) continue;
            imageRecords.add(new ImageRecord(i, files[i].getPath(), files[i].getPath()));
        }
        if (!imageRecords.isEmpty()) {
            return new TaxonImageSet.Unreferenced(specID, imageRecords);
        }
        return null;
    }

    private static String subsFileNameChars(String name) {
        char[] ILLEGAL_CHARACTERS = new char[]{'/', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
        Object newName = "";
        for (int n : name.toCharArray()) {
            for (char ill : ILLEGAL_CHARACTERS) {
                if (ill != n) continue;
                n = ill == '\"' ? 39 : 45;
                break;
            }
            newName = (String)newName + (char)n;
        }
        return newName;
    }

    public void setTaxonImageSetType(int specID, TaxonImageSet imageSet, boolean isType) {
        if (imageSet.getImageSetID() == 0) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("TXIMAGE") + " WHERE image_set_id=" + imageSet.getImageSetID();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            boolean exists = rs.next();
            boolean update = false;
            if (!exists && isType) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("TXIMAGE") + " (spec_id, image_set_id, type) VALUES (" + specID + "," + imageSet.getImageSetID() + ",'Y')";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            } else if (exists && isType || !exists && !isType) {
                update = true;
            } else if (exists && !isType) {
                sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE image_set_id=" + imageSet.getImageSetID();
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    sql = "DELETE FROM " + this.sbdb.DBTableName("TXIMAGE") + " WHERE image_set_id=" + imageSet.getImageSetID();
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                } else {
                    update = true;
                }
            }
            if (update) {
                sql = "UPDATE " + this.sbdb.DBTableName("TXIMAGE") + " SET type='" + (isType ? "Y" : "N") + "' WHERE spec_id=" + specID + " AND image_set_id=" + imageSet.getImageSetID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.sbdb.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error setting type image", e, this.sbdb);
        }
        imageSet.setType(isType);
        if (this.hasTypeImage.containsKey(specID)) {
            int previousValue = this.hasTypeImage.get(specID);
            this.hasTypeImage.put(specID, isType ? previousValue + 1 : (previousValue > 0 ? previousValue - 1 : 0));
        } else if (isType) {
            this.hasTypeImage.put(specID, 1);
        }
        this.notifyListeners(specID);
    }

    public void addTaxonImageSet(int specID, TaxonImageSet taxonImageSet) {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("TXIMAGE") + " (spec_id,image_set_id,type) VALUES (" + specID + "," + taxonImageSet.getImageSetID() + "," + (taxonImageSet.isType() ? "'Y'" : "'N'") + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.sbdb.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error storing taxon image row", e, this.sbdb);
        }
        this.notifyListeners(specID);
    }

    public void deleteTaxonImageSet(int specID, TaxonImageSet imageSet) {
        this.hasTypeImage.computeIfPresent(specID, (mapKey, previousValue) -> imageSet.isType() ? previousValue - 1 : previousValue);
        this.notifyListeners(specID);
    }

    public void addListener(TaxonImageService.TaxonImageListener l) {
        this.listenerList.addListener((Object)l);
    }

    public void removeListener(TaxonImageService.TaxonImageListener l) {
        this.listenerList.deleteListener((Object)l);
    }

    public void notifyListeners(int specID) {
        this.listenerList.stream().forEach(l -> l.imagesForTaxonUpdated(specID));
    }
}

