/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.stratadata.model3.well.curve.WitsmlCurveHeader;
import com.stratadata.util.depth.DepthUnits;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model3.ConnectionProvider;
import model3.exception.SuppressedSQLException;
import util.listener.WeakListenerList;

public class WitsmlCurveHeaderService {
    private final ConnectionProvider db;
    private final int wellID;
    private final Map<Integer, WitsmlCurveHeader> curves = new HashMap<Integer, WitsmlCurveHeader>();
    private WeakListenerList<Listener> listeners = new WeakListenerList();

    public void addListener(Listener l) {
        this.listeners.addListener((Object)l);
    }

    public WitsmlCurveHeaderService(ConnectionProvider db, int wellID) throws SQLException {
        this.db = db;
        this.wellID = wellID;
        this.load();
    }

    private void load() throws SQLException {
        String sql = "SELECT CURVE_ID, ws_id, well_uid, wellbore_uid, log_uid, mnemonic, abr, units FROM " + this.db.DBTableName("WITSML_CURVE") + " WHERE well_id=" + this.wellID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int curveID = rs.getInt("CURVE_ID");
                int serverID = rs.getInt("ws_id");
                String well_UID = rs.getString("well_uid");
                String wellBore_UID = rs.getString("wellbore_uid");
                String log_UID = rs.getString("log_uid");
                String mnemonic = rs.getString("mnemonic");
                String abr = rs.getString("abr");
                char units = rs.getString("units").charAt(0);
                this.curves.put(curveID, new WitsmlCurveHeader(curveID, this.wellID, serverID, well_UID, wellBore_UID, log_UID, mnemonic, abr, DepthUnits.getUnits((char)units)));
            }
        }
    }

    public int getWellID() {
        return this.wellID;
    }

    public int getCurveCount() {
        return this.curves.size();
    }

    public List<WitsmlCurveHeader> getWitsmlCurveHeaders() {
        return new ArrayList<WitsmlCurveHeader>(this.curves.values());
    }

    public void storeWitsmlCurveHeaders(List<WitsmlCurveHeader> curveHeaders) {
        String deleteSQL = "DELETE FROM " + this.db.DBTableName("WITSML_CURVE") + " WHERE WELL_ID=" + this.wellID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            stmt.executeUpdate(deleteSQL);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error deleting WITSML curves", e, this.db);
        }
        HashMap<Integer, WitsmlCurveHeader> newCurves = new HashMap<Integer, WitsmlCurveHeader>();
        String sql = "INSERT INTO " + this.db.DBTableName("WITSML_CURVE") + " (curve_id,well_id,ws_id,well_uid,wellbore_uid,log_uid,mnemonic,abr,units) VALUES (?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement pStmt = this.db.getDatabase().prepareStatement(this.db.modQuery(sql));){
            for (WitsmlCurveHeader curveHeader : curveHeaders) {
                if (curveHeader.curveID() == 0) {
                    int curveID = this.db.nextControl("WITSML_CURVE", "CURVE_ID");
                    curveHeader = new WitsmlCurveHeader(curveID, this.wellID, curveHeader.serverID(), curveHeader.well_UID(), curveHeader.wellBore_UID(), curveHeader.log_UID(), curveHeader.mnemonic(), curveHeader.abr(), curveHeader.units());
                }
                pStmt.setInt(1, curveHeader.curveID());
                pStmt.setInt(2, this.wellID);
                pStmt.setInt(3, curveHeader.serverID());
                pStmt.setString(4, curveHeader.well_UID());
                pStmt.setString(5, curveHeader.wellBore_UID());
                pStmt.setString(6, curveHeader.log_UID());
                pStmt.setString(7, curveHeader.mnemonic());
                pStmt.setString(8, curveHeader.abr());
                pStmt.setString(9, curveHeader.units().name());
                pStmt.executeUpdate();
                newCurves.put(curveHeader.curveID(), curveHeader);
            }
            this.db.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error storing WITSML curves", e, this.db);
        }
        this.curves.clear();
        for (WitsmlCurveHeader h : newCurves.values()) {
            this.curves.put(h.curveID(), h);
        }
        this.listeners.stream().forEach(Listener::curveHeadersUpdated);
    }

    public void deleteWitsmlCurveHeaders(List<WitsmlCurveHeader> toDelete) {
        if (toDelete.isEmpty()) {
            return;
        }
        String deleteSQL = "DELETE FROM " + this.db.DBTableName("WITSML_CURVE") + " WHERE CURVE_ID=?";
        try (PreparedStatement pStmt = this.db.getDatabase().prepareStatement(deleteSQL);){
            for (WitsmlCurveHeader header : toDelete) {
                pStmt.setInt(1, header.curveID());
                pStmt.execute();
            }
            this.db.commit();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withRollback("Error deleting WITSML curves", e, this.db);
        }
        for (WitsmlCurveHeader header : toDelete) {
            this.curves.remove(header.curveID());
        }
        this.listeners.stream().forEach(Listener::curveHeadersUpdated);
    }

    public static interface Listener {
        public void curveHeadersUpdated();
    }
}

