/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.external.WebServiceDescriptionService;
import com.stratadata.model3.external.WebServices;
import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.WellCurveService;
import com.stratadata.model3.well.curve.WitsmlCurveHeader;
import com.stratadata.model3.well.curve.WitsmlCurveHeaderService;
import com.stratadata.model3.well.curve.WitsmlException;
import com.stratadata.model3.well.curve.WitsmlHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import util.listener.WeakListenerList;

public class WitsmlCurveService
implements WellCurveService,
WitsmlCurveHeaderService.Listener {
    private static final Logger LOGGER = Logger.getLogger(WitsmlCurveService.class.getName());
    private final int wellID;
    private final WitsmlCurveHeaderService curveHeaderService;
    private final WebServiceDescriptionService wsService;
    private final Map<Integer, Curve> curves = new HashMap<Integer, Curve>();
    private WitsmlException cachedException;
    private final WeakListenerList<WellCurveService.Listener> listenerList = new WeakListenerList();

    public WitsmlCurveService(int wellID, WitsmlCurveHeaderService curveHeaderService, WebServiceDescriptionService wsService) {
        this.wellID = wellID;
        this.curveHeaderService = curveHeaderService;
        if (curveHeaderService.getWellID() != wellID) {
            throw new IllegalStateException("WellID mismatch in WitsmlCurveService init");
        }
        curveHeaderService.addListener(this);
        this.wsService = wsService;
        this.initCurves();
    }

    private void initCurves() {
        List<WitsmlCurveHeader> witsmlCurveHeaders = this.curveHeaderService.getWitsmlCurveHeaders();
        if (witsmlCurveHeaders.isEmpty()) {
            return;
        }
        int serverID = witsmlCurveHeaders.get(0).serverID();
        WebServiceDescription serviceDescription = (WebServiceDescription)this.wsService.getServiceDescription(serverID).orElseThrow(() -> new RuntimeException("WITSML web service with ID " + serverID + " not found"));
        WitsmlHandler witsml = new WitsmlHandler(serviceDescription);
        witsml.setCredentials(WebServices.getCredentials(serviceDescription));
        try {
            List<Curve> curveList = witsml.getCurves(witsmlCurveHeaders);
            this.curves.clear();
            for (Curve curve : curveList) {
                this.curves.put(curve.getID(), curve);
            }
            LOGGER.log(Level.INFO, "Initialised " + this.curves.size() + " curves");
            this.cachedException = null;
        }
        catch (WitsmlException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage());
            this.curves.clear();
            this.cachedException = ex;
        }
    }

    public WitsmlException getServerException() {
        return this.cachedException;
    }

    @Override
    public void curveHeadersUpdated() {
        this.initCurves();
    }

    public int getWellID() {
        return this.wellID;
    }

    public int getCurveCount() {
        return (int)this.curves.values().stream().filter(Curve::isActive).count();
    }

    public List<Curve> getCurves(boolean activeOnly) {
        return this.curves.values().stream().filter(activeOnly ? Curve::isActive : curve -> true).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<Curve> getCurves(String abr) {
        return this.curves.values().stream().filter(curve -> curve.isActive() && curve.getAbr().equals(abr)).toList();
    }

    public void refresh() {
        this.initCurves();
    }

    public void addListener(WellCurveService.Listener l) {
        this.listenerList.addListener((Object)l);
    }

    public void deleteListener(WellCurveService.Listener l) {
        this.listenerList.deleteListener((Object)l);
    }

    public Stream<WellCurveService.Listener> getListeners() {
        return this.listenerList.stream();
    }
}

