/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.curve;

import com.hashmapinc.tempus.WitsmlObjects.Util.WitsmlMarshal;
import com.hashmapinc.tempus.WitsmlObjects.v1411.CsLogCurveInfo;
import com.hashmapinc.tempus.WitsmlObjects.v1411.CsLogData;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjLog;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjLogs;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjWell;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjWellbore;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjWellbores;
import com.hashmapinc.tempus.WitsmlObjects.v1411.ObjWells;
import com.stratadata.model3.external.SimpleLoginCredentials;
import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.external.WebServiceType;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.WitsmlCurveHeader;
import com.stratadata.model3.well.curve.WitsmlException;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class WitsmlHandler {
    private static final Logger LOGGER = Logger.getLogger(WitsmlHandler.class.getName());
    private static final String NAMESPACE = "xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\"";
    private final WebServiceDescription serviceDescription;
    private SimpleLoginCredentials credentials;

    public WitsmlHandler(WebServiceDescription serviceDescription) {
        this.serviceDescription = Objects.requireNonNull(serviceDescription);
        if (serviceDescription.URL() == null) {
            throw new IllegalArgumentException("Will not be able to connect to WITSML server with null URL");
        }
        if (serviceDescription.type() != WebServiceType.WITSML) {
            LOGGER.warning("Attempt to create WITSML connection using service description with type " + String.valueOf(serviceDescription.type()) + ", this is unlikely to succeed");
        }
    }

    public void setCredentials(SimpleLoginCredentials credentials) {
        this.credentials = credentials;
    }

    public boolean hasCredentials() {
        return this.credentials != null;
    }

    public WebServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    private String getResponse(String query, String returnElements) throws WitsmlException {
        int responseCode = 0;
        String responseMessage = null;
        try {
            String responseString;
            URL url = new URL(this.serviceDescription.URL());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(false);
            if (this.serviceDescription.requiresCredentials() && this.credentials != null) {
                String auth = this.credentials.username() + ":" + this.credentials.password();
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
                String authHeaderValue = "Basic " + new String(encodedAuth);
                connection.setRequestProperty("Authorization", authHeaderValue);
            }
            connection.setRequestProperty("Content-Type", "application/xml");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            query = StringEscapeUtils.escapeXml11((String)query);
            String SOAPquery = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns=\"http://www.witsml.org/message/120\">\n  <soapenv:Header/>\n  <soapenv:Body>\n     <ns:WMLS_GetFromStore soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n       <WMLtypeIn xsi:type=\"xsd:string\">wells</WMLtypeIn>\n       <QueryIn xsi:type=\"xsd:string\">\n" + query + "</QueryIn><OptionsIn xsi:type=\"xsd:string\">returnElements=" + returnElements + "</OptionsIn>        <CapabilitiesIn xsi:type=\"xsd:string\"></CapabilitiesIn>\n      </ns:WMLS_GetFromStore>\n   </soapenv:Body>\n </soapenv:Envelope>\n";
            LOGGER.log(Level.FINE, "SOAP Query: {0}", SOAPquery);
            try (OutputStream os = connection.getOutputStream();){
                os.write(SOAPquery.getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            responseCode = connection.getResponseCode();
            responseMessage = connection.getResponseMessage();
            LOGGER.log(Level.INFO, "WITSML Response: {0}/{1}", new String[]{"" + responseCode, responseMessage});
            try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(connection.getInputStream()), StandardCharsets.UTF_8));){
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build((Reader)input);
                Element root = document.getRootElement();
                List responseList = root.getChildren();
                responseString = null;
                for (Element el : responseList) {
                    for (Element child : el.getChildren()) {
                        if (!child.getName().equals("WMLS_GetFromStoreResponse")) continue;
                        int result = Integer.parseInt(child.getChildTextNormalize("Result"));
                        if (result == 1) {
                            responseString = child.getChildTextNormalize("XMLout");
                            if (responseString != null && !responseString.isBlank()) continue;
                            throw new WitsmlException(connection.getResponseCode(), connection.getResponseMessage(), "WITSML server returned empty response");
                        }
                        throw new WitsmlException(connection.getResponseCode(), connection.getResponseMessage(), "WITSML query returned result code " + result);
                    }
                }
            }
            connection.disconnect();
            return responseString;
        }
        catch (IOException | JDOMException e) {
            throw new WitsmlException(responseCode, responseMessage, e);
        }
    }

    public List<WitsmlWellObj> getWitsmlWells() throws WitsmlException {
        String response = this.getResponse(WitsmlHandler.allWellsQuery(), "id-only");
        LinkedList<WitsmlWellObj> wells = new LinkedList<WitsmlWellObj>();
        try {
            ObjWells obj1411 = (ObjWells)WitsmlMarshal.deserialize((String)response, ObjWells.class);
            for (ObjWell objWell : obj1411.getWell()) {
                LOGGER.log(Level.FINE, "Well name in log read is: {0}, uid: {1}, Country: {2}", new Object[]{objWell.getName(), objWell.getUid(), objWell.getCountry()});
                wells.add(new WitsmlWellObj(objWell));
            }
        }
        catch (JAXBException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return wells;
    }

    public List<WitsmlWellboreObj> getWitsmlWellbores(WitsmlWellObj witsmlWell) throws WitsmlException {
        String response = this.getResponse(WitsmlHandler.allWellBoresQuery(witsmlWell.well.getUid()), "id-only");
        LinkedList<WitsmlWellboreObj> wellbores = new LinkedList<WitsmlWellboreObj>();
        try {
            ObjWellbores obj1411 = (ObjWellbores)WitsmlMarshal.deserialize((String)response, ObjWellbores.class);
            for (ObjWellbore objWellbore : obj1411.getWellbore()) {
                LOGGER.log(Level.FINE, "Well bore name in log read is: {0}, uid: {1}", new Object[]{objWellbore.getName(), objWellbore.getUid()});
                wellbores.add(new WitsmlWellboreObj(objWellbore));
            }
        }
        catch (JAXBException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return wellbores;
    }

    public List<WitsmlLogObj> getWitsmlLogs(WitsmlWellboreObj witsmlWellbore) throws WitsmlException {
        String response = this.getResponse(WitsmlHandler.allLogsQuery(witsmlWellbore.wellbore.getUidWell(), witsmlWellbore.wellbore.getUid()), "header-only");
        LinkedList<WitsmlLogObj> logs = new LinkedList<WitsmlLogObj>();
        try {
            ObjLogs obj1411 = (ObjLogs)WitsmlMarshal.deserialize((String)response, ObjLogs.class);
            for (ObjLog objLog : obj1411.getLog()) {
                LOGGER.log(Level.FINE, "Log read is: {0}, uid: {1}", new Object[]{objLog.getName(), objLog.getUid()});
                for (CsLogCurveInfo csLogCurveInfo : objLog.getLogCurveInfo()) {
                    LOGGER.log(Level.FINE, "\tMnemonic: " + (csLogCurveInfo.getMnemonic() == null ? "NULL" : csLogCurveInfo.getMnemonic().getValue()) + "\tUnits: " + csLogCurveInfo.getUnit() + "\tMin: " + String.valueOf(csLogCurveInfo.getMinIndex() == null ? "" : csLogCurveInfo.getMinIndex().getValue()) + "\tMax: " + String.valueOf(csLogCurveInfo.getMaxIndex() == null ? "" : csLogCurveInfo.getMaxIndex().getValue()) + "\tDesc: " + csLogCurveInfo.getCurveDescription() + "\tType: " + csLogCurveInfo.getTypeLogData());
                }
                logs.add(new WitsmlLogObj(objLog));
            }
        }
        catch (JAXBException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return logs;
    }

    public List<Curve> getCurves(List<WitsmlCurveHeader> witsmlCurveHeaders) throws WitsmlException {
        witsmlCurveHeaders.sort(Comparator.comparing(WitsmlCurveHeader::abr, Comparator.nullsFirst(Comparator.naturalOrder())));
        String mnemonics = witsmlCurveHeaders.stream().map(WitsmlCurveHeader::mnemonic).collect(Collectors.joining(","));
        WitsmlCurveHeader h = witsmlCurveHeaders.get(0);
        String response = this.getResponse(WitsmlHandler.logCurvesQuery(h.well_UID(), h.wellBore_UID(), h.log_UID(), mnemonics), "data-only");
        Map<String, List<Curve.CurveValue>> traces = this.parseLogsResponse(response);
        LinkedList<Curve> curves = new LinkedList<Curve>();
        for (Map.Entry<String, List<Curve.CurveValue>> trace : traces.entrySet()) {
            String mnemonic = trace.getKey();
            WitsmlCurveHeader header = witsmlCurveHeaders.stream().filter(ch -> ch.mnemonic().equals(mnemonic)).findFirst().orElseThrow();
            List<Curve.CurveValue> curveValues = trace.getValue();
            if (header.units() != DepthUnits.M) {
                curveValues = curveValues.stream().map(cv -> new Curve.CurveValue(DepthUtils.convToM((double)cv.depth(), (DepthUnits)header.units(), (SectionType)SectionType.WELL), cv.value())).toList();
            }
            curves.add(new Curve(header.curveID(), curveValues, header.abr(), mnemonic, null, null, null));
        }
        return curves;
    }

    private Map<String, List<Curve.CurveValue>> parseLogsResponse(String response) throws WitsmlException {
        ObjLogs objLogs;
        try {
            objLogs = (ObjLogs)WitsmlMarshal.deserialize((String)response, ObjLogs.class);
        }
        catch (JAXBException ex) {
            throw new WitsmlException(200, null, ex);
        }
        Map<String, List<Curve.CurveValue>> traces = null;
        for (ObjLog objLog : objLogs.getLog()) {
            Iterator iterator = objLog.getLogData().iterator();
            if (!iterator.hasNext()) continue;
            CsLogData csLogData = (CsLogData)iterator.next();
            traces = this.parseTraces(csLogData, objLog.getNullValue());
        }
        return traces;
    }

    private Map<String, List<Curve.CurveValue>> parseTraces(CsLogData csLogData, String nullValue) {
        LOGGER.log(Level.FINE, "Log mnemonic list is: " + csLogData.getMnemonicList());
        String[] mnemonics = csLogData.getMnemonicList().split(",");
        List[] traces = new List[mnemonics.length - 1];
        for (int i = 0; i < traces.length; ++i) {
            traces[i] = new LinkedList();
        }
        for (String logString : csLogData.getData()) {
            double depth;
            String[] arr = logString.split(",", -1);
            try {
                depth = Double.parseDouble(arr[0]);
            }
            catch (NumberFormatException pe) {
                System.out.println("Error parsing depth: " + String.valueOf(pe));
                continue;
            }
            for (int i = 1; i < arr.length; ++i) {
                try {
                    String valueString = arr[i];
                    if (valueString.isBlank() || StringUtils.equals((CharSequence)nullValue, (CharSequence)valueString)) continue;
                    double value = Double.parseDouble(valueString);
                    traces[i - 1].add(new Curve.CurveValue(depth, value));
                    continue;
                }
                catch (NumberFormatException pe) {
                    LOGGER.log(Level.FINE, "Error parsing value at depth " + depth + " : " + pe.getMessage());
                }
            }
        }
        HashMap<String, List<Curve.CurveValue>> traceMap = new HashMap<String, List<Curve.CurveValue>>();
        for (int i = 1; i < mnemonics.length; ++i) {
            traceMap.put(mnemonics[i], traces[i - 1]);
        }
        return traceMap;
    }

    public static String allWellsQuery() {
        return "<wells xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\">    <well>\n        <name/>\n        <country/>\n    </well>\n</wells>\n";
    }

    private static String allWellInfoQuery(String wellUid) {
        return "<wells xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\"> <well uid=\"" + wellUid + "\"/> </wells>";
    }

    private static String allWellBoresQuery() {
        return "<wells xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\">    <wellbore uidWell=\"\" uid=\"\">\n    </wellbore>\n</wellbores>\n";
    }

    private static String allWellBoresQuery(String wellUid) {
        return "<wellbores xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\"> <wellbore uidWell=\"" + wellUid + "\" /></wellbores>";
    }

    private static String allLogsQuery(String uidWell, String uidWellbore) {
        return "<logs xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\"> <log uidWell=\"" + uidWell + "\" uidWellbore=\"" + uidWellbore + "\"></log></logs>";
    }

    private static String logCurvesQuery(String uidWell, String uidWellbore, String uidLog, String curveMnemonics) {
        return "<logs xmlns=\"http://www.witsml.org/schemas/1series\" version=\"1.4.1.1\"> <log uidWell=\"" + uidWell + "\" uidWellbore=\"" + uidWellbore + "\" uid=\"" + uidLog + "\"><logData><mnemonicList>" + curveMnemonics + "</mnemonicList></logData></log></logs>";
    }

    public static class WitsmlWellObj {
        private final ObjWell well;

        private WitsmlWellObj(ObjWell well) {
            this.well = well;
        }

        public String toString() {
            return this.well.getName();
        }

        public String getUid() {
            return this.well.getUid();
        }

        public boolean matchesWellHeader(String wellCode, String wellName, String wellAltName) {
            return StringUtils.equals((CharSequence)wellCode, (CharSequence)this.well.getNumAPI()) || StringUtils.equalsIgnoreCase((CharSequence)wellName, (CharSequence)this.well.getName()) || StringUtils.equalsIgnoreCase((CharSequence)wellAltName, (CharSequence)this.well.getName());
        }
    }

    public static class WitsmlWellboreObj {
        final ObjWellbore wellbore;

        private WitsmlWellboreObj(ObjWellbore wellbore) {
            this.wellbore = wellbore;
        }

        public String toString() {
            return this.wellbore.getName();
        }

        public String getUid() {
            return this.wellbore.getUid();
        }

        public boolean matchesWellHeader(String wellName, String wellAltName) {
            return StringUtils.equalsIgnoreCase((CharSequence)wellName, (CharSequence)this.wellbore.getName()) || StringUtils.equalsIgnoreCase((CharSequence)wellAltName, (CharSequence)this.wellbore.getName());
        }
    }

    public static class WitsmlLogObj {
        private final ObjLog log;

        private WitsmlLogObj(ObjLog log) {
            this.log = log;
        }

        public String toString() {
            return this.log.getName();
        }

        public String getUid() {
            return this.log.getUid();
        }

        public String getWellboreUid() {
            return this.log.getUidWellbore();
        }

        public String getWellUid() {
            return this.log.getUidWell();
        }

        public List<WitsmlLogCurveInfo> getLogCurveInfo() {
            return this.log.getLogCurveInfo().stream().map(i -> new WitsmlLogCurveInfo(i.getMnemonic().getValue(), i.getMnemAlias() == null ? "" : i.getMnemAlias().getValue(), i.getUnit(), i.getMinIndex() == null ? null : i.getMinIndex().getValue(), i.getMaxIndex() == null ? null : i.getMaxIndex().getValue(), i.getCurveDescription() == null ? "" : i.getCurveDescription(), i.getTypeLogData())).toList();
        }
    }

    public record WitsmlLogCurveInfo(String mnemonic, String mnemonicAlias, String unit, Double min, Double max, String descr, String type) {
        public String getMnemWithAlias() {
            return (this.mnemonic != null ? this.mnemonic() : "") + (String)(!this.mnemonicAlias.isEmpty() ? "/" + this.mnemonicAlias : "");
        }
    }
}

