/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.ws;

import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageRecordServiceImpl;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageServiceImpl;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SynonymScheme;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.SynonymServiceImpl;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.taxon.TaxonServiceImpl;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.user.UserServiceImpl;
import com.stratadata.model3.ws.XmlWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import model3.SBdb;
import util.SBException;

public class Workspace
extends SBdb {
    private UserService userService = new UserServiceImpl();
    private TaxonServiceImpl taxonService = new TaxonServiceImpl();
    private SynonymServiceImpl synonymService = new SynonymServiceImpl();
    private HashMap<Integer, SynonymScheme> synonymSchemes = new HashMap();
    private ImageRecordService imageRecordService = new ImageRecordServiceImpl();
    private TaxonImageService taxonImageService = new TaxonImageServiceImpl();

    @Override
    public UserService getUserService() {
        return this.userService;
    }

    @Override
    public CategoryService getCategoryService() {
        return this.taxonService;
    }

    @Override
    public GenusService getGenusService() {
        return this.taxonService;
    }

    @Override
    public TaxonService getTaxonService() {
        return this.taxonService;
    }

    @Override
    public SynonymService getSynonymService() {
        return this.synonymService;
    }

    public void addSynonymScheme(SynonymScheme scheme) {
        this.synonymSchemes.put(scheme.getSchID(), scheme);
    }

    @Override
    public ImageRecordService getImageRecordService() {
        return this.imageRecordService;
    }

    @Override
    public TaxonImageService getTaxonImageService() {
        return this.taxonImageService;
    }

    @Override
    public void writeXML(BufferedWriter out, Set<Integer> dataTypes, SBdb db, List<File> files, boolean closeFile, boolean includeTaxonReferences) throws IOException, SQLException, SBException {
        Logger.getLogger(Workspace.class.getName()).info("Exporting using domain workspace");
        XmlWriter.writeXMLHeader(out, db.getLicenceCustomer());
        if (this.taxonService.getTaxonCount() > 0) {
            XmlWriter.writeTaxonList(out, 1, this.taxonService.getAllTaxa(), Collections.EMPTY_LIST, this.taxonImageService, this.imageRecordService, this.getImageLoader(), files);
        }
        XmlWriter.writeSynonymy(out, 1, (SynonymService)this.synonymService, (TaxonService)this.taxonService);
        if (closeFile) {
            out.write("</StrataBugs>\n");
            out.flush();
            out.close();
        }
    }
}

