/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.ws;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.user.User;
import com.stratadata.model3.ws.SBdm;
import java.util.List;

public class WorkspaceExportHelper {
    private final SBdm sourceModel;
    private final SBdm targetModel;
    private Boolean copyTaxonTypeImages = null;
    private Runnable requestTaxonImageOption;
    private Boolean copyReferencesAndNotes = null;
    private Runnable requestReferencesAndNotesOption;

    public WorkspaceExportHelper(SBdm sourceModel, SBdm targetModel) {
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    public void setRequestTaxonImageOption(Runnable requestTaxonImageOption) {
        this.requestTaxonImageOption = requestTaxonImageOption;
    }

    public void setCopyTaxonTypeImages(boolean copyTaxonTypeImages) {
        this.copyTaxonTypeImages = copyTaxonTypeImages;
    }

    public void setRequestReferencesAndNotesOption(Runnable requestReferencesAndNotesOption) {
        this.requestReferencesAndNotesOption = requestReferencesAndNotesOption;
    }

    public void setCopyReferencesAndNotes(boolean copyReferencesAndNotes) {
        this.copyReferencesAndNotes = copyReferencesAndNotes;
    }

    public void fillTaxonList(List<Taxon> sourceTaxa, int synSchID) {
        if (synSchID > 0) {
            this.targetModel.getSynonymService().setSchemeName(synSchID, this.sourceModel.getSynonymService().getSchemeName(synSchID));
        }
        for (Taxon sourceTaxon : sourceTaxa) {
            this.fillTaxon(sourceTaxon);
            if (synSchID <= 0) continue;
            this.sourceModel.getSynonymService().getPreferredTerm(synSchID, sourceTaxon.getSpecID(), this.sourceModel.getTaxonService()).ifPresent(preferredTerm -> {
                this.fillTaxon((Taxon)preferredTerm);
                this.targetModel.getSynonymService().addSynonym(synSchID, sourceTaxon.getSpecID(), preferredTerm.getSpecID());
            });
        }
    }

    private void fillTaxon(Taxon sourceTaxon) {
        int typeImageSetID;
        int specID = sourceTaxon.getSpecID();
        if (this.targetModel.getTaxonService().findTaxon(specID).isEmpty()) {
            Taxon targetTaxon = Taxon.copy((Taxon)sourceTaxon);
            if (sourceTaxon.hasReferencesOrNotes()) {
                if (this.copyReferencesAndNotes == null) {
                    if (this.requestReferencesAndNotesOption != null) {
                        this.requestReferencesAndNotesOption.run();
                    }
                    if (this.copyReferencesAndNotes == null) {
                        this.copyReferencesAndNotes = true;
                    }
                }
                if (!this.copyReferencesAndNotes.booleanValue()) {
                    targetTaxon.setReference(null);
                    targetTaxon.setNotes(null);
                    targetTaxon.setUrl(null);
                }
            }
            this.targetModel.getTaxonService().addTaxon(targetTaxon);
        }
        if (this.copyTaxonTypeImages == null) {
            if (this.requestTaxonImageOption != null) {
                this.requestTaxonImageOption.run();
            }
            if (this.copyTaxonTypeImages == null) {
                this.copyTaxonTypeImages = true;
            }
        }
        if (this.copyTaxonTypeImages.booleanValue() && (typeImageSetID = this.sourceModel.getTaxonImageService().getTypeImageSetID(specID)) > 0 && !this.targetModel.getTaxonImageService().hasTypeImage(specID)) {
            List imageRecords = this.sourceModel.getImageRecordService().getImageRecords(typeImageSetID);
            this.targetModel.getImageRecordService().storeImageSet(typeImageSetID, imageRecords, this.sourceModel.getImageLoader());
            this.targetModel.getTaxonImageService().addTaxonImageSet(specID, new TaxonImageSet(typeImageSetID, specID, true));
        }
    }

    private void fillAudit(Audit sourceAudit) {
        List<User> users = List.of((User)this.sourceModel.getUserService().findUser(sourceAudit.getCreatorID()).get(), (User)this.sourceModel.getUserService().findUser(sourceAudit.getModifierID()).get(), (User)this.sourceModel.getUserService().findUser(sourceAudit.getUpdaterID()).get());
        users.forEach(user -> {
            if (this.targetModel.getUserService().findUser(user.getUserID()).isEmpty()) {
                this.targetModel.getUserService().addUser(User.copy((User)user));
            }
        });
    }
}

