/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.ws;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageUtils;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.ws.LicenseCustomer;
import com.stratadata.util.DateUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import util.SB;

public class XmlWriter {
    private static Logger LOGGER = Logger.getLogger(XmlWriter.class.getName());
    public static final int INDENT_SIZE = 3;
    private static final String INDENT = "   ";

    public static String getIndentString(int level) {
        return StringUtils.repeat((char)' ', (int)(level * 3));
    }

    public static void writeImageSetXML(BufferedWriter out, String ind, List<File> files, boolean writeSetWrapper, int imageSetID, ImageRecordService imageRecordService, ImageLoader imageLoader) throws IOException {
        boolean imageWritten = false;
        String ind2 = SB.getXMLIndent((int)(ind.length() + 3));
        String ind3 = SB.getXMLIndent((int)(ind2.length() + 3));
        List imageRecords = imageRecordService.getImageRecords(imageSetID);
        for (ImageRecord imageRecord : imageRecords) {
            if (writeSetWrapper && !imageWritten) {
                out.write(ind + "<ImageSet>\r\n");
                imageWritten = true;
            }
            out.write(ind2 + "<Image>\r\n");
            ArrayList<String> imageLines = new ArrayList<String>();
            File file = XmlWriter.writeImage(imageRecord, imageLoader, imageLines);
            XmlWriter.writeLines(out, ind3, imageLines);
            if (file != null) {
                files.add(file);
            }
            out.write(ind2 + "</Image>\r\n");
        }
        if (writeSetWrapper && imageWritten) {
            out.write(ind + "</ImageSet>\r\n");
        }
    }

    private static File writeImage(ImageRecord imageRecord, ImageLoader imageLoader, List<String> imageLines) throws IOException {
        File tempFile = File.createTempFile("SBImage" + imageRecord.imageID() + "-", ".jpg");
        System.out.println("Writing image to file: " + tempFile.getAbsolutePath());
        Image img = imageLoader.getImage(imageRecord);
        BufferedImage bi = ImageUtils.convertImageToBufferedImage((Image)img);
        if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            LOGGER.warning("Failed to load/write image: ImageID=" + imageRecord.imageID());
            return null;
        }
        imageLines.add(XmlWriter.xmlLine("ImageID", String.valueOf(imageRecord.imageID())));
        ImageIO.write((RenderedImage)bi, "jpg", tempFile);
        imageLines.add(XmlWriter.xmlLine("File", tempFile.getName()));
        if (!StringUtils.isBlank((CharSequence)imageRecord.caption())) {
            imageLines.add(XmlWriter.xmlLine("Caption", XmlWriter.xmlString(imageRecord.caption())));
        }
        return tempFile;
    }

    public static void writeXMLHeader(BufferedWriter out, LicenseCustomer licence) throws IOException {
        out.write("<?xml version = '1.0' encoding ='UTF-8' ?>\n");
        String dir = System.getProperty("user.dir");
        File root = new File(dir);
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        out.write("<StrataBugs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        out.write("xsi:noNamespaceSchemaLocation=\"https://www.stratadata.co.uk/StrataBugs/v3.0/docs/SBugsML3-0.xsd\">\n");
        XmlWriter.writeLines(out, INDENT, XmlWriter.getSectionLines("Prologue", null, List.of(XmlWriter.xmlLine("Organisation", licence.getCompany()), XmlWriter.xmlLine("Location", licence.getLocation()), XmlWriter.xmlLine("Date", DateUtils.DB_DATE_FORMAT.format(LocalDateTime.now())), XmlWriter.xmlLine("Software", "StrataBugs v3.0"))));
    }

    public static void writeTaxonList(BufferedWriter out, int indentLevel, List<Taxon> taxa, List<Genus> genera, TaxonImageService taxonImageService, ImageRecordService imageRecordService, ImageLoader imageLoader, List<File> files) throws IOException {
        ArrayList<String> taxonListContent = new ArrayList<String>();
        for (Taxon taxon : taxa) {
            List<String> taxonContent = XmlWriter.getTaxonLines(taxon);
            int typeImageSetID = taxonImageService.getTypeImageSetID(taxon.getSpecID());
            if (typeImageSetID > 0) {
                List imageRecords = imageRecordService.getImageRecords(typeImageSetID);
                ArrayList<String> imageSetLines = new ArrayList<String>();
                for (ImageRecord imageRecord : imageRecords) {
                    ArrayList<String> imageLines;
                    File file = XmlWriter.writeImage(imageRecord, imageLoader, imageLines = new ArrayList<String>());
                    if (file != null) {
                        files.add(file);
                    }
                    imageSetLines.addAll(XmlWriter.getSectionLines("Image", null, imageLines));
                }
                if (!imageSetLines.isEmpty()) {
                    taxonContent.addAll(XmlWriter.getSectionLines("ImageSet", null, imageSetLines));
                }
            }
            taxonListContent.addAll(XmlWriter.getSectionLines("Taxon", XmlWriter.sectionHeader("Species", taxon.toString()), taxonContent));
        }
        for (Genus genus : genera) {
            List<String> genusContent = XmlWriter.getGenusLines(genus);
            taxonListContent.addAll(XmlWriter.getSectionLines("Genus", XmlWriter.sectionHeader("Genus", genus.toString()), genusContent));
        }
        List<String> taxonListLines = XmlWriter.getSectionLines("TaxonList", null, taxonListContent);
        String indent = XmlWriter.getIndentString(indentLevel);
        XmlWriter.writeLines(out, indent, taxonListLines);
    }

    public static List<String> getTaxonLines(Taxon taxon) {
        List<String> lines = XmlWriter.getGenusLines(taxon.getGenus());
        if (taxon.getSpecID() > 0) {
            lines.add(XmlWriter.xmlLine("SpeciesID", "" + taxon.getSpecID()));
        }
        if (taxon.getQ1().hasQuals()) {
            lines.add(XmlWriter.xmlLine("SQ1", taxon.getQ1().toString()));
        }
        lines.add(XmlWriter.xmlLine("Species", XmlWriter.xmlString(taxon.getSpecies())));
        if (taxon.getQ2().hasQuals()) {
            lines.add(XmlWriter.xmlLine("SQ2", taxon.getQ2().toString()));
        }
        if (taxon.getQ3().hasQuals()) {
            lines.add(XmlWriter.xmlLine("SQ3", taxon.getQ3().toString()));
        }
        if (!StringUtils.isBlank((CharSequence)taxon.getSubSpecies())) {
            lines.add(XmlWriter.xmlLine("SubSpecies", XmlWriter.xmlString(taxon.getSubSpecies())));
        }
        if (taxon.getQ4().hasQuals()) {
            lines.add(XmlWriter.xmlLine("SQ4", taxon.getQ3().toString()));
        }
        if (!StringUtils.isBlank((CharSequence)taxon.getAuthor())) {
            lines.add(XmlWriter.xmlLine("Author", XmlWriter.xmlString(taxon.getAuthor())));
        }
        if (!StringUtils.isBlank((CharSequence)taxon.getAlphaCode())) {
            lines.add(XmlWriter.xmlLine("Alphacode", XmlWriter.xmlString(taxon.getAlphaCode())));
        }
        if (!StringUtils.isBlank((CharSequence)taxon.getReference())) {
            lines.add(XmlWriter.xmlLine("Reference", XmlWriter.xmlString(taxon.getReference())));
        }
        if (!StringUtils.isBlank((CharSequence)taxon.getNotes())) {
            lines.add(XmlWriter.xmlLine("Notes", XmlWriter.xmlString(taxon.getNotes())));
        }
        if (!StringUtils.isBlank((CharSequence)taxon.getUrl())) {
            lines.add(XmlWriter.xmlLine("URL", XmlWriter.xmlString(taxon.getUrl())));
        }
        return lines;
    }

    public static List<String> getGenusLines(Genus genus) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(XmlWriter.xmlLine("Category", genus.getCategory().getMnemonic()));
        lines.add(XmlWriter.xmlLine("GenusID", String.valueOf(genus.getGenID())));
        if (genus.getQ1().hasQuals()) {
            lines.add(XmlWriter.xmlLine("GQ1", genus.getQ1().toString()));
        }
        lines.add(XmlWriter.xmlLine("Genus", XmlWriter.xmlString(genus.getGenusName())));
        if (genus.getQ2().hasQuals()) {
            lines.add(XmlWriter.xmlLine("GQ2", genus.getQ2().toString()));
        }
        if (genus.getQ3().hasQuals()) {
            lines.add(XmlWriter.xmlLine("GQ3", genus.getQ3().toString()));
        }
        if (!genus.getSubGenus().isEmpty()) {
            lines.add(XmlWriter.xmlLine("SubGenus", XmlWriter.xmlString(genus.getSubGenus())));
        }
        if (genus.getQ4().hasQuals()) {
            lines.add(XmlWriter.xmlLine("GQ4", genus.getQ4().toString()));
        }
        return lines;
    }

    public static void writeSynonymy(BufferedWriter out, int indentLevel, SynonymService synonymService, TaxonService taxonService) throws IOException {
        for (Integer synSchID : synonymService.getAllSchemeIDs()) {
            ArrayList<String> schemeLines = new ArrayList<String>();
            schemeLines.add(XmlWriter.xmlLine("SchemeID", String.valueOf(synSchID)));
            schemeLines.add(XmlWriter.xmlLine("SchemeName", XmlWriter.xmlString(synonymService.getSchemeName(synSchID.intValue()))));
            Map schemeEntries = synonymService.getSchemeEntries(synSchID.intValue());
            for (Map.Entry entry : schemeEntries.entrySet()) {
                ArrayList<String> entryLines = new ArrayList<String>();
                entryLines.add(XmlWriter.xmlLine("SpeciesID", String.valueOf(entry.getKey())));
                entryLines.add(XmlWriter.xmlLine("Pref", XmlWriter.xmlString(taxonService.findTaxon(((Integer)entry.getValue()).intValue()).map(t -> t.toString(false)).orElseThrow())));
                entryLines.add(XmlWriter.xmlLine("PrefID", String.valueOf(entry.getValue())));
                String entrySectionHeader = XmlWriter.sectionHeader("Species", taxonService.findTaxon(((Integer)entry.getKey()).intValue()).map(t -> t.toString(false)).orElseThrow());
                schemeLines.addAll(XmlWriter.getSectionLines("Entry", entrySectionHeader, entryLines));
            }
            XmlWriter.writeLines(out, XmlWriter.getIndentString(indentLevel), XmlWriter.getSectionLines("SynonymScheme", XmlWriter.sectionHeader("Name", synonymService.getSchemeName(synSchID.intValue())), schemeLines));
        }
    }

    public static void writeAbundanceScheme(BufferedWriter out, int indentLevel, AbundanceScheme abundanceScheme) throws IOException {
        ArrayList<String> schemeLines = new ArrayList<String>();
        schemeLines.add(XmlWriter.xmlLine("SchemeID", String.valueOf(abundanceScheme.getAbnSchID())));
        schemeLines.add(XmlWriter.xmlLine("SchemeName", XmlWriter.xmlString(abundanceScheme.getName())));
        for (AbundanceScheme.AbundanceSchemeEntry entry : abundanceScheme.getEntries()) {
            ArrayList<String> entryLines = new ArrayList<String>();
            entryLines.add(XmlWriter.xmlLine("Name", XmlWriter.xmlString(entry.entryName())));
            entryLines.add(XmlWriter.xmlLine("Entry", XmlWriter.xmlString(entry.abr())));
            entryLines.add(XmlWriter.xmlLine("LowBound", String.valueOf(entry.lowBound())));
            entryLines.add(XmlWriter.xmlLine("OutputValue", String.valueOf(entry.outputVal())));
            schemeLines.addAll(XmlWriter.getSectionLines("Category", null, entryLines));
        }
        XmlWriter.writeLines(out, XmlWriter.getIndentString(indentLevel), XmlWriter.getSectionLines("AbundanceScheme", XmlWriter.sectionHeader("Name", abundanceScheme.getName()), schemeLines));
    }

    private static List<String> getSectionLines(String sectionTag, String sectionHeader, List<String> content) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<" + sectionTag + (String)(sectionHeader != null ? " " + sectionHeader : "") + ">");
        for (String line : content) {
            lines.add(INDENT + line);
        }
        lines.add("</" + sectionTag + ">");
        return lines;
    }

    private static String xmlLine(String tag, String content) {
        return "<" + tag + ">" + content + "</" + tag + ">";
    }

    private static String sectionHeader(String name, String value) {
        return name + "=\"" + XmlWriter.xmlString(value) + "\"";
    }

    private static String xmlString(String s) {
        return StringEscapeUtils.escapeXml10((String)s);
    }

    public static void writeLines(BufferedWriter out, String indent, List<String> content) throws IOException {
        for (String line : content) {
            out.write(indent + line);
            out.newLine();
        }
    }
}

