/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model3.Audit;
import model3.EnvScheme;
import model3.SBdb;
import org.jdom2.Element;
import util.ColourUtils;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPrivilegeException;
import util.SortEntry;
import util.exception.StackError;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class AnalystHeader
implements SortEntry,
SbugsStatus {
    private final SBdb sbdb;
    private final int analyID;
    private int analyst;
    private Discipline discID;
    private int analyNumber;
    private Date from;
    private Date to;
    private String comments;
    private Double depthFrom;
    private Double depthTo;
    private int envSchID = 0;
    private int abnSchID = 0;
    private Color colour = null;
    private Audit audit = new Audit();
    private AnalystHeader link = null;
    Color status = UNKNOWN;

    public int getAnalyNumber() {
        return this.analyNumber;
    }

    public int getAnalyID() {
        return this.analyID;
    }

    public String getAnalyst() throws SQLException {
        Userdef user;
        if (this.analyst > 0 && (user = this.sbdb.getUser(this.analyst)) != null) {
            return user.getAbr();
        }
        return "";
    }

    public String toString() {
        Object strg = super.toString();
        if (this.analyst > 0) {
            try {
                Userdef user = this.sbdb.getUser(this.analyst);
                if (user != null) {
                    return user.getAbr() + "/" + this.analyNumber;
                }
            }
            catch (Exception ex) {
                strg = (String)strg + ex.getMessage();
            }
        }
        return strg;
    }

    public String getAnalystv18() throws SQLException, SBException {
        Userdef user;
        if (this.analyst > 0 && (user = this.sbdb.getUser(this.analyst)) != null) {
            return user.getAbr() + String.valueOf(this.analyNumber > 1 ? Integer.valueOf(this.analyNumber) : "");
        }
        return "";
    }

    public int getAnalystUsrid() {
        return this.analyst;
    }

    public AnalystHeader getLink() {
        return this.link;
    }

    public Color getColour() throws SQLException {
        if (this.colour == null) {
            return this.sbdb.getUser(this.analyst).getColour();
        }
        return this.colour;
    }

    public char getDiscID() {
        return this.discID.getChar();
    }

    public Discipline getDiscipline() {
        return this.discID;
    }

    public Date getDateFrom() {
        return this.from;
    }

    public Date getDateTo() {
        return this.to;
    }

    public Double getDepthFrom() {
        return this.depthFrom;
    }

    public Double getDepthTo() {
        return this.depthTo;
    }

    public String getComments() {
        return this.comments;
    }

    public int getEnvSchID() {
        return this.envSchID;
    }

    public int getAbnSchID() {
        return this.abnSchID;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    private void checkFields() {
        if (this.sbdb == null) {
            throw new IllegalStateException("Attempt to create AnalystHeader with null data model");
        }
        if (this.discID == null) {
            throw new IllegalStateException("Attempt to create AnalystHeader with null Discipline");
        }
        if (this.analyst <= 0) {
            throw new IllegalStateException("Attempt to create AnalystHeader with illegal analyst: " + this.analyst);
        }
        if (this.analyNumber <= 0) {
            throw new IllegalStateException("Attempt to create AnalystHeader with illegal suite no.:" + this.analyNumber);
        }
    }

    private AnalystHeader(SBdb sbdb, int analyID) {
        this.sbdb = sbdb;
        this.analyID = analyID;
    }

    static AnalystHeader copyToWorkspace(SBdb ws, AnalystHeader dbHdr) throws SQLException, SBException {
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attepmt to copy AnalystHeader to connected workspace");
        }
        AnalystHeader wsHdr = new AnalystHeader(ws, dbHdr.getAnalyID());
        wsHdr.copy(dbHdr);
        wsHdr.audit.fillWorkspace(dbHdr.sbdb, ws);
        ws.fillUser(dbHdr.sbdb, wsHdr.analyst);
        if (wsHdr.abnSchID > 0) {
            ws.fillAbundanceScheme(dbHdr.sbdb, wsHdr.abnSchID);
        }
        if (wsHdr.envSchID > 0) {
            ws.fillEnvScheme(dbHdr.sbdb, wsHdr.envSchID);
        }
        wsHdr.link = dbHdr;
        wsHdr.checkFields();
        return wsHdr;
    }

    AnalystHeader(SBdb sbdb, int wellID, String analyst, Discipline discID, int analyNo, int maxAnaly) throws SQLException, SBException {
        this.sbdb = sbdb;
        if (sbdb.getUser(analyst) == null) {
            sbdb.getAddUserID(analyst);
        }
        this.analyID = sbdb.isConnected() ? this.store(sbdb, wellID, sbdb.getUserID(analyst), discID, analyNo) : maxAnaly + 1;
        this.analyst = sbdb.getUserID(analyst);
        this.discID = discID;
        this.analyNumber = analyNo;
        this.checkFields();
        if (this.analyID <= 0) {
            throw new IllegalStateException("Attempt to create AnalystHeader with illegal analyID: " + this.analyID);
        }
    }

    AnalystHeader(SBdb sbdb, int wellID, int analyID) throws SQLException, SBException {
        this.sbdb = sbdb;
        this.analyID = analyID;
        String sql = "SELECT disc_id,analyst,analy_no,date_from,date_to,depth_from,depth_to,comments,envsch_id,abnsch_id,colour," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("ANALY_HDR") + " WHERE well_id=" + wellID + " AND analy_id=" + analyID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                this.discID = Discipline.getDisc((char)SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                this.analyst = rs.getInt("analyst");
                if (sbdb.getUser(this.analyst) == null) {
                    throw new SBException("Analyst Header with no Userdef");
                }
                this.analyNumber = rs.getInt("analy_no");
                this.from = rs.getDate("date_from");
                this.to = rs.getDate("date_to");
                this.depthFrom = rs.getDouble("depth_from");
                this.depthTo = rs.getDouble("depth_to");
                this.comments = rs.getString("comments");
                this.envSchID = rs.getInt("envsch_id");
                this.abnSchID = rs.getInt("abnsch_id");
                this.colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                this.audit = new Audit(rs);
            }
        }
        this.checkFields();
    }

    static synchronized AnalystHeader refresh(Statement stmt, SBdb SB2, int wellID, List<AnalystHeader> list) throws SQLException, SBException {
        if (list == null) {
            return null;
        }
        Object sql = "SELECT analy_id,updated ";
        sql = (String)sql + " FROM " + SB2.DBTableName("ANALY_HDR") + " WHERE well_id=" + wellID;
        sql = SB2.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        AnalystHeader notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("analy_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (AnalystHeader o : list) {
                if (o.getAnalyID() != key) continue;
                found = true;
                if (time == null || !time.after(o.getUpdated())) break;
                AnalystHeader hdr = new AnalystHeader(SB2, wellID, key);
                o.copy(hdr);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = new AnalystHeader(SB2, wellID, key);
            list.add(notifier);
        }
        if (keys.size() < list.size()) {
            Iterator<AnalystHeader> it = list.iterator();
            while (it.hasNext()) {
                AnalystHeader o = it.next();
                if (keys.contains(o.getAnalyID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    static void loadAll(SBdb sbdb, int wellID, List<AnalystHeader> list) throws SQLException {
        String sql = "SELECT analy_id,disc_id,analyst,analy_no,date_from,date_to,depth_from,depth_to,comments,envsch_id,abnsch_id,colour," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("ANALY_HDR") + " WHERE well_id=" + wellID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int id = rs.getInt("analy_id");
                AnalystHeader hdr = new AnalystHeader(sbdb, id);
                hdr.discID = Discipline.getDisc((char)SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                hdr.analyst = rs.getInt("analyst");
                hdr.analyNumber = rs.getInt("analy_no");
                hdr.from = rs.getDate("date_from");
                hdr.to = rs.getDate("date_to");
                BigDecimal depthFromDec = SB.getBigDecimal((ResultSet)rs, (String)"depth_from", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0);
                hdr.depthFrom = depthFromDec == null ? null : Double.valueOf(depthFromDec.doubleValue());
                BigDecimal depthToDec = SB.getBigDecimal((ResultSet)rs, (String)"depth_to", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0);
                hdr.depthTo = depthToDec == null ? null : Double.valueOf(depthToDec.doubleValue());
                hdr.comments = rs.getString("comments");
                hdr.envSchID = rs.getInt("envsch_id");
                hdr.abnSchID = rs.getInt("abnsch_id");
                hdr.colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                hdr.audit = new Audit(rs);
                hdr.checkFields();
                list.add(hdr);
            }
        }
    }

    AnalystHeader(SBdb sbdb, int wellID, String analyst, Discipline discID, int analyNo, Date from, Date to, Double depthFrom, Double depthTo, String comments, int envSchID, int abnSchID, Color colour) throws SQLException, SBException {
        this.sbdb = sbdb;
        this.analyst = sbdb.getUserID(analyst);
        if (this.analyst == 0) {
            Userdef user = sbdb.addUser(analyst, analyst, "", discID, Color.BLACK, null, 0);
            this.analyst = user.getUsrID();
        }
        if (discID == null) {
            System.out.println("Warning: discID zero for analystHeader: reset to 'M'");
            discID = Discipline.MICRO;
        }
        this.discID = discID;
        this.analyNumber = analyNo;
        this.from = from;
        this.to = to;
        this.depthFrom = depthFrom;
        this.depthTo = depthTo;
        this.comments = comments;
        this.envSchID = envSchID;
        this.abnSchID = abnSchID;
        this.colour = colour;
        this.checkFields();
        this.analyID = this.store(sbdb, wellID, this.analyst, discID, analyNo);
        if (this.analyID <= 0) {
            throw new IllegalStateException("Attempt to create AnalystHeader with illegal analyID: " + this.analyID);
        }
    }

    public void setAbnScheme(int abnSchemeID) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected() && this.abnSchID > 0 && abnSchemeID != this.abnSchID) {
            throw new SBException("Attempt to change abundance schemne in Analyst Header");
        }
        this.abnSchID = abnSchemeID;
    }

    public void setEnvScheme(int envSchemeID) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set abundance schemne in Analyst Header");
        }
        this.envSchID = envSchemeID;
    }

    public void setAbnScheme(int wellID, int abnSchemeID) throws SQLException, SBException {
        if (wellID == 0 || this.analyID == 0) {
            throw new SBException("Attempt to set analyst header with null well or analy ID");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + this.sbdb.DBTableName("ANALY_HDR") + " SET abnsch_id=" + abnSchemeID + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND analy_id=" + this.analyID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.abnSchID = abnSchemeID;
            this.audit = temp;
        }
    }

    void replaceAbnScheme(int abnSchID) {
        this.abnSchID = abnSchID;
    }

    private int store(SBdb sbdb, int wellID, int analyst, Discipline discID, int analyNo) throws SQLException, SBException {
        if (sbdb.restrictedToDiscID(discID)) {
            throw new SBPrivilegeException("Attempt to update header when restricted to: " + sbdb.getUser().getDiscipline().getNoun());
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "SELECT max(analy_id) AS maxanaly_id FROM " + sbdb.DBTableName("ANALY_HDR") + " WHERE well_id=" + wellID;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            int aID = 0;
            if (rs.next()) {
                aID = rs.getInt("maxanaly_id");
            }
            ++aID;
            Userdef analystU = sbdb.getUser(analyst);
            if (analystU == null) {
                throw new SBException("Cannot find analyst for ID: " + analyst + " in AnalystHeader.save");
            }
            int analystID = analystU.getUsrID();
            sql = "INSERT INTO " + sbdb.DBTableName("ANALY_HDR") + " (analy_id,well_id,disc_id,analyst,analy_no,date_from,date_to,depth_from,depth_to,comments,abnsch_id,envsch_id,";
            if (this.colour != null) {
                sql = sql + "colour,";
            }
            sql = sql + Audit.sqlFieldString() + ") VALUES (" + aID + "," + wellID + "," + SB.DBChar((char)Discipline.getChar((Discipline)discID)) + "," + analystID + "," + analyNo + "," + (this.from != null ? SB.DBString((String)SB.DBdf.format(this.from)) : "NULL") + "," + (this.to != null ? SB.DBString((String)SB.DBdf.format(this.to)) : "NULL") + "," + this.depthFrom + "," + this.depthTo + "," + SB.DBString((String)this.comments) + "," + String.valueOf(this.abnSchID > 0 ? Integer.valueOf(this.abnSchID) : "NULL") + "," + String.valueOf(this.envSchID > 0 ? Integer.valueOf(this.envSchID) : "NULL") + ",";
            if (this.colour != null) {
                sql = sql + ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)true) + ",";
            }
            sql = sql + temp.sqlInsert(sbdb, stmt) + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.audit = temp;
            int n = aID;
            return n;
        }
    }

    void updateDetails(int wellID, int analyst, Discipline discID, int analyNo) throws SQLException {
        String sql = "UPDATE " + this.sbdb.DBTableName("ANALY_HDR") + " SET analyst=" + analyst + ",disc_id=" + SB.DBChar((char)discID.getChar()) + ",analy_no=" + analyNo + " WHERE analy_ID=" + this.analyID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.analyst = analyst;
        this.discID = discID;
        this.analyNumber = analyNo;
    }

    private void copy(AnalystHeader rhs) {
        this.analyst = rhs.analyst;
        this.discID = rhs.discID;
        this.analyNumber = rhs.analyNumber;
        this.depthFrom = rhs.depthFrom == null ? null : rhs.depthFrom;
        this.depthTo = rhs.depthTo == null ? null : rhs.depthTo;
        this.from = rhs.from == null ? null : new Date(rhs.from.getTime());
        this.to = rhs.to == null ? null : new Date(rhs.to.getTime());
        this.comments = rhs.comments;
        this.abnSchID = rhs.abnSchID;
        this.envSchID = rhs.envSchID;
        this.colour = rhs.colour;
        this.audit = new Audit(rhs.audit);
    }

    void update(int wellID, double top, double base, Date from, Date to, String comments, int envSchID, int abnSchID, Color colour) throws SQLException, SBException {
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("ANALY_HDR") + " SET ";
            sql = sql + "date_from=" + (from != null ? SB.DBString((String)SB.DBdf.format(from)) : "NULL") + ",";
            sql = sql + "date_to=" + (from != null ? SB.DBString((String)SB.DBdf.format(to)) : "NULL") + ",";
            sql = sql + "depth_from=" + top + ",";
            sql = sql + "depth_to=" + base + ",";
            sql = sql + "comments=" + SB.DBString((String)comments) + ",";
            sql = sql + "abnsch_id=" + String.valueOf(abnSchID > 0 ? Integer.valueOf(abnSchID) : "NULL") + ",";
            sql = sql + "envsch_id=" + String.valueOf(envSchID > 0 ? Integer.valueOf(envSchID) : "NULL") + ",";
            sql = sql + "colour=" + ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)true) + ",";
            sql = sql + temp.sqlUpdate(this.sbdb, stmt, false);
            sql = sql + " WHERE well_id=" + wellID + " AND analy_id=" + this.analyID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.depthFrom = top;
        this.depthTo = base;
        this.from = from;
        this.to = to;
        this.comments = comments;
        this.envSchID = envSchID;
        this.abnSchID = abnSchID;
        this.colour = colour;
        this.audit = temp;
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        if (this.analyID > 0) {
            out.write((String)ind + "<AnalysisID>" + this.analyID + "</AnalysisID>\n");
        }
        if (this.discID != null) {
            out.write((String)ind + "<DisciplineID>" + this.discID.getChar() + "</DisciplineID>\n");
        }
        if (this.analyst > 0) {
            out.write((String)ind + "<Analyst>" + this.analyst + "</Analyst>\n");
            userIDs.add(this.analyst);
        }
        if (this.analyNumber > 0) {
            out.write((String)ind + "<AnalysisNumber>" + this.analyNumber + "</AnalysisNumber>\n");
        }
        if (this.from != null) {
            out.write((String)ind + "<DateFrom>" + SB.DBdf.format(this.from) + "</DateFrom>\n");
        }
        if (this.to != null) {
            out.write((String)ind + "<DateTo>" + SB.DBdf.format(this.to) + "</DateTo>\n");
        }
        if (this.depthFrom != null) {
            out.write((String)ind + "<DepthFrom>" + SB.getDepthString((double)this.depthFrom, (char)units, (int)2).trim() + "</DepthFrom>\n");
        }
        if (this.depthTo != null) {
            out.write((String)ind + "<DepthTo>" + SB.getDepthString((double)this.depthTo, (char)units, (int)2).trim() + "</DepthTo>\n");
        }
        if (this.comments != null) {
            out.write((String)ind + "<Comments>" + SB.getXMLstring((String)this.comments) + "</Comments>\n");
        }
        if (this.envSchID > 0) {
            out.write((String)ind + "<EnvironmentSchemeID>" + this.envSchID + "</EnvironmentSchemeID>\n");
        }
        if (this.abnSchID > 0) {
            out.write((String)ind + "<AbundanceSchemeID>" + this.abnSchID + "</AbundanceSchemeID>\n");
        }
        userIDs.addAll(this.audit.writeXML(out, indent));
        return userIDs;
    }

    AnalystHeader(SBdb db, Element xml) throws SBException, ParseException, SQLException {
        Element el;
        this.sbdb = db;
        String strgID = xml.getChildTextNormalize("AnalysisID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        this.analyID = Integer.parseInt(strgID);
        String strg = xml.getChildTextNormalize("DisciplineID");
        if (strg != null && strg.length() > 0) {
            this.discID = Discipline.getDisc((char)strg.charAt(0));
        }
        if ((strg = xml.getChildTextNormalize("Analyst")) != null) {
            this.analyst = Integer.parseInt(strg);
            if (db.getUser(this.analyst) == null) {
                throw new SBException("Userdef not found for analyst: " + this.analyst + " in Analyst Header");
            }
        }
        if ((strg = xml.getChildTextNormalize("AnalysisNumber")) != null) {
            this.analyNumber = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("DateFrom")) != null) {
            this.from = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("DateTo")) != null) {
            this.to = SB.DBdf.parse(strg);
        }
        if ((strg = xml.getChildTextNormalize("DepthFrom")) != null) {
            this.depthFrom = DepthUtils.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("DepthTo")) != null) {
            this.depthTo = DepthUtils.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("Comments")) != null) {
            this.comments = strg;
        }
        if ((strg = xml.getChildTextNormalize("EnvironmentSchemeID")) != null) {
            this.envSchID = Integer.parseInt(strg);
        }
        if ((strg = xml.getChildTextNormalize("AbundanceSchemeID")) != null) {
            this.abnSchID = Integer.parseInt(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for analyst header: " + String.valueOf(this));
        }
        this.checkFields();
    }

    public String getSortEntry() {
        Object analystString = "";
        if (this.analyst > 0) {
            try {
                Userdef user = this.sbdb.getUser(this.analyst);
                if (user != null) {
                    analystString = user.getAbr();
                }
            }
            catch (Exception ex) {
                StackError.showStackError((String)"Error getting AnalystHeader sortEntry: ", (Throwable)ex);
            }
        } else {
            analystString = (String)analystString + this.analyst;
        }
        return String.valueOf(this.discID) + "/" + (String)analystString + "/" + this.analyNumber;
    }

    public boolean hasData(int wellID) throws SQLException {
        boolean hasData;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT well_id FROM " + this.sbdb.DBTableName("SMPDTL") + " WHERE well_id=" + wellID + " AND analy_ID=" + this.analyID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            hasData = false;
            if (rs.next()) {
                hasData = true;
            }
        }
        return hasData;
    }

    public void setAnalyNo(int no) throws SBException, SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set suite number in database analyst header");
        }
        this.analyNumber = no;
    }

    public Color updateStatus(List<AnalystHeader> hdrs) throws SQLException, SBException {
        this.status = NOTSTORED;
        for (AnalystHeader hdr : hdrs) {
            Integer linkScheme;
            if (!hdr.getSortEntry().equals(this.getSortEntry())) continue;
            this.status = STORED;
            MergeStatus m = new MergeStatus(this.status);
            if (this.envSchID > 0) {
                EnvScheme scheme = this.sbdb.getEnvScheme(this.envSchID);
                if (scheme == null) {
                    this.envSchID = -1;
                } else {
                    EnvScheme linkScheme2 = this.sbdb.getEnvScheme(this.envSchID).getLink();
                    if (linkScheme2 != null) {
                        m.compareIntField("EnvSchID", linkScheme2.getID(), hdr.getEnvSchID());
                    }
                }
            }
            if (this.abnSchID > 0 && (linkScheme = ((AbundanceSchemeServiceImpl)this.sbdb.getAbundanceSchemeService()).getLink(this.abnSchID)) != null) {
                m.compareIntField("AbnSchID", linkScheme.intValue(), hdr.getAbnSchID());
            }
            this.status = m.getStatus();
        }
        return this.status;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.getSortEntry();
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for sample: " + String.valueOf(this));
        }
        this.analyst = analyst.getUsrID();
        this.audit.setAnalyst(analyst.getUsrID());
    }
}

