/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import model3.Audit;
import model3.CompositeStandardEventBase;
import model3.EventCompareCSU;
import model3.SBEvent;
import model3.SBdb;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class CompositeStandardEvent
implements Comparable,
SortEntry,
SbugsStatus,
CompositeStandardEventBase {
    private final SBdb sbdb;
    private SBEvent sbEvent;
    private double csu;
    private Double errPlus = null;
    private Double errMinus = null;
    private EventType type;
    private Audit audit = new Audit();
    private Color status = UNKNOWN;
    private String comments;
    public static final int MAX_COMMENT_LENGTH = 1000;
    private Confidence confidence;
    public static final int SORTALPHA = 0;
    public static final int SORTCSU_UP = 1;
    public static final int SORTCSU_DOWN = 2;
    private int stdID = 0;

    public char getEvType() {
        return this.type.getChar();
    }

    public String getEvTypeString() {
        return CompositeStandardEvent.getEvTypeString(this.type);
    }

    public static String getEvTypeString(EventType type) {
        return type.toString(EventContext.SCHEME);
    }

    public int getEvID() {
        return this.sbEvent.getEvID();
    }

    public int getStdID() {
        return this.stdID;
    }

    void setStdID(int ID) {
        this.stdID = ID;
    }

    @Override
    public double getCSU() {
        return this.csu;
    }

    @Override
    public double getMinCSU() {
        if (this.errMinus != null) {
            return this.csu - this.errMinus;
        }
        return this.csu;
    }

    @Override
    public double getMaxCSU() {
        if (this.errPlus != null) {
            return this.csu + this.errPlus;
        }
        return this.csu;
    }

    @Override
    public Double getErrPlus() {
        return this.errPlus;
    }

    @Override
    public Double getErrMinus() {
        return this.errMinus;
    }

    public String getName() {
        return this.sbEvent.getName();
    }

    @Override
    public SBEvent getEvent() {
        return this.sbEvent;
    }

    @Override
    public EventType getType() {
        return this.type;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public String getComments() {
        return this.comments;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    Audit getAuditObj() {
        return this.audit;
    }

    Date getUpdated() {
        return new Date(this.audit.updated.getTime());
    }

    public String toString() {
        return this.toString(true, true, false, false, false);
    }

    public String toStringName() {
        return this.toString(true, false, false, false, false);
    }

    public String toString(boolean type, boolean csu, boolean confidence, boolean abr, boolean eventName) {
        Object strg = "";
        String pfx = this.sbEvent.getPrefix(this.type, EventContext.SCHEME, type);
        if (pfx != null) {
            strg = (String)strg + pfx + " ";
        }
        strg = (String)strg + this.sbEvent.toString(false, abr, eventName, false);
        if (csu) {
            strg = this.csu + " " + (String)strg;
        }
        if (confidence && this.confidence != Confidence.CONFIDENT) {
            strg = (String)strg + " (" + String.valueOf(this.confidence) + ")";
        }
        return strg;
    }

    public int compareTo(Object o) {
        CompositeStandardEvent rhs = (CompositeStandardEvent)o;
        return this.sbEvent.compareTo(rhs.sbEvent);
    }

    public static void sort(List<CompositeStandardEvent> events, int sort) {
        switch (sort) {
            case 0: {
                Collections.sort(events);
                break;
            }
            case 1: {
                Collections.sort(events, new EventCompareCSU(false));
                break;
            }
            case 2: {
                Collections.sort(events, new EventCompareCSU(true));
            }
        }
    }

    static Builder parse(SBdb ws, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        Builder builder = new Builder();
        String strg = xml.getChildTextNormalize("EventID");
        if (strg != null) {
            int eventID = Integer.parseInt(strg);
            builder.event(ws.getSBEvent(eventID));
        }
        if ((strg = xml.getChildTextNormalize("CSU")) != null) {
            builder.csu(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("CSUPLUS")) != null) {
            builder.errPlus(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("CSUMINUS")) != null) {
            builder.errMinus(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.length() > 0) {
            builder.type(EventType.getType((String)strg));
        }
        if ((strg = xml.getChildTextNormalize("Comments")) != null && strg.length() > 0) {
            builder.comment(strg);
        }
        if ((strg = xml.getChildTextNormalize("Uncertainty")) != null && strg.length() > 0) {
            builder.confidence(Confidence.getConfidence((int)Integer.parseInt(strg)));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(ws, el));
        }
        return builder;
    }

    void writeXML(BufferedWriter out, String ind) throws IOException {
        out.write(ind + "<EventID>" + this.sbEvent.getEvID() + "</EventID>\n");
        out.write(ind + "<CSU>" + this.csu + "</CSU>\n");
        if (this.errPlus != null) {
            out.write(ind + "<CSUPLUS>" + this.errPlus + "</CSUPLUS>\n");
        }
        if (this.errMinus != null) {
            out.write(ind + "<CSUMINUS>" + this.errMinus + "</CSUMINUS>\n");
        }
        out.write(ind + "<Type>" + this.type.name() + "</Type>\n");
        if (this.comments != null && !this.comments.isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.comments) + "</Comments>\n");
        }
        if (this.confidence.getDBint() > 0) {
            out.write(ind + "<Uncertainty>" + this.confidence.getDBint() + "</Uncertainty>\n");
        }
        this.audit.writeXML(out, ind.length());
    }

    public void setCsu(double csu, Double errPlus, Double errMinus) throws SBException {
        if (this.sbdb != null) {
            throw new SBException("Attempt to set CSU for event: " + String.valueOf(this));
        }
        this.csu = csu;
        this.errPlus = errPlus;
        this.errMinus = errMinus;
    }

    void updateCsu(int stdID, double csu, Double errPlus, Double errMinus, Confidence conf) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTDEV") + " SET csu=" + csu;
            sql = sql + ",csuplus=" + errPlus;
            sql = sql + ",csuminus=" + errMinus;
            sql = sql + ",confidence=" + conf.getDBint() + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + stdID + " AND ev_id=" + this.sbEvent.getEvID() + " AND ev_type=" + SB.DBChar((char)this.type.getChar());
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.csu = csu;
        this.errPlus = errPlus;
        this.errMinus = errMinus;
        this.confidence = conf;
    }

    static boolean updateType(SBdb db, int evID, boolean single, Boolean updateSingleToTops) throws SQLException {
        assert (single || updateSingleToTops != null);
        try (Statement stmt = db.getDatabase().createStatement();){
            Audit audit = new Audit();
            String sql = "UPDATE " + db.DBTableName("CMPSTDEV") + " SET ev_type=" + SB.DBChar((char)(single ? 83 : (updateSingleToTops != false ? 70 : 76))) + "," + audit.sqlUpdate(db, stmt, false) + " WHERE ev_id=" + evID;
            int nRows = stmt.executeUpdate(db.modQuery(sql));
            boolean bl = nRows > 0;
            return bl;
        }
    }

    void setUpdated(int updater, Date updated) {
        this.audit.updater = updater;
        this.audit.updated = updated;
    }

    void updateComments(int stdID, String comments) throws SQLException, SBException {
        if (this.stdID != stdID) {
            throw new SBException("Attempt to update event comments in inherited scheme");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("CMPSTDEV") + " SET comments=" + SB.DBString((String)comments);
            sql = sql + "," + this.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE std_id=" + stdID + " AND ev_id=" + this.sbEvent.getEvID() + " AND ev_type=" + SB.DBChar((char)this.type.getChar());
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.comments = comments;
    }

    void setSBEvent(SBEvent event) {
        this.sbEvent = event;
    }

    void setType(EventType type) {
        this.type = type;
    }

    public String getSortEntry() {
        String sortEntry = this.sbEvent.getName().toUpperCase() + "-" + this.type.toString();
        String pfx = this.sbEvent.getPrefix(this.type, EventContext.SCHEME, false);
        if (pfx != null) {
            sortEntry = sortEntry + "-" + pfx;
        }
        return sortEntry;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public Color getStatus() {
        return this.status;
    }

    public void setStatus(Color status) {
        this.status = status;
    }

    public String statusString() {
        return this.toString();
    }

    public Discipline getDisc() {
        if (this.sbEvent.getTaxon() == null) {
            return null;
        }
        return this.sbEvent.getTaxon().getDisc();
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for composite standard event: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private CompositeStandardEvent(Builder builder, SBdb sbdb) {
        this.sbdb = sbdb;
        this.sbEvent = builder.sbEvent;
        this.type = builder.type;
        this.csu = builder.csu;
        this.errPlus = builder.errPlus;
        this.errMinus = builder.errMinus;
        this.confidence = builder.confidence;
        this.comments = builder.comments;
        this.audit = builder.audit;
        this.status = NOTSTORED;
    }

    static CompositeStandardEvent loadEvent(SBdb sbdb, int stdID, String key, CompositeStandardEvent o) throws SQLException {
        String evType = "" + key.charAt(0);
        int evID = Integer.parseInt(key.substring(2));
        Object sql = "SELECT csu,confidence,comments,csuplus,csuminus,";
        sql = (String)sql + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("CMPSTDEV") + " WHERE std_id=" + stdID + " AND ev_id=" + evID + " AND ev_type=" + SB.DBString((String)evType);
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery((String)sql));
            if (rs.next()) {
                EventType type = EventType.getType((String)evType);
                SBEvent sbEvent = sbdb.getSBEvent(evID);
                if (sbEvent.getEvID() > 0) {
                    Builder builder = new Builder();
                    builder.type(type).event(sbEvent).csu(rs.getDouble("csu")).confidence(Confidence.getConfidence((int)rs.getInt("confidence"))).comment(rs.getString("comments"));
                    Double f = rs.getDouble("csuplus");
                    if (!rs.wasNull()) {
                        builder.errPlus(f);
                    }
                    f = rs.getDouble("csuminus");
                    if (!rs.wasNull()) {
                        builder.errMinus(f);
                    }
                    builder.audit(new Audit(rs));
                    CompositeStandardEvent e = builder.build(sbdb);
                    e.stdID = stdID;
                    if (o != null) {
                        o.csu = e.csu;
                        o.errPlus = e.errPlus;
                        o.errMinus = e.errMinus;
                        o.comments = e.comments;
                        o.confidence = e.confidence;
                        o.audit = e.audit;
                        CompositeStandardEvent compositeStandardEvent = o;
                        return compositeStandardEvent;
                    }
                    CompositeStandardEvent compositeStandardEvent = e;
                    return compositeStandardEvent;
                }
            }
        }
        return null;
    }

    public static class Builder
    implements CompositeStandardEventBase,
    Comparable<Builder> {
        private SBEvent sbEvent;
        private EventType type;
        private double csu;
        private Double errPlus = null;
        private Double errMinus = null;
        private String comments;
        private Confidence confidence = Confidence.CONFIDENT;
        Audit audit = new Audit();
        public boolean inheritedFromParent = false;
        public Builder matchingParentEvent;
        public boolean excluded = false;

        CompositeStandardEvent build(SBdb sbdb) {
            this.verify();
            return new CompositeStandardEvent(this, sbdb);
        }

        public void verify() {
            if (this.sbEvent == null) {
                throw new IllegalStateException("Attempt to build CmpStdEvent with null event");
            }
            if (this.type == null) {
                this.type = EventType.SINGLE;
            }
            if (!this.sbEvent.hasEvType(this.type)) {
                throw new IllegalStateException("Attempt to build CmpStdEvent: " + this.sbEvent.getName() + ", ID=" + this.sbEvent.getEvID() + " with unrecognised event type: " + String.valueOf(this.type) + " at age: " + this.getCSU());
            }
        }

        public static Builder copyOf(CompositeStandardEvent rhs) {
            return new Builder().type(rhs.type).csu(rhs.csu).audit(new Audit(rhs.audit)).comment(rhs.comments).confidence(rhs.confidence).errPlus(rhs.errPlus).errMinus(rhs.errMinus);
        }

        public Builder event(SBEvent event) {
            this.sbEvent = event;
            return this;
        }

        public Builder csu(double csu) {
            if (csu >= 0.0) {
                this.csu = csu;
            }
            return this;
        }

        public Builder errPlus(Double errPlus) {
            this.errPlus = errPlus;
            return this;
        }

        public Builder errMinus(Double errMinus) {
            this.errMinus = errMinus;
            return this;
        }

        public Builder type(EventType type) {
            this.type = type;
            return this;
        }

        public Builder comment(String comment) {
            this.comments = comment != null && !comment.trim().isEmpty() ? comment.trim() : null;
            return this;
        }

        public Builder confidence(Confidence confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        public void clearAuditModifier() {
            if (this.audit != null) {
                this.audit.modified = null;
                this.audit.modifier = 0;
            }
        }

        @Override
        public SBEvent getEvent() {
            return this.sbEvent;
        }

        @Override
        public EventType getType() {
            return this.type;
        }

        @Override
        public double getCSU() {
            return this.csu;
        }

        @Override
        public double getMinCSU() {
            return this.errMinus != null ? this.csu - this.errMinus : this.csu;
        }

        @Override
        public double getMaxCSU() {
            return this.errPlus != null ? this.csu + this.errPlus : this.csu;
        }

        @Override
        public Double getErrPlus() {
            return this.errPlus;
        }

        @Override
        public Double getErrMinus() {
            return this.errMinus;
        }

        public Confidence getConfidence() {
            return this.confidence;
        }

        public String getComments() {
            return this.comments;
        }

        public Date getModified() {
            return this.audit.getModified();
        }

        public String getModifier(SBdb sbdb) {
            try {
                if (this.audit.modifier > 0) {
                    return sbdb.getUser(this.audit.modifier).getAbr();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return "";
        }

        @Override
        public int compareTo(Builder o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            if (this.sbEvent != null && this.type != null) {
                return this.sbEvent.toString(this.type, false, false, false);
            }
            return super.toString();
        }
    }
}

