/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import model3.SBdb;
import util.SB;

public class CoreImage {
    private final SBdb db;
    private double topDepth;
    private double baseDepth;
    private int imageID;

    CoreImage(SBdb db, int wellID, double topDepth, double baseDepth, int imageID) throws SQLException {
        String sql = "INSERT INTO " + db.DBTableName("COREIMAGE") + " (well_id,top_depth,base_depth,image_id) VALUES (" + wellID + "," + topDepth + "," + baseDepth + "," + imageID + ")";
        Statement stmt = db.getDatabase().createStatement();
        stmt.executeUpdate(db.modQuery(sql));
        stmt.close();
        this.db = db;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.imageID = imageID;
    }

    CoreImage(SBdb db, CoreImage rhs) {
        this(db, rhs.topDepth, rhs.baseDepth, rhs.imageID);
    }

    private CoreImage(SBdb SB2, double topDepth, double baseDepth, int imageID) {
        this.db = SB2;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.imageID = imageID;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public int getImageID() {
        return this.imageID;
    }

    static void load(int wellID, SBdb SB2, List<CoreImage> coreImages) throws SQLException {
        String sql = "SELECT top_depth,base_depth,image_id FROM " + SB2.DBTableName("COREIMAGE") + " WHERE well_id=" + wellID;
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            double topDepth = rs.getDouble("top_depth");
            double baseDepth = rs.getDouble("base_depth");
            int imageID = rs.getInt("image_id");
            CoreImage coreImage = new CoreImage(SB2, topDepth, baseDepth, imageID);
            coreImages.add(coreImage);
        }
        stmt.close();
    }

    void delete(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.db.DBTableName("COREIMAGE") + " WHERE well_id=" + wellID + " AND image_id=" + this.imageID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            stmt.executeUpdate(this.db.modQuery(sql));
        }
        this.db.getImageRecordService().deleteImageRecord(this.imageID);
    }

    void writeXML(FileWriter out, int indent, char units) throws IOException {
        Object ind = "";
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<CoreImage>\n");
        if (this.getTopDepth() > 0.0) {
            out.write((String)ind + "<TopDepth>" + SB.getDepthString((double)this.getTopDepth(), (char)units, (int)2) + "</TopDepth>\n");
        }
        if (this.getBaseDepth() > 0.0) {
            out.write((String)ind + "<BaseDepth>" + SB.getDepthString((double)this.getBaseDepth(), (char)units, (int)2) + "</BaseDepth>\n");
        }
        out.write("<CoreImage>\n");
    }
}

